/*
 * Copyright (c) 2011 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ftgl;

import com.sun.jna.Structure;

public class TT_Header extends Structure {

	/**
	 * FT_Fixed   Table_Version;
	 */
	public int Table_Version;

	/**
	 * FT_Fixed   Font_Revision;
	 */
	public int Font_Revision;

	/**
	 * FT_Long    CheckSum_Adjust;
	 */
	public int CheckSum_Adjust;

	/**
	 * FT_Long    Magic_Number;
	 */
	public int Magic_Number;

	/**
	 * FT_UShort  Flags;
	 */
	public short Flags;

	/**
	 * FT_UShort  Units_Per_EM;
	 */
	public short Units_Per_EM;

	/**
	 * FT_Long    Created [2];
	 */
	public int[] Created = new int[2];

	/**
	 * FT_Long    Modified[2];
	 */
	public int[] Modified = new int[2];

	/**
	 * FT_Short   xMin;
	 */
	public short xMin;

	/**
	 * FT_Short   yMin;
	 */
	public short yMin;

	/**
	 * FT_Short   xMax;
	 */
	public short xMax;

	/**
	 * FT_Short   yMax;
	 */
	public short yMax;

	/**
	 * FT_UShort  Mac_Style;
	 */
	public short Mac_Style;

	/**
	 * FT_UShort  Lowest_Rec_PPEM;
	 */
	public short Lowest_Rec_PPEM;

	/**
	 * FT_Short   Font_Direction;
	 */
	public short Font_Direction;

	/**
	 * FT_Short   Index_To_Loc_Format;
	 */
	public short Index_To_Loc_Format;

	/**
	 * FT_Short   Glyph_Data_Format;
	 */
	public short Glyph_Data_Format;

}
