/*
 * Decompiled with CFR 0.152.
 */
package jawprof.recorder;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import jawprof.JawprofContext;
import jawprof.Monitor;
import jawprof.recorder.PersistentRecorder;

public abstract class FormatRecorder
extends PersistentRecorder {
    private MessageFormat startFormat;
    private MessageFormat stopFormat;
    private MessageFormat lapFormat;
    private Object[] startMessageArgs;
    private Object[] stopMessageArgs;
    private Object[] lapMessageArgs;

    public FormatRecorder(JawprofContext jawprofContext) {
        this.startFormat = new MessageFormat(jawprofContext.getString("jawprof.recorder.formatrecorder.format.start"));
        this.stopFormat = new MessageFormat(jawprofContext.getString("jawprof.recorder.formatrecorder.format.stop"));
        this.lapFormat = new MessageFormat(jawprofContext.getString("jawprof.recorder.formatrecorder.format.lap"));
        this.startMessageArgs = new Object[4];
        this.stopMessageArgs = new Object[4];
        this.lapMessageArgs = new Object[5];
    }

    public final void persist(Monitor monitor) {
        this.startMessageArgs[0] = monitor.getTransactionId();
        this.stopMessageArgs[0] = monitor.getTransactionId();
        this.lapMessageArgs[0] = monitor.getTransactionId();
        this.startMessageArgs[1] = monitor.getId();
        this.stopMessageArgs[1] = monitor.getId();
        this.lapMessageArgs[1] = monitor.getId();
        this.startMessageArgs[2] = monitor.getType();
        this.stopMessageArgs[2] = monitor.getType();
        this.lapMessageArgs[2] = monitor.getType();
        this.startMessageArgs[3] = new Date(monitor.getStartTime());
        this.stopMessageArgs[3] = new Date(monitor.getStopTime());
        this.printStartRecord(this.startFormat.format(this.startMessageArgs));
        this.printStopRecord(this.stopFormat.format(this.stopMessageArgs));
        Map map = monitor.getLapTimes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            this.lapMessageArgs[4] = k;
            this.lapMessageArgs[3] = new Date((Long)map.get(k));
            this.printLapRecord(this.lapFormat.format(this.lapMessageArgs));
        }
    }

    public void saveGroupMap(String string, Collection collection) {
    }

    protected abstract void printStartRecord(String var1);

    protected abstract void printStopRecord(String var1);

    protected abstract void printLapRecord(String var1);
}

