/*
 * Decompiled with CFR 0.152.
 */
package jawprof.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jawprof.gui.DatabaseConnectionInfo;
import jawprof.gui.DatabaseConnectionInfoFactory;
import jawprof.gui.PreferencesDatabaseConnectionInfoFactory;

public class DatabaseConnectPanel
extends JPanel {
    private DatabaseConnectionInfoFactory factory;
    private Map infos = new HashMap();
    private JComboBox cbName;
    private JComboBox cbDb;
    private JComboBox cbUrl;
    private JTextField tfUser;
    private JPasswordField tfPassword;

    public DatabaseConnectPanel(Object object) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(5, 1));
        jPanel.add(new JLabel("\u63a5\u7d9a\u540d"));
        jPanel.add(new JLabel("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u7a2e\u985e"));
        jPanel.add(new JLabel("URL"));
        jPanel.add(new JLabel("\u30e6\u30fc\u30b6"));
        jPanel.add(new JLabel("\u30d1\u30b9\u30ef\u30fc\u30c9"));
        this.add((Component)jPanel, "West");
        jPanel = new JPanel(new GridLayout(5, 1));
        this.add((Component)jPanel, "Center");
        this.cbName = new JComboBox();
        this.cbName.setEditable(true);
        jPanel.add(this.cbName);
        this.cbDb = new JComboBox();
        this.cbDb.addItem("Oracle");
        this.cbDb.addItem("MySQL");
        jPanel.add(this.cbDb);
        this.cbUrl = new JComboBox();
        this.cbUrl.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = (String)itemEvent.getItem();
                    if (string.matches("jdbc:oracle\\:.+")) {
                        DatabaseConnectPanel.this.cbDb.setSelectedItem("Oracle");
                    } else if (string.matches("jdbc:mysql\\:.+")) {
                        DatabaseConnectPanel.this.cbDb.setSelectedItem("MySQL");
                    }
                }
            }
        });
        this.cbUrl.setEditable(true);
        jPanel.add(this.cbUrl);
        this.tfUser = new JTextField(10);
        jPanel.add(this.tfUser);
        this.tfPassword = new JPasswordField(10);
        jPanel.add(this.tfPassword);
        this.factory = new PreferencesDatabaseConnectionInfoFactory(this);
        Iterator iterator = this.factory.getAllInfos().iterator();
        while (iterator.hasNext()) {
            DatabaseConnectionInfo databaseConnectionInfo = (DatabaseConnectionInfo)iterator.next();
            this.infos.put(databaseConnectionInfo.getName(), databaseConnectionInfo);
            this.cbName.addItem(databaseConnectionInfo.getName());
            this.cbUrl.addItem(databaseConnectionInfo.getUrl());
        }
        this.cbName.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = (String)DatabaseConnectPanel.this.cbName.getSelectedItem();
                    DatabaseConnectPanel.this.load((DatabaseConnectionInfo)DatabaseConnectPanel.this.infos.get(string));
                }
            }
        });
        this.cbName.setSelectedIndex(this.cbName.getItemCount() - 1);
    }

    private void load(DatabaseConnectionInfo databaseConnectionInfo) {
        if (databaseConnectionInfo == null) {
            return;
        }
        this.cbDb.setSelectedItem(databaseConnectionInfo.getType());
        this.cbUrl.setSelectedItem(databaseConnectionInfo.getUrl());
        this.tfUser.setText(databaseConnectionInfo.getUser());
        this.tfPassword.setText(databaseConnectionInfo.getPassword());
    }

    public DatabaseConnectionInfo getSelectedInfo() {
        String string = (String)this.cbName.getSelectedItem();
        String string2 = (String)this.cbDb.getSelectedItem();
        String string3 = (String)this.cbUrl.getSelectedItem();
        String string4 = this.tfUser.getText();
        String string5 = new String(this.tfPassword.getPassword());
        DatabaseConnectionInfo databaseConnectionInfo = new DatabaseConnectionInfo(string, string2, string3, string4, string5);
        this.infos.put(databaseConnectionInfo.getName(), databaseConnectionInfo);
        this.factory.store(databaseConnectionInfo);
        return databaseConnectionInfo;
    }
}

