/*
 * Decompiled with CFR 0.152.
 */
package jawprof.gui;

import java.net.URL;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.table.TableCellRenderer;
import jawprof.gui.DateTableCellRenderer;
import jawprof.gui.JawprofGui;
import jawprof.gui.NumberTableCellRenderer;

public abstract class JawprofGuiModule {
    protected static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
    protected static final Format DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    protected static final TableCellRenderer dateRenderer = new DateTableCellRenderer(TIMESTAMP_FORMAT);
    protected static final TableCellRenderer intRenderer = new NumberTableCellRenderer("############");
    protected static final TableCellRenderer realRenderer = new NumberTableCellRenderer("###########0.000");
    private JawprofGui gui;

    public JawprofGuiModule(JawprofGui jawprofGui) {
        this.gui = jawprofGui;
    }

    public abstract String getTitle();

    public abstract JComponent getComponent();

    protected void notifyAction(String string) {
    }

    protected boolean isActive() {
        try {
            JTabbedPane jTabbedPane = (JTabbedPane)this.getComponent().getParent();
            return jTabbedPane.getSelectedComponent() == this.getComponent();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Connection getConnection() {
        return this.gui.getConnection();
    }

    protected Icon createIcon(String string) {
        URL uRL = ClassLoader.getSystemClassLoader().getResource(string);
        return new ImageIcon(uRL);
    }

    public Action getAction(String string) {
        return this.gui.getAction(string);
    }
}

