/*
 * Decompiled with CFR 0.152.
 */
package jawprof.gui;

import java.sql.Connection;
import java.sql.SQLException;

class SQLGenerator {
    private String productName;

    SQLGenerator(Connection connection) throws SQLException {
        this.productName = connection.getMetaData().getDatabaseProductName();
    }

    public String getToChar(String string, String string2) throws SQLException {
        if (this.productName.equals("Oracle")) {
            return "TO_CHAR(" + string + ",'" + string2 + "')";
        }
        if (this.productName.equals("MySQL")) {
            if (string2.equals("D")) {
                return "DAYOFWEEK(" + string + ")";
            }
            String string3 = string2.replaceAll("YYYY", "\\%Y").replaceAll("MM", "\\%m").replaceAll("DD", "\\%d").replaceAll("HH24", "\\%H").replaceAll("MI", "\\%i").replaceAll("D", "\\%w").replaceAll("W", "\\%u");
            return "DATE_FORMAT(" + string + ",'" + string3 + "')";
        }
        return "";
    }

    public String getDateDiff(String string, String string2) throws SQLException {
        String string3 = string2 + " - " + string;
        if (this.productName.equals("Oracle")) {
            return "EXTRACT(DAY FROM " + string3 + ") * 24 * 60 * 60 * 1000 +" + "\tEXTRACT(HOUR FROM " + string3 + ") * 60 * 60 * 1000 +" + "\tEXTRACT(MINUTE FROM " + string3 + ") * 60 * 1000 +" + "\tTRUNC(ABS(EXTRACT(SECOND FROM " + string3 + "))) * 1000";
        }
        if (this.productName.equals("MySQL")) {
            return "(" + string3 + ") * 1000";
        }
        return "";
    }

    public String getTableNamingPhrase(String string) throws SQLException {
        if (this.productName.equals("Oracle")) {
            return string;
        }
        if (this.productName.equals("MySQL")) {
            return "AS " + string;
        }
        return string;
    }
}

