/*
 * Decompiled with CFR 0.152.
 */
package jawprof;

import java.util.ArrayList;
import java.util.Collection;
import jawprof.JawprofContext;
import jawprof.Monitor;
import jawprof.MonitorFactory;
import jawprof.Recorder;
import jawprof.RecorderCreationException;
import jawprof.RecorderFactory;
import jawprof.recorder.CommonsLoggingRecorder;
import jawprof.recorder.DatabaseRecorder;
import jawprof.recorder.FileRecorder;
import jawprof.recorder.MultiRecorder;
import jawprof.recorder.PersistentRecorder;
import jawprof.recorder.SimpleRecorder;
import jawprof.recorder.TimerTaskRecorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRecorderFactory
implements RecorderFactory {
    private final Log log = LogFactory.getLog((Class)DefaultRecorderFactory.class);

    public Recorder createRecorder(JawprofContext jawprofContext) throws RecorderCreationException {
        try {
            String string = jawprofContext.getRecorderFactory();
            return this.createRecorder(jawprofContext, string);
        }
        catch (Exception exception) {
            throw new RecorderCreationException(exception);
        }
    }

    private Recorder createRecorder(JawprofContext jawprofContext, String string) throws Exception {
        Recorder recorder = null;
        if (string.equals("jawprof.NullRecorderFactory")) {
            recorder = new Recorder(){

                public void save(Monitor monitor) {
                    MonitorFactory.poolMonitor(monitor);
                }

                public void saveGroupMap(String string, Collection collection) {
                }
            };
        } else if (string.equals("jawprof.SimpleRecorderFactory")) {
            recorder = new SimpleRecorder(jawprofContext);
            this.log.info((Object)"\u7c21\u6613\u30ec\u30b3\u30fc\u30c0\u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f");
        } else if (string.equals("jawprof.FileRecorderFactory")) {
            recorder = new FileRecorder(jawprofContext);
            this.log.info((Object)"\u30d5\u30a1\u30a4\u30eb\u30ec\u30b3\u30fc\u30c0\u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f");
        } else if (string.equals("jawprof.DatabaseRecorderFactory")) {
            recorder = new DatabaseRecorder(jawprofContext);
            this.log.info((Object)"\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u30ec\u30b3\u30fc\u30c0\u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f");
        } else if (string.equals("jawprof.CommonsLoggingRecorderFactory")) {
            recorder = new CommonsLoggingRecorder(jawprofContext);
            this.log.info((Object)"Jakarta CommonsLogging \u30ec\u30b3\u30fc\u30c0\u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f");
        } else if (string.equals("jawprof.MultiRecorderFactory")) {
            String[] stringArray = jawprofContext.getString("jawprof.recorder.multirecorder.member").split(",");
            ArrayList<Recorder> arrayList = new ArrayList<Recorder>();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(this.createRecorder(jawprofContext, stringArray[i]));
            }
            recorder = new MultiRecorder(arrayList);
            this.log.info((Object)"\u30de\u30eb\u30c1\u30ec\u30b3\u30fc\u30c0\u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f");
        } else if (string.equals("jawprof.TimerTaskRecorderFactory")) {
            PersistentRecorder persistentRecorder = (PersistentRecorder)this.createRecorder(jawprofContext, jawprofContext.getString("jawprof.recorder.timertaskrecorder.factory"));
            long l = Long.parseLong(jawprofContext.getString("jawprof.recorder.timertaskrecorder.interval"));
            recorder = new TimerTaskRecorder(persistentRecorder, l);
            this.log.info((Object)"\u30bf\u30a4\u30de\u30fc\u30bf\u30b9\u30af\u30ec\u30b3\u30fc\u30c0\u304c\u4f5c\u6210\u3055\u308c\u307e\u3057\u305f");
        }
        if (recorder == null) {
            recorder = new SimpleRecorder(jawprofContext);
        }
        return recorder;
    }
}

