/*
 * Decompiled with CFR 0.152.
 */
package jawprof;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jawprof.MonitorFactory;

public final class Monitor {
    private Object id;
    private String txId;
    private Object type;
    private long startTime;
    private long stopTime;
    private Map lapTimes;
    private Set holders = new HashSet();

    protected Monitor() {
        this.lapTimes = new HashMap();
    }

    void reset(Object object) {
        this.id = object;
        this.lapTimes.clear();
    }

    void setTransactionId(String string) {
        this.txId = string;
    }

    public Object getId() {
        return this.id;
    }

    public String getTransactionId() {
        return this.txId;
    }

    public Object getType() {
        return this.type;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public Map getLapTimes() {
        return this.lapTimes;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        this.stopTime = System.currentTimeMillis();
        MonitorFactory.stopMonitoring(this);
    }

    public void lap(Object object) {
        this.lapTimes.put(object, new Long(System.currentTimeMillis()));
    }

    public void setType(Object object) {
        this.type = object;
    }

    public void hold(Object object) {
        this.holders.add(object);
    }

    public void release(Object object) {
        this.holders.remove(object);
        if (this.holders.size() == 0) {
            MonitorFactory.poolMonitor(this);
        }
    }

    public String toString() {
        return "Monitor:" + this.id;
    }
}

