/*
 * Decompiled with CFR 0.152.
 */
package jawprof;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jawprof.DefaultJawprofContext;
import jawprof.DefaultRecorderFactory;
import jawprof.JawprofContext;
import jawprof.Monitor;
import jawprof.PooledMonitorFactory;
import jawprof.Recorder;
import jawprof.RecorderCreationException;
import jawprof.RecorderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;

public class MonitorFactory {
    private static final MonitorFactory instance = new MonitorFactory();
    private final Log log = LogFactory.getLog((Class)MonitorFactory.class);
    private JawprofContext context;
    private Recorder recorder;
    private Map monitorings;
    private ObjectPool monitorPool;

    private MonitorFactory() {
        try {
            this.context = DefaultJawprofContext.createJawprofContext();
        }
        catch (Exception exception) {
            this.log.error((Object)"Jawprof \u8a2d\u5b9a\u60c5\u5831\u304c\u7372\u5f97\u3067\u304d\u307e\u305b\u3093");
            this.log.error((Object)exception.getMessage());
            this.context = new DefaultJawprofContext();
        }
        this.monitorings = new HashMap(10000);
        try {
            this.recorder = this.createRecorder(this.context);
        }
        catch (RecorderCreationException recorderCreationException) {
            this.log.warn((Object)"failer for creating a instance of jawprof.Recorder interface.");
            this.recorder = new Recorder(){

                public void save(Monitor monitor) {
                    MonitorFactory.poolMonitor(monitor);
                }

                public void saveGroupMap(String string, Collection collection) {
                }
            };
        }
        Map map = this.context.getGroupMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.recorder.saveGroupMap(string, (Collection)map.get(string));
        }
        this.monitorPool = new StackObjectPool((PoolableObjectFactory)new PooledMonitorFactory());
    }

    public static void initialize() {
    }

    public static Monitor getMonitor(Object object) {
        return MonitorFactory.getMonitor(object, null);
    }

    public static Monitor getMonitor(Object object, Object object2) {
        Monitor monitor = (Monitor)MonitorFactory.instance.monitorings.get(object);
        if (monitor == null) {
            monitor = MonitorFactory.createNewMonitor(object, object2);
        }
        return monitor;
    }

    protected static void stopMonitoring(Monitor monitor) {
        MonitorFactory.instance.monitorings.remove(monitor.getId());
        MonitorFactory.instance.recorder.save(monitor);
    }

    public static void poolMonitor(Monitor monitor) {
        try {
            MonitorFactory.instance.monitorPool.returnObject((Object)monitor);
        }
        catch (Exception exception) {
            MonitorFactory.instance.log.error((Object)"\u30e2\u30cb\u30bf\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u518d\u5229\u7528\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            MonitorFactory.instance.log.error((Object)exception.getMessage());
        }
    }

    private static Monitor createNewMonitor(Object object, Object object2) {
        Monitor monitor;
        try {
            monitor = (Monitor)MonitorFactory.instance.monitorPool.borrowObject();
            monitor.reset(object);
            monitor.setType(object2);
            MonitorFactory.instance.monitorings.put(object, monitor);
        }
        catch (Exception exception) {
            MonitorFactory.instance.log.error((Object)"\u30e2\u30cb\u30bf\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            MonitorFactory.instance.log.error((Object)exception.getMessage());
            monitor = new Monitor();
            monitor.reset(object);
            monitor.setType(object2);
        }
        return monitor;
    }

    private Recorder createRecorder(JawprofContext jawprofContext) throws RecorderCreationException {
        RecorderFactory recorderFactory = null;
        try {
            recorderFactory = (RecorderFactory)Class.forName(jawprofContext.getRecorderFactory()).newInstance();
        }
        catch (Exception exception) {
            recorderFactory = new DefaultRecorderFactory();
        }
        return recorderFactory.createRecorder(jawprofContext);
    }
}

