/*
 * Decompiled with CFR 0.152.
 */
package jawprof.recorder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jawprof.JawprofContext;
import jawprof.Monitor;
import jawprof.recorder.PersistentRecorder;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.StackObjectPool;

public class DatabaseRecorder
extends PersistentRecorder {
    private static final String RESOURCE_NAME = "jawprof";
    private final Log log = LogFactory.getLog((Class)DatabaseRecorder.class);
    public static final String SQL_INSERT_TX = "INSERT INTO TX (    ID,START_TIME,START_TIME_MILLIS,STOP_TIME,STOP_TIME_MILLIS,TYPE) VALUES (\t?,?,?,?,?,?)";
    public static final String SQL_INSERT_TX_LAP = "INSERT INTO LAP (\tTX_ID,ID,TIME,TIME_MILLIS) VALUES (\t?,?,?,?)";
    public static final String SQL_INSERT_TX_GROUP = "INSERT INTO TX_GROUP (ID) VALUES (?)";
    public static final String SQL_INSERT_TX_GROUP_MAP = "INSERT INTO TX_GROUP_MAP (GROUP_ID,TX_TYPE) VALUES (?,?)";
    private PoolingDataSource dataSource;

    public DatabaseRecorder(JawprofContext jawprofContext) throws ClassNotFoundException {
        String string = jawprofContext.getString("jawprof.recorder.databaserecorder.driver");
        String string2 = jawprofContext.getString("jawprof.recorder.databaserecorder.url");
        String string3 = jawprofContext.getString("jawprof.recorder.databaserecorder.user");
        String string4 = jawprofContext.getString("jawprof.recorder.databaserecorder.password");
        Class.forName(string);
        StackObjectPool stackObjectPool = new StackObjectPool();
        DriverManagerConnectionFactory driverManagerConnectionFactory = new DriverManagerConnectionFactory(string2, string3, string4);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)driverManagerConnectionFactory, (ObjectPool)stackObjectPool, null, null, false, true);
        this.dataSource = new PoolingDataSource((ObjectPool)stackObjectPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void persist(Monitor monitor) {
        block16: {
            Connection connection = null;
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            PreparedStatement preparedStatement = connection.prepareStatement(SQL_INSERT_TX);
            preparedStatement.setString(1, monitor.getTransactionId());
            preparedStatement.setTimestamp(2, new Timestamp(monitor.getStartTime() / 1000L * 1000L));
            preparedStatement.setLong(3, monitor.getStartTime() % 1000L);
            preparedStatement.setTimestamp(4, new Timestamp(monitor.getStopTime() / 1000L * 1000L));
            preparedStatement.setLong(5, monitor.getStopTime() % 1000L);
            if (monitor.getType() == null) {
                preparedStatement.setNull(6, 12);
            } else {
                preparedStatement.setString(6, monitor.getType().toString());
            }
            preparedStatement.addBatch();
            PreparedStatement preparedStatement2 = connection.prepareStatement(SQL_INSERT_TX_LAP);
            Map map = monitor.getLapTimes();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                long l = (Long)map.get(string);
                preparedStatement2.setString(1, monitor.getTransactionId());
                preparedStatement2.setString(2, string);
                preparedStatement2.setTimestamp(3, new Timestamp(l / 1000L * 1000L));
                preparedStatement2.setLong(4, l % 1000L);
                preparedStatement2.addBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement2.executeBatch();
            connection.commit();
            Object var11_11 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block16;
            }
            catch (SQLException sQLException) {
                this.log.error((Object)sQLException.getMessage());
            }
            break block16;
            {
                catch (SQLException sQLException) {
                    this.log.error((Object)sQLException.getMessage());
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException2) {
                        this.log.error((Object)sQLException2.getMessage());
                    }
                    Object var11_12 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block16;
                    }
                    catch (SQLException sQLException3) {
                        this.log.error((Object)sQLException3.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sQLException) {
                    this.log.error((Object)sQLException.getMessage());
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveGroupMap(String string, Collection collection) {
        block15: {
            Connection connection = null;
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            PreparedStatement preparedStatement = connection.prepareStatement(SQL_INSERT_TX_GROUP);
            preparedStatement.setString(1, string);
            preparedStatement.addBatch();
            PreparedStatement preparedStatement2 = connection.prepareStatement(SQL_INSERT_TX_GROUP_MAP);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                preparedStatement2.setString(1, string);
                preparedStatement2.setString(2, string2);
                preparedStatement2.addBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement2.executeBatch();
            connection.commit();
            Object var9_10 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block15;
            }
            catch (SQLException sQLException) {
                this.log.error((Object)sQLException.getMessage());
            }
            break block15;
            {
                catch (SQLException sQLException) {
                    this.log.error((Object)sQLException.getMessage());
                    try {
                        if (connection != null) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException2) {
                        this.log.error((Object)sQLException2.getMessage());
                    }
                    Object var9_11 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                        break block15;
                    }
                    catch (SQLException sQLException3) {
                        this.log.error((Object)sQLException3.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sQLException) {
                    this.log.error((Object)sQLException.getMessage());
                }
                throw throwable;
            }
        }
    }
}

