/*
 * Decompiled with CFR 0.152.
 */
package jawprof.recorder;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import jawprof.Monitor;
import jawprof.recorder.AbstractRecorder;
import jawprof.recorder.PersistentRecorder;

public class TimerTaskRecorder
extends AbstractRecorder {
    private PersistentRecorder recorder;
    private Collection buffer;
    private Collection savings;

    public TimerTaskRecorder(PersistentRecorder persistentRecorder, long l) {
        this.recorder = persistentRecorder;
        this.buffer = new LinkedList();
        this.savings = new LinkedList();
        Timer timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                TimerTaskRecorder timerTaskRecorder = TimerTaskRecorder.this;
                synchronized (timerTaskRecorder) {
                    TimerTaskRecorder.this.swap();
                    Iterator iterator = TimerTaskRecorder.this.savings.iterator();
                    while (iterator.hasNext()) {
                        Monitor monitor = (Monitor)iterator.next();
                        TimerTaskRecorder.this.recorder.save(monitor);
                        TimerTaskRecorder.this.release(monitor);
                    }
                    TimerTaskRecorder.this.savings.clear();
                }
            }
        };
        timer.schedule(timerTask, l, l);
        Runtime.getRuntime().addShutdownHook(new Thread(timerTask));
    }

    public synchronized void save(Monitor monitor) {
        this.hold(monitor);
        this.buffer.add(monitor);
    }

    public void saveGroupMap(String string, Collection collection) {
        this.recorder.saveGroupMap(string, collection);
    }

    private void swap() {
        Collection collection = this.buffer;
        this.buffer = this.savings;
        this.savings = collection;
    }
}

