/*
 * Decompiled with CFR 0.152.
 */
package jawprof.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jawprof.gui.DatabaseConnectPanel;
import jawprof.gui.DatabaseConnectionInfo;
import jawprof.gui.JActionButton;
import jawprof.gui.JawprofGuiModule;
import jawprof.gui.StatisticsInfoModule;
import jawprof.gui.TransactionTableModule;

public class JawprofGui
extends JFrame {
    public static final String INFO_VERSION = "Jawprof ver. 0.8";
    public static final String RESOURCE_NAME = "jawprof_gui";
    public static final String ACTION_NULL = "NULL";
    public static final String ACTION_TERMINATE = "TERMINATE";
    public static final String ACTION_CONNECT = "CONNECT";
    public static final String ACTION_DISCONNECT = "DISCONNECT";
    public static final String ACTION_REFRESH = "REFRESH";
    public static final String ACTION_EXPORT = "EXPORT";
    public static final String ACTION_CHANGE_LOOK_AND_FEEL = "CHANGE_LOOK_AND_FEEL";
    private static final String LOOK_AND_FEEL_MAC = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String LOOK_AND_FEEL_METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String LOOK_AND_FEEL_MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String LOOK_AND_FEEL_WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String LOOK_AND_FEEL_GTK = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private ResourceBundle bundle;
    private Set modules = new HashSet();
    private Map actions = new HashMap();
    private JTabbedPane tabbedPane;
    private Connection connection = null;

    public JawprofGui(String string) {
        super(string);
        this.setDefaultCloseOperation(3);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JawprofGui.this.disconnect();
            }
        });
        this.bundle = ResourceBundle.getBundle(RESOURCE_NAME);
        Image image = this.createImage(this.bundle.getString("jawprof.gui.image.icon"));
        this.setIconImage(image);
        this.createActions();
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().add((Component)this.createToolBar(string), "First");
        this.tabbedPane = new JTabbedPane();
        JawprofGuiModule jawprofGuiModule = new TransactionTableModule(this);
        this.modules.add(jawprofGuiModule);
        this.tabbedPane.add(jawprofGuiModule.getTitle(), jawprofGuiModule.getComponent());
        jawprofGuiModule = new StatisticsInfoModule(this);
        this.modules.add(jawprofGuiModule);
        this.tabbedPane.add(jawprofGuiModule.getTitle(), jawprofGuiModule.getComponent());
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.tabbedPane.setSelectedIndex(0);
    }

    private void createActions() {
        ImageIcon imageIcon = new ImageIcon(this.createImage(this.bundle.getString("jawprof.gui.image.connect")));
        AbstractAction abstractAction = new ConnectAction("\u63a5\u7d9a", imageIcon);
        abstractAction.putValue("ShortDescription", "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a");
        this.actions.put(ACTION_CONNECT, abstractAction);
        imageIcon = new ImageIcon(this.createImage(this.bundle.getString("jawprof.gui.image.disconnect")));
        abstractAction = new DisconnectAction("\u5207\u65ad", imageIcon);
        abstractAction.putValue("ShortDescription", "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u5207\u65ad");
        this.actions.put(ACTION_DISCONNECT, abstractAction);
        imageIcon = new ImageIcon(this.createImage(this.bundle.getString("jawprof.gui.image.refresh")));
        abstractAction = new RefreshAction("\u6700\u65b0\u306e\u72b6\u614b\u306b\u66f4\u65b0", imageIcon);
        abstractAction.putValue("ShortDescription", "\u6700\u65b0\u306e\u72b6\u614b\u306b\u66f4\u65b0");
        this.actions.put(ACTION_REFRESH, abstractAction);
        imageIcon = new ImageIcon(this.createImage(this.bundle.getString("jawprof.gui.image.export")));
        abstractAction = new ExportAction("\u30a8\u30af\u30b9\u30dd\u30fc\u30c8", imageIcon);
        abstractAction.putValue("ShortDescription", "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8");
        this.actions.put(ACTION_EXPORT, abstractAction);
        this.actions.put(ACTION_NULL, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
    }

    public Action getAction(String string) {
        Action action = (Action)this.actions.get(string);
        if (action == null) {
            action = (Action)this.actions.get(ACTION_NULL);
        }
        return action;
    }

    private JMenuBar createMenuBar() {
        JMenu jMenu = new JMenu("\u63a5\u7d9a");
        JMenuItem jMenuItem = jMenu.add(new JMenuItem(this.getAction(ACTION_CONNECT)));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 2));
        jMenuItem = jMenu.add(new JMenuItem(this.getAction(ACTION_DISCONNECT)));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        jMenu.addSeparator();
        jMenu.add(new AbstractAction("\u7d42\u4e86"){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        JMenu jMenu2 = new JMenu("\u8868\u793a");
        jMenuItem = jMenu2.add(new JMenuItem(this.getAction(ACTION_REFRESH)));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        JMenu jMenu3 = new JMenu("Look & Feel");
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenuItem = jMenu3.add(new JRadioButtonMenuItem(new ChangeLookAndFeelsAction(LOOK_AND_FEEL_MAC)));
        buttonGroup.add(jMenuItem);
        jMenuItem = jMenu3.add(new JRadioButtonMenuItem(new ChangeLookAndFeelsAction(LOOK_AND_FEEL_METAL)));
        buttonGroup.add(jMenuItem);
        jMenuItem.setSelected(true);
        jMenuItem = jMenu3.add(new JRadioButtonMenuItem(new ChangeLookAndFeelsAction(LOOK_AND_FEEL_MOTIF)));
        buttonGroup.add(jMenuItem);
        jMenuItem = jMenu3.add(new JRadioButtonMenuItem(new ChangeLookAndFeelsAction(LOOK_AND_FEEL_WINDOWS)));
        buttonGroup.add(jMenuItem);
        jMenuItem = jMenu3.add(new JRadioButtonMenuItem(new ChangeLookAndFeelsAction(LOOK_AND_FEEL_GTK)));
        buttonGroup.add(jMenuItem);
        jMenu2.add(jMenu3);
        JMenu jMenu4 = new JMenu("\u30c4\u30fc\u30eb");
        jMenuItem = jMenu4.add(new JMenuItem(this.getAction(ACTION_EXPORT)));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        JMenu jMenu5 = new JMenu("\u30d8\u30eb\u30d7");
        jMenu5.add("\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageIcon imageIcon = new ImageIcon(JawprofGui.this.createImage(JawprofGui.this.bundle.getString("jawprof.gui.image.icon")));
                JOptionPane.showMessageDialog(JawprofGui.this.getContentPane(), JawprofGui.INFO_VERSION, "\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831", 1, imageIcon);
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu4);
        jMenuBar.add(jMenu5);
        return jMenuBar;
    }

    private JToolBar createToolBar(String string) {
        JToolBar jToolBar = new JToolBar(string);
        JActionButton jActionButton = new JActionButton(this.getAction(ACTION_CONNECT), true);
        jToolBar.add(jActionButton);
        jActionButton = new JActionButton(this.getAction(ACTION_DISCONNECT), true);
        jToolBar.add(jActionButton);
        jActionButton = new JActionButton(this.getAction(ACTION_REFRESH), true);
        jToolBar.add(jActionButton);
        jActionButton = new JActionButton(this.getAction(ACTION_EXPORT), true);
        jToolBar.add(jActionButton);
        return jToolBar;
    }

    private Image createImage(String string) {
        URL uRL = ClassLoader.getSystemClassLoader().getResource(string);
        return Toolkit.getDefaultToolkit().createImage(uRL);
    }

    private Connection connect(String string, String string2, String string3, String string4) {
        if (this.connection != null) {
            return this.connection;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (string == null || string2 == null || string3 == null || string4 == null) {
            JOptionPane.showMessageDialog(null, "alert", "alert", 0);
            this.setCursor(Cursor.getPredefinedCursor(0));
            return null;
        }
        try {
            Class.forName(string.trim());
            this.connection = DriverManager.getConnection(string2.trim(), string3.trim(), string4.trim());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.connection == null) {
            JOptionPane.showMessageDialog(null, "\u63a5\u7d9a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f", "alert", 0);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return this.connection;
    }

    private void disconnect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.connection = null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public static void main(String[] stringArray) {
        JawprofGui jawprofGui = new JawprofGui("Jawprof GUI");
        jawprofGui.pack();
        int n = 0;
        int n2 = 0;
        if (stringArray.length != 0) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[0].getConfigurations();
            Rectangle rectangle = graphicsConfigurationArray[0].getBounds();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("center") || stringArray[i].equals("c")) {
                    n = (rectangle.width - jawprofGui.getWidth()) / 2 + rectangle.x;
                    n2 = (rectangle.height - jawprofGui.getHeight()) / 2 + rectangle.y;
                }
                if (stringArray[i].equals("left") || stringArray[i].equals("l")) {
                    n = 0;
                }
                if (stringArray[i].equals("right") || stringArray[i].equals("r")) {
                    n = rectangle.width;
                }
                if (stringArray[i].equals("top") || stringArray[i].equals("t")) {
                    n2 = 0;
                }
                if (!stringArray[i].equals("bottom") && !stringArray[i].equals("b")) continue;
                n2 = rectangle.height;
            }
        }
        jawprofGui.setLocation(n, n2);
        jawprofGui.show();
    }

    private class ExportAction
    extends AbstractAction {
        public ExportAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Iterator iterator = JawprofGui.this.modules.iterator();
            while (iterator.hasNext()) {
                JawprofGuiModule jawprofGuiModule = (JawprofGuiModule)iterator.next();
                jawprofGuiModule.notifyAction(JawprofGui.ACTION_EXPORT);
            }
        }
    }

    private class ChangeLookAndFeelsAction
    extends AbstractAction {
        public ChangeLookAndFeelsAction(String string) {
            super(string);
            try {
                LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(string).newInstance();
                this.putValue("Name", lookAndFeel.getName());
                this.putValue("ActionCommandKey", string);
                this.putValue("ShortDescription", lookAndFeel.getDescription());
                if (!lookAndFeel.isSupportedLookAndFeel()) {
                    this.setEnabled(false);
                }
            }
            catch (Exception exception) {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UIManager.setLookAndFeel(actionEvent.getActionCommand());
                SwingUtilities.updateComponentTreeUI(JawprofGui.this);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            Iterator iterator = JawprofGui.this.modules.iterator();
            while (iterator.hasNext()) {
                JawprofGuiModule jawprofGuiModule = (JawprofGuiModule)iterator.next();
                jawprofGuiModule.notifyAction(JawprofGui.ACTION_CHANGE_LOOK_AND_FEEL);
            }
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public RefreshAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Iterator iterator = JawprofGui.this.modules.iterator();
            while (iterator.hasNext()) {
                JawprofGuiModule jawprofGuiModule = (JawprofGuiModule)iterator.next();
                jawprofGuiModule.notifyAction(JawprofGui.ACTION_REFRESH);
            }
        }
    }

    private class DisconnectAction
    extends AbstractAction {
        public DisconnectAction(String string, Icon icon) {
            super(string, icon);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JawprofGui.this.disconnect();
            JawprofGui.this.getAction(JawprofGui.ACTION_CONNECT).setEnabled(true);
            JawprofGui.this.getAction(JawprofGui.ACTION_DISCONNECT).setEnabled(false);
            Iterator iterator = JawprofGui.this.modules.iterator();
            while (iterator.hasNext()) {
                JawprofGuiModule jawprofGuiModule = (JawprofGuiModule)iterator.next();
                jawprofGuiModule.notifyAction(JawprofGui.ACTION_DISCONNECT);
            }
        }
    }

    private class ConnectAction
    extends AbstractAction {
        public ConnectAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{new DatabaseConnectPanel(this)};
            Object[] objectArray2 = new String[]{"\u63a5\u7d9a", "\u30ad\u30e3\u30f3\u30bb\u30eb"};
            int n = JOptionPane.showOptionDialog(JawprofGui.this.getContentPane(), objectArray, "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a", -1, 1, null, objectArray2, objectArray2[1]);
            switch (n) {
                case 0: {
                    DatabaseConnectPanel databaseConnectPanel = (DatabaseConnectPanel)objectArray[0];
                    DatabaseConnectionInfo databaseConnectionInfo = databaseConnectPanel.getSelectedInfo();
                    String string = null;
                    String string2 = databaseConnectionInfo.getType();
                    if (string2.equals("Oracle")) {
                        string = "oracle.jdbc.driver.OracleDriver";
                    } else if (string2.equals("MySQL")) {
                        string = "org.gjt.mm.mysql.Driver";
                    }
                    String string3 = databaseConnectionInfo.getUrl();
                    String string4 = databaseConnectionInfo.getUser();
                    String string5 = databaseConnectionInfo.getPassword();
                    JawprofGui.this.connection = JawprofGui.this.connect(string, string3, string4, string5);
                    if (JawprofGui.this.connection == null) break;
                    JawprofGui.this.getAction(JawprofGui.ACTION_CONNECT).setEnabled(false);
                    JawprofGui.this.getAction(JawprofGui.ACTION_DISCONNECT).setEnabled(true);
                    Iterator iterator = JawprofGui.this.modules.iterator();
                    while (iterator.hasNext()) {
                        JawprofGuiModule jawprofGuiModule = (JawprofGuiModule)iterator.next();
                        jawprofGuiModule.notifyAction(JawprofGui.ACTION_CONNECT);
                    }
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }
}

