/*
 * Decompiled with CFR 0.152.
 */
package jawprof.gui;

import java.util.HashSet;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import jawprof.gui.DatabaseConnectionInfo;
import jawprof.gui.DatabaseConnectionInfoFactory;

public class PreferencesDatabaseConnectionInfoFactory
implements DatabaseConnectionInfoFactory {
    private Preferences baseNode;
    private Set infos = new HashSet();

    public PreferencesDatabaseConnectionInfoFactory(Object object) {
        Preferences preferences = Preferences.userNodeForPackage(object.getClass());
        this.baseNode = preferences.node("DatabaseConnectPanel/Databases");
    }

    private void load() {
        try {
            String[] stringArray = this.baseNode.childrenNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Preferences preferences = this.baseNode.node(stringArray[i]);
                DatabaseConnectionInfo databaseConnectionInfo = new DatabaseConnectionInfo(stringArray[i], preferences.get("type", ""), preferences.get("url", ""), preferences.get("user", ""), preferences.get("pass", ""));
                this.infos.add(databaseConnectionInfo);
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public Set getAllInfos() {
        this.load();
        return this.infos;
    }

    public void store(DatabaseConnectionInfo databaseConnectionInfo) {
        Preferences preferences = this.baseNode.node(databaseConnectionInfo.getName());
        preferences.put("type", databaseConnectionInfo.getType());
        preferences.put("url", databaseConnectionInfo.getUrl());
        preferences.put("user", databaseConnectionInfo.getUser());
        preferences.put("pass", databaseConnectionInfo.getPassword());
    }
}

