/*
 * Decompiled with CFR 0.152.
 */
package jawprof.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jawprof.gui.DateTableCellRenderer;
import jawprof.gui.JawprofGui;
import jawprof.gui.JawprofGuiModule;
import jawprof.gui.SQLGenerator;

public class StatisticsInfoModule
extends JawprofGuiModule {
    public static final int STATISTICS_UNIT_HOUR = 0;
    public static final int STATISTICS_UNIT_DAY = 1;
    public static final int STATISTICS_UNIT_DATE = 2;
    public static final int STATISTICS_UNIT_WEEK = 3;
    public static final int STATISTICS_UNIT_MONTH = 4;
    public static final int STATISTICS_UNIT_TYPE = 5;
    private JSplitPane pane = new JSplitPane(0, new ControlPartPanel(), new StatisticsInfoPartPanel());
    private JTable statisticsTable;
    private JScrollPane scrollPane;
    private JButton btSearch;

    public StatisticsInfoModule(JawprofGui jawprofGui) {
        super(jawprofGui);
    }

    public String getTitle() {
        return "\u7d71\u8a08\u60c5\u5831";
    }

    public JComponent getComponent() {
        return this.pane;
    }

    protected void notifyAction(String string) {
        if (string.equals("CONNECT")) {
            if (this.btSearch != null) {
                this.btSearch.getAction().setEnabled(true);
            }
        } else if (string.equals("DISCONNECT") && this.btSearch != null) {
            this.btSearch.getAction().setEnabled(false);
            this.statisticsTable.setModel(new StatisticsInfoTableModel(0, new ArrayList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private TableModel refresh(int n, Timestamp timestamp, Timestamp timestamp2) {
        ArrayList<Object[]> arrayList;
        block27: {
            String string;
            Statement statement;
            Connection connection;
            block25: {
                connection = null;
                statement = null;
                arrayList = new ArrayList<Object[]>();
                connection = this.getConnection();
                if (connection != null) break block25;
                StatisticsInfoTableModel statisticsInfoTableModel = new StatisticsInfoTableModel(n, arrayList);
                Object var14_10 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    System.err.println(sQLException.getMessage());
                }
                return statisticsInfoTableModel;
            }
            this.pane.getParent().setCursor(Cursor.getPredefinedCursor(3));
            connection.setAutoCommit(true);
            connection.setTransactionIsolation(2);
            SQLGenerator sQLGenerator = new SQLGenerator(connection);
            switch (n) {
                case 0: {
                    string = sQLGenerator.getToChar("START_TIME", "YYYYMMDD HH24");
                    String string2 = "24";
                    break;
                }
                case 1: {
                    string = sQLGenerator.getToChar("START_TIME", "D");
                    String string2 = "24";
                    break;
                }
                case 2: {
                    string = sQLGenerator.getToChar("START_TIME", "YYYYMMDD");
                    String string2 = "24";
                    break;
                }
                case 3: {
                    string = sQLGenerator.getToChar("START_TIME", "YYYYMM W");
                    String string2 = "24";
                    break;
                }
                case 4: {
                    string = sQLGenerator.getToChar("START_TIME", "YYYYMM");
                    String string2 = "24";
                    break;
                }
                case 5: {
                    string = "TYPE";
                    String string2 = "24";
                    break;
                }
                default: {
                    string = "TYPE";
                    String string2 = "24";
                }
            }
            if (timestamp == null && timestamp2 == null) {
                statement = connection.prepareStatement("SELECT \t\tUNIT,\t\tAVG(PROCESSING_TIME) AS AVG,\t\tMIN(PROCESSING_TIME) AS MIN,\t\tMAX(PROCESSING_TIME) AS MAX,\t\tSTDDEV(PROCESSING_TIME) AS STDDEV,\t\tCOUNT(*) AS COUNT FROM (\tSELECT " + string + " AS UNIT," + sQLGenerator.getDateDiff("START_TIME", "STOP_TIME") + "\t\t\t+" + "\t\t\tSTOP_TIME_MILLIS - START_TIME_MILLIS " + "\t\t\t\tAS PROCESSING_TIME " + "\t\tFROM TX" + ") " + sQLGenerator.getTableNamingPhrase("T") + " " + "GROUP BY UNIT " + "ORDER BY UNIT");
            } else {
                statement = connection.prepareStatement("SELECT \t\tUNIT,\t\tAVG(PROCESSING_TIME) AS AVG,\t\tMIN(PROCESSING_TIME) AS MIN,\t\tMAX(PROCESSING_TIME) AS MAX,\t\tSTDDEV(PROCESSING_TIME) AS STDDEV,\t\tCOUNT(*) AS COUNT FROM (\tSELECT " + string + " AS UNIT," + sQLGenerator.getDateDiff("START_TIME", "STOP_TIME") + "\t\t\t+" + "\t\t\tSTOP_TIME_MILLIS - START_TIME_MILLIS " + "\t\t\t\tAS PROCESSING_TIME " + "\t\tFROM TX" + "\t\tWHERE " + sQLGenerator.getToChar("START_TIME", "YYYYMMDD") + "\t\t\t\tBETWEEN " + sQLGenerator.getToChar("?", "YYYYMMDD") + "\t\t\t\tAND " + sQLGenerator.getToChar("?", "YYYYMMDD") + ") " + sQLGenerator.getTableNamingPhrase("T") + " " + "GROUP BY UNIT " + "ORDER BY UNIT");
                statement.setTimestamp(1, timestamp);
                statement.setTimestamp(2, timestamp2);
            }
            ResultSet resultSet = statement.executeQuery();
            boolean bl = false;
            while (resultSet.next()) {
                Object[] objectArray = new Object[]{resultSet.getString("UNIT"), new Long(resultSet.getLong("AVG")), new Long(resultSet.getLong("MIN")), new Long(resultSet.getLong("MAX")), new Double(resultSet.getDouble("STDDEV")), new Long(resultSet.getLong("COUNT"))};
                arrayList.add(objectArray);
            }
            Object var14_11 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                break block27;
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException.getMessage());
            }
            break block27;
            {
                catch (SQLException sQLException) {
                    System.err.println(sQLException.getMessage());
                    Object var14_12 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block27;
                    }
                    catch (SQLException sQLException2) {
                        System.err.println(sQLException2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    System.err.println(sQLException.getMessage());
                }
                throw throwable;
            }
        }
        this.pane.getParent().setCursor(Cursor.getPredefinedCursor(0));
        return new StatisticsInfoTableModel(n, arrayList);
    }

    private static class StatisticsInfoTableModel
    extends AbstractTableModel {
        private int unit;
        private List info;
        private DateFormat format;

        private StatisticsInfoTableModel(int n, List list) {
            this.unit = n;
            this.info = list;
            switch (n) {
                case 0: {
                    this.format = new SimpleDateFormat("yyyyMMdd HH");
                    break;
                }
                case 1: {
                    this.format = new SimpleDateFormat("F");
                    break;
                }
                case 2: {
                    this.format = new SimpleDateFormat("yyyyMMdd");
                    break;
                }
                case 3: {
                    this.format = new SimpleDateFormat("yyyyMM W");
                    break;
                }
                case 4: {
                    this.format = new SimpleDateFormat("yyyyMM");
                    break;
                }
                case 5: {
                    this.format = null;
                    break;
                }
                default: {
                    this.format = null;
                }
            }
        }

        public int getColumnCount() {
            return 6;
        }

        public int getRowCount() {
            return this.info.size();
        }

        public Object getValueAt(int n, int n2) {
            Object[] objectArray = (Object[])this.info.get(n);
            switch (n2) {
                case 0: {
                    switch (this.unit) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: {
                            try {
                                return this.format.parse((String)objectArray[0]);
                            }
                            catch (ParseException parseException) {
                                parseException.printStackTrace();
                                return objectArray[0];
                            }
                        }
                        case 1: {
                            Calendar calendar = Calendar.getInstance();
                            if (objectArray[0].equals("1")) {
                                calendar.set(7, 1);
                            } else if (objectArray[0].equals("2")) {
                                calendar.set(7, 2);
                            } else if (objectArray[0].equals("3")) {
                                calendar.set(7, 3);
                            } else if (objectArray[0].equals("4")) {
                                calendar.set(7, 4);
                            } else if (objectArray[0].equals("5")) {
                                calendar.set(7, 5);
                            } else if (objectArray[0].equals("6")) {
                                calendar.set(7, 6);
                            } else if (objectArray[0].equals("7")) {
                                calendar.set(7, 7);
                            } else {
                                return objectArray[0];
                            }
                            return calendar.getTime();
                        }
                    }
                    return objectArray[0];
                }
                case 1: {
                    return objectArray[1];
                }
                case 2: {
                    return objectArray[2];
                }
                case 3: {
                    return objectArray[3];
                }
                case 4: {
                    return objectArray[4];
                }
                case 5: {
                    return objectArray[5];
                }
            }
            return "";
        }

        public String getColumnName(int n) {
            if (n == 0) {
                switch (this.unit) {
                    case 0: {
                        return "\u6642\u9593";
                    }
                    case 1: {
                        return "\u66dc\u65e5";
                    }
                    case 2: {
                        return "\u65e5\u4ed8";
                    }
                    case 3: {
                        return "\u9031";
                    }
                    case 4: {
                        return "\u6708";
                    }
                    case 5: {
                        return "\u30bf\u30a4\u30d7";
                    }
                }
                return "\u96c6\u8a08\u5358\u4f4d";
            }
            if (n == 1) {
                return "\u5e73\u5747\u51e6\u7406\u6642\u9593";
            }
            if (n == 2) {
                return "\u6700\u5c0f\u51e6\u7406\u6642\u9593";
            }
            if (n == 3) {
                return "\u6700\u5927\u51e6\u7406\u6642\u9593";
            }
            if (n == 4) {
                return "\u51e6\u7406\u6642\u9593\u504f\u5dee";
            }
            if (n == 5) {
                return "\u767a\u751f\u4ef6\u6570";
            }
            return super.getColumnName(n);
        }
    }

    private class StatisticsInfoPartPanel
    extends JPanel {
        public StatisticsInfoPartPanel() {
            this.setLayout(new BorderLayout());
            StatisticsInfoModule.this.statisticsTable = new JTable(new StatisticsInfoTableModel(0, new ArrayList()));
            this.add((Component)new JScrollPane(StatisticsInfoModule.this.statisticsTable), "Center");
        }
    }

    private class ControlPartPanel
    extends JPanel
    implements ItemListener {
        private JCheckBox ckTerm;
        private JFormattedTextField tfDate0;
        private JFormattedTextField tfDate1;
        private JRadioButton rbHour;
        private JRadioButton rbDay;
        private JRadioButton rbDate;
        private JRadioButton rbWeek;
        private JRadioButton rbMonth;
        private JRadioButton rbType;

        public ControlPartPanel() {
            this.setLayout(new GridLayout(2, 1));
            JPanel jPanel = new JPanel(new FlowLayout(3));
            this.ckTerm = new JCheckBox("\u96c6\u8a08\u671f\u9593", true);
            this.ckTerm.addItemListener(this);
            jPanel.add(this.ckTerm);
            this.tfDate0 = new JFormattedTextField(JawprofGuiModule.DATE_FORMAT);
            this.tfDate0.setValue(new Date());
            jPanel.add(this.tfDate0);
            this.tfDate1 = new JFormattedTextField(JawprofGuiModule.DATE_FORMAT);
            this.tfDate1.setValue(new Date());
            jPanel.add(this.tfDate1);
            this.add(jPanel);
            ButtonGroup buttonGroup = new ButtonGroup();
            jPanel = new JPanel(new FlowLayout(3));
            jPanel.add(new JLabel("\u96c6\u8a08\u5358\u4f4d"));
            this.rbHour = new JRadioButton("\u6642\u9593", true);
            buttonGroup.add(this.rbHour);
            jPanel.add(this.rbHour);
            this.rbDay = new JRadioButton("\u66dc\u65e5");
            buttonGroup.add(this.rbDay);
            jPanel.add(this.rbDay);
            this.rbDate = new JRadioButton("\u65e5\u4ed8");
            buttonGroup.add(this.rbDate);
            jPanel.add(this.rbDate);
            this.rbWeek = new JRadioButton("\u9031");
            buttonGroup.add(this.rbWeek);
            jPanel.add(this.rbWeek);
            this.rbMonth = new JRadioButton("\u6708");
            buttonGroup.add(this.rbMonth);
            jPanel.add(this.rbMonth);
            this.rbType = new JRadioButton("\u30bf\u30a4\u30d7");
            buttonGroup.add(this.rbType);
            jPanel.add(this.rbType);
            StatisticsInfoModule.this.btSearch = new JButton(new SearchAction("\u691c\u7d22", StatisticsInfoModule.this.createIcon("toolbarButtonGraphics/general/Refresh16.gif")));
            StatisticsInfoModule.this.btSearch.getAction().setEnabled(false);
            jPanel.add(StatisticsInfoModule.this.btSearch);
            this.add(jPanel);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.tfDate0.setEditable(true);
                this.tfDate1.setEditable(true);
                this.tfDate0.setEnabled(true);
                this.tfDate1.setEnabled(true);
            } else if (itemEvent.getStateChange() == 2) {
                this.tfDate0.setEditable(false);
                this.tfDate1.setEditable(false);
                this.tfDate0.setEnabled(false);
                this.tfDate1.setEnabled(false);
            }
        }

        private int getSelectedUnit() {
            if (this.rbHour.isSelected()) {
                return 0;
            }
            if (this.rbDay.isSelected()) {
                return 1;
            }
            if (this.rbDate.isSelected()) {
                return 2;
            }
            if (this.rbWeek.isSelected()) {
                return 3;
            }
            if (this.rbMonth.isSelected()) {
                return 4;
            }
            if (this.rbType.isSelected()) {
                return 5;
            }
            return -1;
        }

        private class SearchAction
        extends AbstractAction {
            public SearchAction(String string, Icon icon) {
                super(string, icon);
                this.setEnabled(true);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                TableModel tableModel;
                Serializable serializable;
                if (ControlPartPanel.this.ckTerm.isSelected()) {
                    serializable = (Date)ControlPartPanel.this.tfDate0.getValue();
                    Date date = (Date)ControlPartPanel.this.tfDate1.getValue();
                    tableModel = StatisticsInfoModule.this.refresh(ControlPartPanel.this.getSelectedUnit(), new Timestamp(((Date)serializable).getTime()), new Timestamp(date.getTime()));
                } else {
                    tableModel = StatisticsInfoModule.this.refresh(ControlPartPanel.this.getSelectedUnit(), null, null);
                }
                StatisticsInfoModule.this.statisticsTable.setModel(tableModel);
                switch (ControlPartPanel.this.getSelectedUnit()) {
                    case 0: {
                        serializable = StatisticsInfoModule.this.statisticsTable.getColumn("\u6642\u9593");
                        if (serializable == null) break;
                        ((TableColumn)serializable).setCellRenderer(new DateTableCellRenderer("yyyy/MMdd HH:mm"));
                        break;
                    }
                    case 1: {
                        serializable = StatisticsInfoModule.this.statisticsTable.getColumn("\u66dc\u65e5");
                        if (serializable == null) break;
                        ((TableColumn)serializable).setCellRenderer(new DateTableCellRenderer(" E "));
                        break;
                    }
                    case 2: {
                        serializable = StatisticsInfoModule.this.statisticsTable.getColumn("\u65e5\u4ed8");
                        if (serializable == null) break;
                        ((TableColumn)serializable).setCellRenderer(new DateTableCellRenderer("yyyy/MMdd"));
                        break;
                    }
                    case 3: {
                        serializable = StatisticsInfoModule.this.statisticsTable.getColumn("\u9031");
                        if (serializable == null) break;
                        ((TableColumn)serializable).setCellRenderer(new DateTableCellRenderer("yyyy/MM \u7b2c W \u9031"));
                        break;
                    }
                    case 4: {
                        serializable = StatisticsInfoModule.this.statisticsTable.getColumn("\u6708");
                        if (serializable == null) break;
                        ((TableColumn)serializable).setCellRenderer(new DateTableCellRenderer("yyyy/MM"));
                        break;
                    }
                }
                serializable = StatisticsInfoModule.this.statisticsTable.getColumn("\u5e73\u5747\u51e6\u7406\u6642\u9593");
                if (serializable != null) {
                    ((TableColumn)serializable).setCellRenderer(JawprofGuiModule.intRenderer);
                }
                if ((serializable = StatisticsInfoModule.this.statisticsTable.getColumn("\u6700\u5c0f\u51e6\u7406\u6642\u9593")) != null) {
                    ((TableColumn)serializable).setCellRenderer(JawprofGuiModule.intRenderer);
                }
                if ((serializable = StatisticsInfoModule.this.statisticsTable.getColumn("\u6700\u5927\u51e6\u7406\u6642\u9593")) != null) {
                    ((TableColumn)serializable).setCellRenderer(JawprofGuiModule.intRenderer);
                }
                if ((serializable = StatisticsInfoModule.this.statisticsTable.getColumn("\u51e6\u7406\u6642\u9593\u504f\u5dee")) != null) {
                    ((TableColumn)serializable).setCellRenderer(JawprofGuiModule.realRenderer);
                }
                if ((serializable = StatisticsInfoModule.this.statisticsTable.getColumn("\u767a\u751f\u4ef6\u6570")) != null) {
                    ((TableColumn)serializable).setCellRenderer(JawprofGuiModule.intRenderer);
                }
                if (StatisticsInfoModule.this.statisticsTable.getRowCount() > 0) {
                    StatisticsInfoModule.this.statisticsTable.setRowSelectionInterval(0, 0);
                }
            }
        }
    }
}

