/*
 * Decompiled with CFR 0.152.
 */
package jawprof.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jawprof.gui.ExportPanel;
import jawprof.gui.JActionButton;
import jawprof.gui.JawprofGui;
import jawprof.gui.JawprofGuiModule;
import jawprof.gui.SQLGenerator;
import jawprof.gui.TransactionRecord;

public class TransactionTableModule
extends JawprofGuiModule {
    private JPanel panel = new JPanel(new BorderLayout());
    private TransactionTablePartPanel transactionTablePart;
    private TransactionDetailPartPanel transactionDetailPart;
    private List transactions;
    private JTable transactionTable;
    private JTable lapTable;
    private JButton btSearch;

    public TransactionTableModule(JawprofGui jawprofGui) {
        super(jawprofGui);
        ControlPartPanel controlPartPanel = new ControlPartPanel();
        this.panel.add((Component)controlPartPanel, "North");
        this.transactionTablePart = new TransactionTablePartPanel();
        this.transactionDetailPart = new TransactionDetailPartPanel();
        JSplitPane jSplitPane = new JSplitPane(0, this.transactionTablePart, this.transactionDetailPart);
        this.panel.add((Component)jSplitPane, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(4));
        JActionButton jActionButton = new JActionButton(new AbstractAction("back", this.createIcon("toolbarButtonGraphics/navigation/Back24.gif")){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TransactionTableModule.this.transactionTable.getSelectedRow() - 1;
                if (n >= 0) {
                    TransactionTableModule.this.transactionTable.setRowSelectionInterval(n, n);
                }
            }
        }, true);
        jPanel.add(jActionButton);
        JActionButton jActionButton2 = new JActionButton(new AbstractAction("forward", this.createIcon("toolbarButtonGraphics/navigation/Forward24.gif")){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TransactionTableModule.this.transactionTable.getSelectedRow() + 1;
                if (n < TransactionTableModule.this.transactionTable.getRowCount()) {
                    TransactionTableModule.this.transactionTable.setRowSelectionInterval(n, n);
                }
            }
        }, true);
        jPanel.add(jActionButton2);
        this.panel.add((Component)jPanel, "South");
    }

    public String getTitle() {
        return "\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u4e00\u89a7";
    }

    public JComponent getComponent() {
        return this.panel;
    }

    protected void notifyAction(String string) {
        if (string.equals("CONNECT")) {
            if (this.btSearch != null) {
                this.btSearch.getAction().setEnabled(true);
            }
        } else if (string.equals("DISCONNECT")) {
            if (this.btSearch != null) {
                this.btSearch.getAction().setEnabled(false);
                this.transactionTablePart.init();
                this.transactionDetailPart.init();
            }
        } else if (string.equals("REFRESH")) {
            this.btSearch.doClick();
            if (this.getConnection() == null && this.btSearch != null) {
                this.btSearch.getAction().setEnabled(false);
            }
        } else if (string.equals("EXPORT") && this.isActive()) {
            this.export();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private TableModel refresh(Timestamp timestamp, Timestamp timestamp2) {
        block19: {
            Statement statement;
            Connection connection;
            block17: {
                connection = null;
                statement = null;
                this.transactions = new ArrayList();
                connection = this.getConnection();
                if (connection != null) break block17;
                TransactionTableModel transactionTableModel = new TransactionTableModel(this.transactions);
                Object var13_8 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    System.err.println(sQLException.getMessage());
                }
                return transactionTableModel;
            }
            this.panel.getParent().setCursor(Cursor.getPredefinedCursor(3));
            connection.setAutoCommit(true);
            connection.setTransactionIsolation(2);
            SQLGenerator sQLGenerator = new SQLGenerator(connection);
            if (timestamp == null && timestamp2 == null) {
                statement = connection.prepareStatement("SELECT \tID,\tSTART_TIME,\tSTART_TIME_MILLIS,\tSTOP_TIME,\tSTOP_TIME_MILLIS,\tTYPE FROM TX ORDER BY START_TIME,START_TIME_MILLIS");
            } else {
                statement = connection.prepareStatement("SELECT \tID,\tSTART_TIME,\tSTART_TIME_MILLIS,\tSTOP_TIME,\tSTOP_TIME_MILLIS,\tTYPE FROM TX WHERE " + sQLGenerator.getToChar("START_TIME", "YYYYMMDD") + "\t\tBETWEEN " + sQLGenerator.getToChar("?", "YYYYMMDD") + "\t\t\tAND " + sQLGenerator.getToChar("?", "YYYYMMDD") + " ORDER BY START_TIME,START_TIME_MILLIS");
                statement.setTimestamp(1, timestamp);
                statement.setTimestamp(2, timestamp2);
            }
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString("ID");
                Timestamp timestamp3 = new Timestamp(resultSet.getTimestamp("START_TIME").getTime() + resultSet.getLong("START_TIME_MILLIS"));
                Timestamp timestamp4 = new Timestamp(resultSet.getTimestamp("STOP_TIME").getTime() + resultSet.getLong("STOP_TIME_MILLIS"));
                String string2 = resultSet.getString("TYPE");
                TransactionRecord transactionRecord = new TransactionRecord(string, timestamp3, timestamp4, string2);
                this.transactions.add(transactionRecord);
            }
            Object var13_9 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                break block19;
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException.getMessage());
            }
            break block19;
            {
                catch (SQLException sQLException) {
                    System.err.println(sQLException.getMessage());
                    Object var13_10 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block19;
                    }
                    catch (SQLException sQLException2) {
                        System.err.println(sQLException2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    System.err.println(sQLException.getMessage());
                }
                throw throwable;
            }
        }
        this.panel.getParent().setCursor(Cursor.getPredefinedCursor(0));
        return new TransactionTableModel(this.transactions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void searchTransactionDetail(TransactionRecord var1_1) {
        block13: {
            if (var1_1.getAllLaps() != null && var1_1.getAllLaps().size() > 0) {
                return;
            }
            var2_2 = null;
            var3_3 = null;
            try {
                block14: {
                    var2_2 = this.getConnection();
                    if (var2_2 != null) break block14;
                    var8_4 = null;
                    ** GOTO lbl46
                }
                this.panel.getParent().setCursor(Cursor.getPredefinedCursor(3));
                var2_2.setAutoCommit(true);
                var2_2.setTransactionIsolation(2);
                var3_3 = var2_2.createStatement();
                var4_12 = var3_3.executeQuery("SELECT ID,TIME,TIME_MILLIS FROM LAP WHERE TX_ID = '" + var1_1.getId() + "' " + "ORDER BY TIME,TIME_MILLIS,ID");
                while (var4_12.next()) {
                    var5_14 = var4_12.getString("ID");
                    var6_15 = new Timestamp(var4_12.getTimestamp("TIME").getTime() + var4_12.getLong("TIME_MILLIS"));
                    var1_1.addLap(new TransactionRecord.Lap(var5_14, var6_15));
                }
                ** GOTO lbl53
            }
            catch (SQLException var4_13) {
                System.err.println(var4_13.getMessage());
                var8_6 = null;
                try {
                    if (var3_3 != null) {
                        var3_3.close();
                    }
                }
                catch (SQLException var9_10) {
                    System.err.println(var9_10.getMessage());
                }
                break block13;
            }
            {
                catch (Throwable var7_16) {
                    var8_7 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 217->230)] { 
lbl40:
                    // 1 sources

                    if (var3_3 == null) throw var7_16;
                    var3_3.close();
                    throw var7_16;
lbl43:
                    // 1 sources

                    catch (SQLException var9_11) {
                        System.err.println(var9_11.getMessage());
                    }
                    throw var7_16;
                }
lbl46:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [6 : 217->230)] { 
lbl47:
                // 1 sources

                if (var3_3 == null) return;
                var3_3.close();
                return;
lbl50:
                // 1 sources

                catch (SQLException var9_8) {
                    System.err.println(var9_8.getMessage());
                }
                return;
lbl53:
                // 1 sources

                var8_5 = null;
                ** try [egrp 2[TRYBLOCK] [6 : 217->230)] { 
lbl55:
                // 1 sources

                if (var3_3 != null) {
                    var3_3.close();
                }
lbl59:
                // 1 sources

                catch (SQLException var9_9) {}
                System.err.println(var9_9.getMessage());
            }
        }
        this.panel.getParent().setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() {
        ExportPanel exportPanel = new ExportPanel();
        Object[] objectArray = new Object[]{exportPanel};
        int n = JOptionPane.showConfirmDialog(this.getComponent(), objectArray, "\u30a8\u30af\u30b9\u30dd\u30fc\u30c8", 2, 3);
        switch (n) {
            case 0: {
                break;
            }
            default: {
                return;
            }
        }
        System.out.println("OK");
        File file = null;
        String string = exportPanel.getExportFilePath();
        if (string != null) {
            file = new File(string);
        }
        if (file == null) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
            switch (exportPanel.getExportType()) {
                case 0: {
                    Iterator iterator = this.transactions.iterator();
                    while (iterator.hasNext()) {
                        TransactionRecord transactionRecord = (TransactionRecord)iterator.next();
                        printWriter.print(transactionRecord.getId() + ",");
                        printWriter.print(TIMESTAMP_FORMAT.format(transactionRecord.getStart()) + ",");
                        printWriter.print(TIMESTAMP_FORMAT.format(transactionRecord.getStop()) + ",");
                        printWriter.print(transactionRecord.getType() + ",");
                        printWriter.println(transactionRecord.getProcessingTime());
                    }
                    break;
                }
                case 1: {
                    Iterator iterator = this.transactions.iterator();
                    while (iterator.hasNext()) {
                    }
                    break;
                }
            }
            printWriter.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    static /* synthetic */ TransactionDetailPartPanel access$1400(TransactionTableModule transactionTableModule) {
        return transactionTableModule.transactionDetailPart;
    }

    static /* synthetic */ List access$1600(TransactionTableModule transactionTableModule) {
        return transactionTableModule.transactions;
    }

    static /* synthetic */ void access$1700(TransactionTableModule transactionTableModule, TransactionRecord transactionRecord) {
        transactionTableModule.searchTransactionDetail(transactionRecord);
    }

    private static class LapTableModel
    extends AbstractTableModel {
        private List laps;

        private LapTableModel(List list) {
            this.laps = list;
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            if (this.laps == null) {
                return 0;
            }
            return this.laps.size();
        }

        public Object getValueAt(int n, int n2) {
            TransactionRecord.Lap lap = (TransactionRecord.Lap)this.laps.get(n);
            switch (n2) {
                case 0: {
                    return lap.getKey();
                }
                case 1: {
                    return lap.getTime();
                }
                case 2: {
                    if (n == 0) {
                        return null;
                    }
                    TransactionRecord.Lap lap2 = (TransactionRecord.Lap)this.laps.get(n - 1);
                    return new Long(lap.getTime().getTime() - lap2.getTime().getTime());
                }
            }
            return null;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "\u30e9\u30c3\u30d7\u540d";
            }
            if (n == 1) {
                return "\u6642\u523b";
            }
            if (n == 2) {
                return "\u9593\u9694";
            }
            return super.getColumnName(n);
        }
    }

    private static class TransactionTableModel
    extends AbstractTableModel {
        private List list;

        private TransactionTableModel(List list) {
            this.list = list;
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return this.list.size();
        }

        public Object getValueAt(int n, int n2) {
            TransactionRecord transactionRecord = (TransactionRecord)this.list.get(n);
            switch (n2) {
                case 0: {
                    return transactionRecord.getId();
                }
                case 1: {
                    return transactionRecord.getStart();
                }
                case 2: {
                    return transactionRecord.getStop();
                }
                case 3: {
                    return transactionRecord.getType();
                }
                case 4: {
                    return new Long(transactionRecord.getProcessingTime());
                }
            }
            return "";
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "ID";
            }
            if (n == 1) {
                return "\u958b\u59cb\u6642\u523b";
            }
            if (n == 2) {
                return "\u7d42\u4e86\u6642\u523b";
            }
            if (n == 3) {
                return "TX \u30bf\u30a4\u30d7";
            }
            if (n == 4) {
                return "\u51e6\u7406\u6642\u9593[msec]";
            }
            return super.getColumnName(n);
        }
    }

    private class TransactionDetailPartPanel
    extends JPanel {
        private JFormattedTextField tfStart;
        private JFormattedTextField tfEnd;

        private TransactionDetailPartPanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(3));
            jPanel.add(new JLabel("\u30b9\u30bf\u30fc\u30c8"));
            this.tfStart = new JFormattedTextField(JawprofGuiModule.TIMESTAMP_FORMAT);
            this.tfStart.setEditable(false);
            this.tfStart.setColumns(16);
            jPanel.add(this.tfStart);
            jPanel.add(new JLabel("\u7d42\u4e86"));
            this.tfEnd = new JFormattedTextField(JawprofGuiModule.TIMESTAMP_FORMAT);
            this.tfEnd.setEditable(false);
            this.tfEnd.setColumns(16);
            jPanel.add(this.tfEnd);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("\u30e9\u30c3\u30d7");
            jLabel.setVerticalAlignment(1);
            jPanel2.add((Component)jLabel, "West");
            TransactionTableModule.this.lapTable = new JTable();
            TransactionTableModule.this.lapTable.setRowSelectionAllowed(false);
            TransactionTableModule.this.lapTable.setPreferredScrollableViewportSize(new Dimension(3, 10));
            jPanel2.add((Component)new JScrollPane(TransactionTableModule.this.lapTable), "Center");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jPanel, "North");
            jPanel3.add((Component)jPanel2, "Center");
            this.add((Component)jPanel3, "Center");
            this.init();
        }

        private void init() {
            TransactionTableModule.this.lapTable.setModel(new LapTableModel(new ArrayList()));
        }

        private void show(TransactionRecord transactionRecord) {
            if (transactionRecord == null) {
                this.tfStart.setValue(null);
                this.tfEnd.setValue(null);
                TransactionTableModule.this.lapTable.setModel(new LapTableModel(new ArrayList()));
            } else {
                this.tfStart.setValue(transactionRecord.getStart());
                this.tfEnd.setValue(transactionRecord.getStop());
                TransactionTableModule.this.lapTable.setModel(new LapTableModel(transactionRecord.getAllLaps()));
            }
            TableColumn tableColumn = TransactionTableModule.this.lapTable.getColumn("\u6642\u523b");
            tableColumn.setCellRenderer(JawprofGuiModule.dateRenderer);
            tableColumn = TransactionTableModule.this.lapTable.getColumn("\u9593\u9694");
            tableColumn.setCellRenderer(JawprofGuiModule.intRenderer);
        }

        static /* synthetic */ void access$1500(TransactionDetailPartPanel transactionDetailPartPanel, TransactionRecord transactionRecord) {
            transactionDetailPartPanel.show(transactionRecord);
        }
    }

    private class TransactionTablePartPanel
    extends JPanel {
        private TransactionTablePartPanel() {
            this.setLayout(new BorderLayout());
            TransactionTableModule.this.transactionTable = new JTable(this){
                private final /* synthetic */ TransactionTablePartPanel this$1;
                {
                    this.this$1 = transactionTablePartPanel;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    super.valueChanged(listSelectionEvent);
                    if (TransactionTableModule.access$300(TransactionTablePartPanel.access$1300(this.this$1)) != null) {
                        int n = TransactionTableModule.access$300(TransactionTablePartPanel.access$1300(this.this$1)).getSelectedRow();
                        if (n == -1) {
                            TransactionDetailPartPanel.access$1500(TransactionTableModule.access$1400(TransactionTablePartPanel.access$1300(this.this$1)), null);
                            return;
                        }
                        TransactionRecord transactionRecord = (TransactionRecord)TransactionTableModule.access$1600(TransactionTablePartPanel.access$1300(this.this$1)).get(n);
                        TransactionTableModule.access$1700(TransactionTablePartPanel.access$1300(this.this$1), transactionRecord);
                        TransactionDetailPartPanel.access$1500(TransactionTableModule.access$1400(TransactionTablePartPanel.access$1300(this.this$1)), transactionRecord);
                    }
                }
            };
            TransactionTableModule.this.transactionTable.setSelectionMode(0);
            this.add((Component)new JScrollPane(TransactionTableModule.this.transactionTable), "Center");
            this.init();
        }

        private void init() {
            TransactionTableModule.this.transactionTable.setModel(new TransactionTableModel(new ArrayList(0)));
        }

        static /* synthetic */ TransactionTableModule access$1300(TransactionTablePartPanel transactionTablePartPanel) {
            return transactionTablePartPanel.TransactionTableModule.this;
        }
    }

    private class ControlPartPanel
    extends JPanel
    implements ItemListener {
        private JCheckBox ckTerm;
        private JFormattedTextField tfDate0;
        private JFormattedTextField tfDate1;

        private ControlPartPanel() {
            this.setLayout(new FlowLayout(3));
            this.ckTerm = new JCheckBox("\u671f\u9593", true);
            this.ckTerm.addItemListener(this);
            this.add(this.ckTerm);
            this.tfDate0 = new JFormattedTextField(JawprofGuiModule.DATE_FORMAT);
            this.tfDate0.setValue(new Date());
            this.add(this.tfDate0);
            this.tfDate1 = new JFormattedTextField(JawprofGuiModule.DATE_FORMAT);
            this.tfDate1.setValue(new Date());
            this.add(this.tfDate1);
            TransactionTableModule.this.btSearch = new JButton(new SearchAction("\u691c\u7d22", TransactionTableModule.this.createIcon("toolbarButtonGraphics/general/Refresh16.gif")));
            TransactionTableModule.this.btSearch.getAction().setEnabled(false);
            this.add(TransactionTableModule.this.btSearch);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.tfDate0.setEnabled(true);
                this.tfDate0.setEditable(true);
                this.tfDate1.setEnabled(true);
                this.tfDate1.setEditable(true);
            } else if (itemEvent.getStateChange() == 2) {
                this.tfDate0.setEnabled(false);
                this.tfDate0.setEditable(false);
                this.tfDate1.setEnabled(false);
                this.tfDate1.setEditable(false);
            }
        }

        private class SearchAction
        extends AbstractAction {
            public SearchAction(String string, Icon icon) {
                super(string, icon);
                this.setEnabled(true);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                TableModel tableModel;
                Serializable serializable;
                if (ControlPartPanel.this.ckTerm.isSelected()) {
                    serializable = (Date)ControlPartPanel.this.tfDate0.getValue();
                    Date date = (Date)ControlPartPanel.this.tfDate1.getValue();
                    tableModel = TransactionTableModule.this.refresh(new Timestamp(((Date)serializable).getTime()), new Timestamp(date.getTime()));
                } else {
                    tableModel = TransactionTableModule.this.refresh(null, null);
                }
                TransactionTableModule.this.transactionTable.setModel(tableModel);
                serializable = TransactionTableModule.this.transactionTable.getColumn("\u958b\u59cb\u6642\u523b");
                if (serializable != null) {
                    ((TableColumn)serializable).setCellRenderer(JawprofGuiModule.dateRenderer);
                }
                if ((serializable = TransactionTableModule.this.transactionTable.getColumn("\u7d42\u4e86\u6642\u523b")) != null) {
                    ((TableColumn)serializable).setCellRenderer(JawprofGuiModule.dateRenderer);
                }
                if ((serializable = TransactionTableModule.this.transactionTable.getColumn("\u51e6\u7406\u6642\u9593[msec]")) != null) {
                    ((TableColumn)serializable).setCellRenderer(JawprofGuiModule.intRenderer);
                }
                if (TransactionTableModule.this.transactionTable.getRowCount() > 0) {
                    TransactionTableModule.this.transactionTable.setRowSelectionInterval(0, 0);
                }
            }
        }
    }
}

