DROP TABLE TX CASCADE CONSTRAINTS
/
CREATE TABLE TX
(
    ID                             VARCHAR2(64) NOT NULL,
    START_TIME                     TIMESTAMP NOT NULL,
    START_TIME_MILLIS              NUMBER(3,0),
    STOP_TIME                      TIMESTAMP NOT NULL,
    STOP_TIME_MILLIS               NUMBER(3,0),
    TYPE                           VARCHAR2(64)
)
/
ALTER TABLE TX
    ADD(PRIMARY KEY (ID) USING INDEX)
/
DROP TABLE LAP CASCADE CONSTRAINTS
/
CREATE TABLE LAP
(
    TX_ID                          VARCHAR2(64) NOT NULL,
    ID                             VARCHAR2(64) NOT NULL,
    TIME                           TIMESTAMP NOT NULL,
    TIME_MILLIS                    NUMBER(3,0)
)
/
ALTER TABLE LAP
    ADD(PRIMARY KEY (TX_ID, ID) USING INDEX)
/
DROP TABLE TX_GROUP CASCADE CONSTRAINTS
/
CREATE TABLE TX_GROUP
(
    ID                             VARCHAR2(64) NOT NULL,
    NAME                           VARCHAR2(64)
)
/
ALTER TABLE TX_GROUP
    ADD(PRIMARY KEY (ID) USING INDEX)
/
DROP TABLE TX_GROUP_MAP CASCADE CONSTRAINTS
/
CREATE TABLE TX_GROUP_MAP
(
    GROUP_ID                       VARCHAR2(64) NOT NULL,
    TX_TYPE                        VARCHAR2(64) NOT NULL
)
/
ALTER TABLE TX_GROUP_MAP
    ADD(PRIMARY KEY (GROUP_ID, TX_TYPE) USING INDEX)
/
ALTER TABLE LAP
    ADD(FOREIGN KEY(TX_ID) REFERENCES TX (ID) ON DELETE CASCADE)
/
ALTER TABLE TX_GROUP_MAP
    ADD(FOREIGN KEY(GROUP_ID) REFERENCES TX_GROUP (ID) ON DELETE CASCADE)
/
