/*
 * $Id: DefaultJawprofContext.java,v 1.6 2004/06/30 02:14:52 etoh Exp $
 */
package jawprof;

import java.util.*;
import org.apache.commons.logging.*;

/**
 * JawprofContext ɑ΂ftHg̎^܂. DefaultJawprofContext ͐ݒ\[X
 * oh擾܂. ftHgł "jawprof" \[Xohݒ擾܂.
 * <p>
 * ̃NX𗘗p Jawprof ̐ݒύX邱Ƃ\ł.
 * </p>
 *
 * @version 1.0
 * @see JawprofContext
 */
public class DefaultJawprofContext implements JawprofContext {

	/** ftHg̃\[Xohł. */
	public static final String RESOURCE_NAME = "jawprof";

	/** gp Logger */
	private static final Log log = LogFactory.getLog(DefaultJawprofContext.class);

	/** gp郊\[Xohł.  */
	private ResourceBundle bundle;

	/**
	 * \[X "jawprof" ŗ^郊\[Xoh, L[ "jawprof.context" ɐݒ肳
	 * Ălp JawprofContext ̃CX^X𐶐܂.
	 *
	 * @exception ClassNotFoundException
	 * @exception InstantiationException
	 * @exception IllegalAccessException
	 */
	public static JawprofContext createJawprofContext()
			throws ClassNotFoundException,InstantiationException,IllegalAccessException {

		ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_NAME);
		String jawprofContextName = bundle.getString("jawprof.context");
		log.info("Jawprof ݒǍ݂܂");
		return (JawprofContext)Class.forName(jawprofContextName).newInstance();

	}

	/**
	 * ftHg̃\[Xohݒ擾܂.
	 */
	public DefaultJawprofContext() {

		this(ResourceBundle.getBundle(RESOURCE_NAME));

	}

	/**
	 * Ŏw肳ꂽ\[Xohݒ擾܂.
	 *
	 * @param bundle ݒ񂪊i[ꂽ\[Xoh
	 */
	protected DefaultJawprofContext(ResourceBundle bundle) {

		this.bundle = bundle;

	}

	/**
	 * ݒ肳Ă RecorderFactory ̐ݒԂ܂.
	 *
	 * @return ݒ肳Ă RecorderFactory 
	 */
	public String getRecorderFactory() {

		return bundle.getString("jawprof.recorder.factory");

	}

	/**
	 * gUNVO[vƃgUNVʂ̃}bsOԂ܂.
	 *
	 * @return gUNVO[vƃgUNVʂ̃}bsO
	 */
	public Map getGroupMap() {

		Map table = new HashMap();
		for (Enumeration e = bundle.getKeys(); e.hasMoreElements();) {


			//* gUNVʂo
			String type;
			String key = (String)e.nextElement();
			if (!key.startsWith("jawprof.tx.group.")) continue;
			type = key.substring("jawprof.tx.group.".length());

			//* gUNVO[vo
			Set groups = new HashSet();
			String value = bundle.getString(key);
			for (StringTokenizer t = new StringTokenizer(value,",");
					t.hasMoreTokens();) groups.add(t.nextToken());

			//* e[uɒǉ
			table.put(type,groups);

		}
		return table;

	}

	public String getString(String key) {

		return bundle.getString(key);

	}

}

