/*
 * $Id: DefaultRecorderFactory.java,v 1.9 2004/07/03 17:21:26 etoh Exp $
 */
package jawprof;

import java.util.*;
import org.apache.commons.logging.*;
import jawprof.recorder.*;

/**
 * Recorder 쐬NX̃ftHg̎ł.
 * <p>
 * ̃NX, jawprof.recorder ɂ郌R[_[͓Ȉ܂.
 * </p>
 * <p>
 * p҂͂̃NXgēƎ̃R[_쐬ߒ Jawprof ɗv邱Ƃł܂.
 * </p>
 *
 * @version 1.0
 * @see RecorderFactory
 * @see Recorder
 */
public class DefaultRecorderFactory implements RecorderFactory {

	/** gp Logger */
	private final Log log = LogFactory.getLog(DefaultRecorderFactory.class);

	/**
	 * ^ꂽݒɏ], gp Recorder 𐶐܂.
	 *
	 * @param context ݒ
	 */
	public Recorder createRecorder(JawprofContext context) throws RecorderCreationException {

		try {

			String factory = context.getRecorderFactory();
			return createRecorder(context,factory);

		} catch (Exception e) {

			throw new RecorderCreationException(e);

		}

	}

	/**
	 * ^ꂽݒɏ], gp Recorder 𐶐܂.
	 *
	 * @param context ݒ
	 * @param factory gp RecordFactory ̖O
	 */
	private Recorder createRecorder(JawprofContext context,String factory) throws Exception {

		Recorder recorder = null;
		if (factory.equals("jawprof.NullRecorderFactory")) {

			recorder = new Recorder() {
				public void save(Monitor m) {
					//* TransactionRecord ̃v[
					MonitorFactory.poolMonitor(m);
				}
				public void saveGroupMap(String group,Collection types) {}
			};

		} else if (factory.equals("jawprof.SimpleRecorderFactory")) {

			recorder = new SimpleRecorder(context);
			log.info("ȈՃR[_쐬܂");

		} else if (factory.equals("jawprof.FileRecorderFactory")) {

			recorder = new FileRecorder(context);
			log.info("t@CR[_쐬܂");

		} else if (factory.equals("jawprof.DatabaseRecorderFactory")) {

			recorder = new DatabaseRecorder(context);
			log.info("f[^x[XR[_쐬܂");

		} else if (factory.equals("jawprof.CommonsLoggingRecorderFactory")) {

			recorder = new CommonsLoggingRecorder(context);
			log.info("Jakarta CommonsLogging R[_쐬܂");

		} else if (factory.equals("jawprof.MultiRecorderFactory")) {

			String[] memberNames
					= context.getString("jawprof.recorder.multirecorder.member").split(",");
			List members = new ArrayList();
			for (int i = 0; i < memberNames.length; i++)
					members.add(createRecorder(context,memberNames[i]));
			recorder = new MultiRecorder(members);
			log.info("}`R[_쐬܂");

		} else if (factory.equals("jawprof.TimerTaskRecorderFactory")) {

			PersistentRecorder core = (PersistentRecorder)createRecorder(context,
						context.getString("jawprof.recorder.timertaskrecorder.factory"));
			long interval = Long.parseLong(
						context.getString("jawprof.recorder.timertaskrecorder.interval"));
			recorder = new TimerTaskRecorder(core,interval);
			log.info("^C}[^XNR[_쐬܂");

		}
		if (recorder == null) recorder = new jawprof.recorder.SimpleRecorder(context);
		return recorder;

	}

}

