/*
 * $Id: Monitor.java,v 1.12 2004/07/03 17:51:44 etoh Exp $
 */
package jawprof;

import java.util.*;

/**
 * j^[IuWFNg, gUNV̊Jn,I,bv^CǗыL^
 * . e莞̓~b܂ŋL^܂. j^[IuWFNg͏ MonitorFactory NX
 * 擾܂.
 *
 * @see MonitorFactory
 * @version 1.0
 */
public final class Monitor {

	/** j^ ID */
	private Object id;

	/** gUNV ID */
	private String txId;

	/** gUNV */
	private Object type;

	/** gUNVJn */
	private long startTime;

	/** gUNVI */
	private long stopTime;

	/** gUNVbv */
	private Map lapTimes;

	/** ̃j^ێĂIuWFNg. */
	private Set holders = new HashSet();

	/**
	 * j^IuWFNg쐬܂. Monitor IuWFNg MonitorFactory ɂĐ
	 * ܂. pOɂȂ炸reset() Ă΂Kv܂.
	 * @param id j^ ID
	 */
	protected Monitor() {

		lapTimes = new HashMap();

	}

	/**
	 * j^IuWFNgɃj^ ID ƃgUNVL^IuWFNg^j^O
	 * \ɂ܂.
	 */
	void reset(Object id) {

		this.id = id;
		lapTimes.clear();

	}

	void setTransactionId(String txId) {

		this.txId = txId;

	}

	/**
	 * j^ ID Ԃ܂.
	 *
	 * @return j^ ID
	 */
	public Object getId() {

		return id;

	}

	/**
	 * gUNV ID Ԃ܂.
	 *
	 * @return gUNV ID
	 */
	public String getTransactionId() {

		return txId;

	}

	/**
	 * gUNVʂԂ܂.
	 *
	 * @return gUNV
	 */
	public Object getType() {

		return type;

	}

	/**
	 * JnԂ܂.
	 *
	 * @return Jn
	 */
	public long getStartTime() {

		return startTime;

	}

	/**
	 * IԂ܂.
	 *
	 * @return I
	 */
	public long getStopTime() {

		return stopTime;

	}

	/**
	 * bvԂ܂.
	 *
	 * @return bv񂪊i[ꂽ Map
	 */
	public Map getLapTimes() {

		return lapTimes;

	}

	/**
	 * j^OJn܂. JnL^܂.
	 *
	 * @see stop()
	 * @see lap(Object)
	 */
	public void start() {

		startTime = System.currentTimeMillis();

	}

	/**
	 * j^OI, IL^܂.
	 *
	 * @see start()
	 * @see lap(Object)
	 */
	public void stop() {

		stopTime = System.currentTimeMillis();
		MonitorFactory.stopMonitoring(this);

	}

	/**
	 * bvʂ^, Ή郉bv^Cݒ肵܂.
	 *
	 * @param id bv^C ID
	 * @see start()
	 * @see stop()
	 */
	public void lap(Object id) {

		lapTimes.put(id,new Long(System.currentTimeMillis()));

	}

	/**
	 * j^ÕgUNṼgUNVʂݒ肵܂. gUNV
	 * ͗pAvP[VCӂɌł Object ̃CX^Xł.
	 *
	 * @param type gUNV
	 */
	public void setType(Object type) {

		this.type = type;

	}

	public void hold(Object holder) {

		holders.add(holder);

	}

	public void release(Object holder) {

		holders.remove(holder);
		if (holders.size() == 0) MonitorFactory.poolMonitor(this);

	}

	/**
	 * ̃j^[IuWFNg\Ԃ܂. j^[ ID ƊĎĂgUNV
	 * ̋L^\܂.
	 *
	 * @return ̃j^[IuWFNg\
	 */
	public String toString() {

		return "Monitor:" + id;

	}

}

