/*
 * $Id: MonitorFactory.java,v 1.27 2004/06/28 06:36:34 etoh Exp $
 */
package jawprof;

import java.util.*;
import org.apache.commons.logging.*;
import org.apache.commons.pool.*;
import org.apache.commons.pool.impl.*;

/**
 * MonitorFactory  Monitor Ǘ܂. MonitorFactory ̓VOgIuWFNgłA
 * CX^XɒڃANZXKv͂ȂAԐړIɗp邽߂̐ÓI\bh񋟂Ă܂.
 *
 * @see Monitor
 * @version 1.0
 */
public class MonitorFactory {

	/** VOgCX^X */
	private static final MonitorFactory instance = new MonitorFactory();

	/** gp Logger */
	private final Log log = LogFactory.getLog(MonitorFactory.class);

	/** JawprofContext. Jawprof ̓ݒێ. */
	private JawprofContext context;

	/** jawproj.Recorder ̃CX^X. */
	private Recorder recorder;

	/** ݃j^Õj^. */
	private Map monitorings;

	/** j^IuWFNg̃v[. */
	private ObjectPool monitorPool;

	/** gUNVL^IuWFNg̃v[. */
//	private ObjectPool transactionRecordPool;

	/**
	 * Recorder 𐶐.
	 */
	private MonitorFactory() {

		//* JawprofContext ̊l
		try {

			context = DefaultJawprofContext.createJawprofContext();

		} catch (Exception e) {

			log.error("Jawprof ݒ񂪊lł܂");
			log.error(e.getMessage());
			context = new DefaultJawprofContext();

		}

		//* ANeBuȃj^[Ǘe[u쐬(L[̓j^ID)
		//*   ftHgl͐ݒ\ɏC
		monitorings = new HashMap(10000);

		//* Recorder ̐
		try {

			recorder = createRecorder(context);

		} catch (RecorderCreationException e) {

			log.warn("failer for creating a instance of jawprof.Recorder interface.");
			recorder = new Recorder() {
				public void save(Monitor m) {
					//* TransactionRecord ̃v[
					MonitorFactory.poolMonitor(m);
				}
				public void saveGroupMap(String group,Collection types) {}
			};

		}

		//* O[v}bsOۑ
		Map groupMap = context.getGroupMap();
		for (Iterator i = groupMap.keySet().iterator(); i.hasNext();) {

			String group = (String)i.next();
			recorder.saveGroupMap(group,(Collection)groupMap.get(group));

		}

		//* j^IuWFNgpv[쐬
		monitorPool = new StackObjectPool(new PooledMonitorFactory());

	}

	/**
	 * . ̓[h邽߂ɌĂ΂.
	 */
	public static void initialize() {}

	/**
	 * j^擾. w肳ꂽ ID ̃j^݂Ȃꍇ̓gUNṼj^O
	 * Jn.
	 *
	 * @param id j^ ID
	 * @return j^[
	 */
	public static Monitor getMonitor(Object id) {

		return getMonitor(id,null);

	}

	/**
	 * j^擾. w肳ꂽ ID ̃j^݂Ȃꍇ̓gUNVʂw肵,
	 * gUNṼj^OJn.
	 *
	 * @param id j^ ID
	 * @param type gUNV
	 * @return j^[
	 */
	public static Monitor getMonitor(Object id,Object type) {

		Monitor m = (Monitor)instance.monitorings.get(id);
		if (m == null) m = MonitorFactory.createNewMonitor(id,type);
		return m;

	}

	/**
	 * j^OI܂.  Monitor Ă΂܂.
	 *
	 * @param m j^OI郂j^
	 */
	protected static void stopMonitoring(Monitor m) {

		instance.monitorings.remove(m.getId());
		instance.recorder.save(m);

	}

	/**
	 * gUNVL^IuWFNgėp܂. Recorder ̎NX, gUNV
	 * L^̉ǐ, gUNVL^IuWFNgsvɂȂ_ł̃\bhĂ
	 * Ƃ܂. ̃\bhĂԂƂ, svȃgUNVL^IuWFNgė
	 * pł܂.</br>
	 * ̃\bhĂ΂Ȃꍇ, Recorder QƂ_ŃgUNVL^IuW
	 * FNg̓K[xWERNV̑ΏۂƂȂ胁ォ폜܂.
	 *
	 * @param r svƂȂgUNVL^
	 */
	public static void poolMonitor(Monitor m) {

		try {

			instance.monitorPool.returnObject(m);

		} catch (Exception e) {

			instance.log.error("j^IuWFNg̍ėpɎs܂");
			instance.log.error(e.getMessage());

		}

	}

	/**
	 * Vj^[IuWFNg쐬܂.
	 *
	 * @param id j^ ID
	 * @param type gUNV
	 * @return j^[
	 * @exception RuntimeException j^쐬łȂꍇ
	 */
	private static Monitor createNewMonitor(Object id,Object type) {

		//* j^̐
		Monitor m;
		try {

			m = (Monitor)instance.monitorPool.borrowObject();
			m.reset(id);
			m.setType(type);
			instance.monitorings.put(id,m);

		} catch (Exception e) {

			instance.log.error("j^IuWFNg̐Ɏs܂");
			instance.log.error(e.getMessage());
			m = new Monitor();
			m.reset(id);
			m.setType(type);

		}
		return m;

	}

	/**
	 * Ŏw肳ꂽ RecorderFactory ɏ] Recorder 쐬܂.
	 *
	 * @param factory RecordFactory 
	 */
	private Recorder createRecorder(JawprofContext context) throws RecorderCreationException {

		RecorderFactory factory = null;
		try {

			factory = (RecorderFactory)Class.forName(context.getRecorderFactory()).newInstance();

		} catch (Exception e) {

			factory = new DefaultRecorderFactory();

		}
		return factory.createRecorder(context);

	}

}

/**
 * Monitor IuWFNg𐶐t@Ngł.
 */
class PooledMonitorFactory extends BasePoolableObjectFactory {

	/** gUNVL^IuWFNgɍ쐬܂ */
	private int recordSequenceNum = 0;
	private long lastRecordCreationTime = 0;

	public Object makeObject() {

		return new Monitor();

	}

	/**
	 * R[hZbg
	 *
	 * @param o
	 */
	public void activateObject(Object o) throws Exception {

		Monitor m = (Monitor)o;
		m.setTransactionId(createTransactionId());

	}

	/**
	 * gUNV ID 𐶐܂.
	 *
	 * @return ꂽgUNV ID
	 */
	private synchronized String createTransactionId() {

		long recordCreationTime = System.currentTimeMillis() / 100000;
		if (recordCreationTime == lastRecordCreationTime) {

			recordSequenceNum++;
			return Long.toString(recordCreationTime) + "-" + Integer.toString(recordSequenceNum);

		} else {

			recordSequenceNum = 0;
			lastRecordCreationTime = recordCreationTime;
			return Long.toString(recordCreationTime) + "-0";

		}

	}

}

