/*
 * $Id: DatabaseConnectPanel.java,v 1.7 2004/07/02 05:28:31 etoh Exp $
 */
package jawprof.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

/**
 * f[^x[Xڑ_CAOppl񋟂܂.  JDBC f[^x[Xڑ̂߂, JDBC hCo
 * NX, JDBC f[^x[Xւ URL, [U, pX[hl邽߂̎i񋟂܂.
 * <p>
 * ̃NX̎, ڑݒ Preferences API p, ̃[Uݒc[֋L^܂.
 * Preferences API ɂĂ̓pbP[W java.util.prefs  API hLgQƂĂ.
 * </p>
 */
public class DatabaseConnectPanel extends JPanel {

	private DatabaseConnectionInfoFactory factory;
	private Map infos = new HashMap();

	/** GUI R|[lg. */
	private JComboBox cbName;
	private JComboBox cbDb;
	private JComboBox cbUrl;
	private JTextField tfUser;
	private JPasswordField tfPassword;

	/**
	 *
	 */
	public DatabaseConnectPanel(Object parent) {

		JPanel panel;
		setLayout(new BorderLayout());

		//* x
		panel = new JPanel(new GridLayout(5,1));
		panel.add(new JLabel("ڑ"));
		panel.add(new JLabel("f[^x[X"));
		panel.add(new JLabel("URL"));
		panel.add(new JLabel("[U"));
		panel.add(new JLabel("pX[h"));
		add(panel,BorderLayout.WEST);

		//* ͕̃pl
		panel = new JPanel(new GridLayout(5,1));
		add(panel,BorderLayout.CENTER);

		//* ڑ
		cbName = new JComboBox();
		cbName.setEditable(true);
		panel.add(cbName);

		//* f[^x[X
		cbDb = new JComboBox();
		cbDb.addItem("Oracle");
		cbDb.addItem("MySQL");
		//cbDb.addItem("DB2");
		//cbDb.addItem("PostgreSQL");
		panel.add(cbDb);

		//* URL
		cbUrl = new JComboBox();
		cbUrl.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent event) {

				if (event.getStateChange() == ItemEvent.SELECTED) {

					String url = (String)event.getItem();
					if (url.matches("jdbc:oracle\\:.+")) {
						cbDb.setSelectedItem("Oracle");
					} else if (url.matches("jdbc:mysql\\:.+")) {
						cbDb.setSelectedItem("MySQL");
					}

				}

			}
		});
		cbUrl.setEditable(true);
		panel.add(cbUrl);

		//* [U
		tfUser = new JTextField(10);
		//tfUser = new JTextField("etoh",10);
		panel.add(tfUser);

		//* pX[h
		tfPassword = new JPasswordField(10);
		//tfPassword = new JPasswordField("byr12772",10);
		panel.add(tfPassword);

		//* ݒ[h܂.
		factory = new PreferencesDatabaseConnectionInfoFactory(this);
		for (Iterator i = factory.getAllInfos().iterator(); i.hasNext();) {

			DatabaseConnectionInfo info = (DatabaseConnectionInfo)i.next();
			infos.put(info.getName(),info);

			//* ڑ̑IƂēo^
			cbName.addItem(info.getName());
			cbUrl.addItem(info.getUrl());

		}

		//* ڑIꂽꍇ̏
		cbName.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent event) {

				if (event.getStateChange() == ItemEvent.SELECTED) {

					String name = (String)cbName.getSelectedItem();
					load((DatabaseConnectionInfo)infos.get(name));

				}

			}
		});

		//* 擪̓o^IԂւ
		cbName.setSelectedIndex(cbName.getItemCount() - 1);

	}

	/**
	 * w肳ꂽڑIԂɂ܂.
	 *
	 * @param info IԂɂڑ
	 */
	private void load(DatabaseConnectionInfo info) {

		if (info == null) return;
		cbDb.setSelectedItem(info.getType());
		cbUrl.setSelectedItem(info.getUrl());
		tfUser.setText(info.getUser());
		tfPassword.setText(info.getPassword());

	}

	/**
	 * IĂڑԂ܂. , i\ȃt@Ng𗘗pĂꍇ, i
	 * s܂.
	 */
	public DatabaseConnectionInfo getSelectedInfo() {

		String name = (String)cbName.getSelectedItem();
		String type = (String)cbDb.getSelectedItem();
		String url = (String)cbUrl.getSelectedItem();
		String user = tfUser.getText();
		String pass = new String(tfPassword.getPassword());

		DatabaseConnectionInfo info = new DatabaseConnectionInfo(name,type,url,user,pass);
		infos.put(info.getName(),info);
		factory.store(info);

		return info;

	}

}

