/*
 * $Id: DateTableCellRenderer.java,v 1.4 2004/07/01 08:09:31 etoh Exp $
 */
package jawprof.gui;

import java.text.*;
import java.util.*;
import javax.swing.table.*;

/**
 * \ TableCellRenderer. java.text.SimpleDateFormat ɂătH[}bg܂.
 *
 * @see java.text.SimpleDateFormat
 */
public class DateTableCellRenderer extends DefaultTableCellRenderer {

	private DateFormat format;

	/**
	 * ^ꂽp^[ŕ\ TableCellRenderer 쐬܂.
	 * 
	 * @param pattern tH[}bg̃p^[
	 */
	public DateTableCellRenderer(String pattern) {

		this(new SimpleDateFormat(pattern));

	}

	/**
	 * ^ꂽtH[}bgŕ\ TableCellRenderer 쐬܂.
	 * 
	 * @param pattern tH[}bg̃p^[
	 */
	public DateTableCellRenderer(DateFormat format) {

		this.format = format;

	}

	public void setValue(Object value) {

		if (value instanceof Date) {

			super.setValue(format.format((Date)value));

		} else {

			super.setValue(value);

		}

	}

}

