/*
 * $Id: ExportPanel.java,v 1.5 2004/07/09 04:05:00 etoh Exp $
 */
package jawprof.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.filechooser.*;

/**
 * GNX|[g_CAOppl񋟂܂.
 */
public class ExportPanel extends JPanel implements ActionListener {

	public static final int TYPE_UNKNOWN = -1;
	public static final int TYPE_CSV = 0;
	public static final int TYPE_JMX = 1;

	/** o͌`w肷郉WI{^. `ɂ CSV ` XML `܂. */
	private JRadioButton rbCsv,rbXml;

	private JTextField tfFileName;
	private JButton btChooseFile;

	/** GNX|[gt@CI邽߂̃_CAO. */
	private JFileChooser chooser;

	/**
	 * GNX|[g̎sx_CAOɕ\Rec쐬܂.
	 * <p>
	 * ̃pl, o͌`₤̃WI{^, o̓t@Cݒ肷eLXgtB[h
	 * Ȃ܂.
	 * </p>
	 */
	public ExportPanel() {

		JPanel p;

		setLayout(new GridLayout(2,1));

		p = new JPanel(new FlowLayout(FlowLayout.LEFT));
		ButtonGroup group = new ButtonGroup();
		p.add(new JLabel("t@C` : "));
		rbCsv = new JRadioButton("CSV t@C",true);
		rbXml = new JRadioButton("JMeter t@C");
		group.add(rbCsv);
		p.add(rbCsv);
		group.add(rbXml);
		p.add(rbXml);
		add(p);

		p = new JPanel(new FlowLayout(FlowLayout.LEFT));
		p.add(new JLabel("t@C : "));
		tfFileName = new JTextField(20);
		p.add(tfFileName);
		btChooseFile = new JButton("...");
		btChooseFile.addActionListener(this);
		p.add(btChooseFile);
		add(p);

		//* t@C_CAO쐬(CSV t@C XML t@CI)
		chooser = new JFileChooser();
		chooser.setFileFilter(new SimpleFileFilter("csv","CSV t@C (.csv)"));
		chooser.setFileFilter(new SimpleFileFilter("jmx","JMeter t@C (.jmx)"));

	}

	/**
	 * t@C_CAO\, It@Cݒ肵܂. ̃\bh̓t@CI
	 * {^ꂽɋN܂.
	 *
	 * @param event ANVCxg
	 */
	public void actionPerformed(ActionEvent event) {

		int returnVal = chooser.showOpenDialog(this);
		if (returnVal == JFileChooser.APPROVE_OPTION)
				tfFileName.setText(chooser.getSelectedFile().getAbsolutePath());

	}

	/**
	 * GNX|[g`Ԃ܂.
	 *
	 * @return GNX|[g`
	 */
	public int getExportType() {

		if (rbCsv.isSelected()) return TYPE_CSV;
		if (rbXml.isSelected()) return TYPE_JMX;
		return TYPE_UNKNOWN;

	}

	/**
	 * w肳ꂽGNX|[gt@CԂ܂.
	 *
	 * @return GNX|[gt@C
	 */
	public String getExportFilePath() {

		return tfFileName.getText();

	}

}

