/*
 * $Id: JawprofGui.java,v 1.40 2004/07/04 17:19:26 etoh Exp $
 */
package jawprof.gui;

import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;
import javax.swing.*;

/**
 * Jawprof ̎W[N[h\ GUI ł.
 *
 * @version 1.0
 */
public class JawprofGui extends JFrame {

	public static final String INFO_VERSION = "Jawprof ver. 0.8";

	/** ftHg̃\[Xohł. */
	public static final String RESOURCE_NAME = "jawprof_gui";

	/** ANV\萔ł. */
	public static final String ACTION_NULL = "NULL";
	public static final String ACTION_TERMINATE = "TERMINATE";
	public static final String ACTION_CONNECT = "CONNECT";
	public static final String ACTION_DISCONNECT = "DISCONNECT";
	public static final String ACTION_REFRESH = "REFRESH";
	public static final String ACTION_EXPORT = "EXPORT";

	/**
	 * Look and Feel ύXANV\萔ł.
	 * <p>
	 * ̕ϐL[Ƃ #getAction(String) \bhĂяoĂANVlł܂.
	 * </p>
	 */
	public static final String ACTION_CHANGE_LOOK_AND_FEEL = "CHANGE_LOOK_AND_FEEL";

	/** Look and Feels ̕ύX̂߂̕ϐł. */
	private static final String LOOK_AND_FEEL_MAC = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
	private static final String LOOK_AND_FEEL_METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
	private static final
			String LOOK_AND_FEEL_MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
	private static final
			String LOOK_AND_FEEL_WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
	private static final String LOOK_AND_FEEL_GTK = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";

	/** gp郊\[Xohł.  */
	private ResourceBundle bundle; 

	/** \ĂSẴW[(JawprofGuiModule ̃CX^X)i[. */
	private Set modules = new HashSet();

	private Map actions = new HashMap();
	private JTabbedPane tabbedPane;
	private Connection connection = null;

	/**
	 * j[, c[o[, ʂ쐬.
	 *
	 * @param title EBhẼ^Cg
	 */
	public JawprofGui(String title) {

		//* t[̐U镑
		super(title);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				disconnect();
			}
		});

		//* \[Xǂݍ
		bundle = ResourceBundle.getBundle(RESOURCE_NAME);

		//* ACRݒ
		Image image = createImage(bundle.getString("jawprof.gui.image.icon"));
		setIconImage(image);

		//* ANV̍쐬
		createActions();

		//* j[쐬
		setJMenuBar(createMenuBar());

		//* c[o[
		getContentPane().add(createToolBar(title),BorderLayout.PAGE_START);

		//* ʍ쐬
		tabbedPane = new JTabbedPane();
		JawprofGuiModule module;

		//* gUNVꗗ
		module = new TransactionTableModule(this);
		modules.add(module);
		tabbedPane.add(module.getTitle(),module.getComponent());

		//* gUNVv
		module = new StatisticsInfoModule(this);
		modules.add(module);
		tabbedPane.add(module.getTitle(),module.getComponent());

		getContentPane().add(tabbedPane,BorderLayout.CENTER);
		tabbedPane.setSelectedIndex(0);

	}

	/**
	 * j[c[o[ĂяoANV쐬܂.
	 */
	private void createActions() {

		Icon icon;
		Action action;

		//* ڑ
		icon = new ImageIcon(createImage(bundle.getString("jawprof.gui.image.connect")));
		action = new ConnectAction("ڑ",icon);
		action.putValue(Action.SHORT_DESCRIPTION,"f[^x[Xڑ");
		actions.put(ACTION_CONNECT,action);

		//* ؒf 
		icon = new ImageIcon(createImage(bundle.getString("jawprof.gui.image.disconnect")));
		action = new DisconnectAction("ؒf",icon);
		action.putValue(Action.SHORT_DESCRIPTION,"f[^x[Xؒf");
		actions.put(ACTION_DISCONNECT,action);

		//* ŐV̏ԂɍXV
		icon = new ImageIcon(createImage(bundle.getString("jawprof.gui.image.refresh")));
		action = new RefreshAction("ŐV̏ԂɍXV",icon);
		action.putValue(Action.SHORT_DESCRIPTION,"ŐV̏ԂɍXV");
		actions.put(ACTION_REFRESH,action);

		//* GNX|[g
		icon = new ImageIcon(createImage(bundle.getString("jawprof.gui.image.export")));
		action = new ExportAction("GNX|[g",icon);
		action.putValue(Action.SHORT_DESCRIPTION,"GNX|[g");
		actions.put(ACTION_EXPORT,action);

		//* ȂANV
		actions.put(ACTION_NULL,new AbstractAction() {
			public void actionPerformed(ActionEvent e) {}
		});

	}

	/**
	 * w肳ꂽL[̃ANVԂ܂.
	 * <p>
	 * ΉANVȂꍇ͉ȂANVԂ܂. ̃ANV͂ǂ̃j
	 * [ɂ֌WĂ܂.
	 * </p>
	 *
	 * @param key ANṼL[
	 */
	public Action getAction(String key) {

		Action action = (Action)actions.get(key);
		if (action == null) action = (Action)actions.get(ACTION_NULL);
		return action;

	}

	/**
	 * j[쐬.
	 *
	 * @return 쐬ꂽj[o[
	 */
	private JMenuBar createMenuBar() {

		JMenuItem item;

		//* ڑj[
		JMenu connectMenu = new JMenu("ڑ");

		item = connectMenu.add(new JMenuItem(getAction(ACTION_CONNECT)));
		item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F3,Event.CTRL_MASK));

		item = connectMenu.add(new JMenuItem(getAction(ACTION_DISCONNECT)));
		item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4,Event.CTRL_MASK));

		connectMenu.addSeparator();
		connectMenu.add(new AbstractAction("I") {
			public void actionPerformed(ActionEvent event) {
				System.exit(0);
			}
		});

		//* \j[
		JMenu displayMenu = new JMenu("\");

		item = displayMenu.add(new JMenuItem(getAction(ACTION_REFRESH)));
		item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F5,0x0000));

		//* bNAhtB[ύX
		JMenu lookAndFeelMenu = new JMenu("Look & Feel");
		ButtonGroup group = new ButtonGroup();
		item = lookAndFeelMenu.add(new JRadioButtonMenuItem(
					new ChangeLookAndFeelsAction(LOOK_AND_FEEL_MAC)));
		group.add(item);
		item = lookAndFeelMenu.add(new JRadioButtonMenuItem(
					new ChangeLookAndFeelsAction(LOOK_AND_FEEL_METAL)));
		group.add(item);
		item.setSelected(true);
		item = lookAndFeelMenu.add(new JRadioButtonMenuItem(
					new ChangeLookAndFeelsAction(LOOK_AND_FEEL_MOTIF)));
		group.add(item);
		item = lookAndFeelMenu.add(new JRadioButtonMenuItem(
					new ChangeLookAndFeelsAction(LOOK_AND_FEEL_WINDOWS)));
		group.add(item);
		item = lookAndFeelMenu.add(new JRadioButtonMenuItem(
					new ChangeLookAndFeelsAction(LOOK_AND_FEEL_GTK)));
		group.add(item);
		displayMenu.add(lookAndFeelMenu);

		//* c[j[
		JMenu toolMenu = new JMenu("c[");

		item = toolMenu.add(new JMenuItem(getAction(ACTION_EXPORT)));
		item.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F8,0x0000));
		//toolMenu.add("GNX|[g");

		//* wvj[
		JMenu helpMenu = new JMenu("wv");
		helpMenu.add("o[W").addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				Icon icon = new ImageIcon(createImage(bundle.getString("jawprof.gui.image.icon")));
				JOptionPane.showMessageDialog(getContentPane(),INFO_VERSION,
						"o[W",JOptionPane.INFORMATION_MESSAGE,icon);
			}
		});

		//* j[o[쐬
		JMenuBar menuBar = new JMenuBar();
		menuBar.add(connectMenu);
		menuBar.add(displayMenu);
		menuBar.add(toolMenu);
		menuBar.add(helpMenu);
		//menuBar.setHelpMenu(helpMenu);

		return menuBar;

	}

	/**
	 * c[o[쐬.
	 *
	 * @param title EBhẼ^Cg
	 */
	private JToolBar createToolBar(String title) {

		ImageIcon icon;
		JButton button;
		JToolBar toolBar = new JToolBar(title);

		//* ڑ
		button = new JActionButton(getAction(ACTION_CONNECT),true);
		toolBar.add(button);

		//* ؒf
		button = new JActionButton(getAction(ACTION_DISCONNECT),true);
		toolBar.add(button);

		//* ŐV\
		button = new JActionButton(getAction(ACTION_REFRESH),true);
		toolBar.add(button);

		//* GNX|[g
		//icon = new ImageIcon(createImage(bundle.getString("jawprof.gui.image.export")));
		//button = new JActionButton(new AbstractAction("GNX|[g",icon) {
		//	public void actionPerformed(ActionEvent e) {}
		//},true);
		//button.setToolTipText("GNX|[g");
		button = new JActionButton(getAction(ACTION_EXPORT),true);
		toolBar.add(button);

		//* C|[g
		//icon = new ImageIcon(createImage(bundle.getString("jawprof.gui.image.import")));
		//toolBar.add(new JActionButton(new AbstractAction("C|[g",icon) {
		//	public void actionPerformed(ActionEvent e) {}
		//},true));

		return toolBar;

	}

	/**
	 * c[o[ŎgpC[WACR̍쐬܂.
	 *
	 * @param name \[X
	 */
	private Image createImage(String name) {

		java.net.URL url = ClassLoader.getSystemClassLoader().getResource(name);
		return Toolkit.getDefaultToolkit().createImage(url);

	}

	/**
	 * f[^x[Xɐڑ, ̐ڑIuWFNgԂ܂.
	 *
	 * @param driver JDBC hCo
	 * @param url ڑf[^x[X URL
	 * @param user ڑ[U
	 * @param pass ڑpX[h
	 */
	private Connection connect(String driver,String url,String user,String pass) {

		//* ɐڑςȂ΂̃RlNVԂ
		if (connection != null) return connection;

		//* ҂Ԃ̃J[\\
		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

		//*  null ̏ꍇ͐ڑȂ
		if (driver == null || url == null || user == null || pass == null) {

			//* ڑsɃ_CAO\
			JOptionPane.showMessageDialog(null,"alert","alert",JOptionPane.ERROR_MESSAGE);

			//* ҂Ԃ̃J[\ɖ߂ďI
			setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
			return null;

		}

		//* ڑ
		try {

			Class.forName(driver.trim());
			connection = DriverManager.getConnection(url.trim(),user.trim(),pass.trim());

		} catch (ClassNotFoundException e) {

			e.printStackTrace();

		} catch (SQLException e) {}

		//* ڑsɃ_CAO\
		if (connection == null) {

			JOptionPane.showMessageDialog(
					null,"ڑł܂ł","alert",JOptionPane.ERROR_MESSAGE);
							//e.getMessage(),

		}

		//* ҂Ԃ̃J[\\
		setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

		return connection;

	}

	/**
	 * f[^x[Xɐڑ܂.
	 */
	private void disconnect() {

		try {

			if (connection != null && !connection.isClosed()) connection.close();

		} catch (SQLException e) {

			e.printStackTrace();

		}
		connection = null;

	}

	/**
	 * f[^x[Xւ̐ڑԂ܂. ڑĂȂꍇ <code>null</code> Ԃ܂.
	 *
	 * @return f[^x[Xڑ
	 */
	public Connection getConnection() {

		return connection;

	}

	/**
	 * ڑ. j[c[o[Ă΂܂.
	 */
	private class ConnectAction extends AbstractAction {

		public ConnectAction(String name,Icon icon) {

			super(name,icon);

		}

		public void actionPerformed(ActionEvent e) {

			Object[] message = new Object[1];
			message[0] = new DatabaseConnectPanel(this);

			//* Options 
			String[] options = { "ڑ", "LZ" };

			//* _CAO\
			int result = JOptionPane.showOptionDialog( 
				getContentPane(),                // the parent that the dialog blocks 
				message,                         // the dialog message array 
				"f[^x[Xڑ",              // the title of the dialog window 
				JOptionPane.DEFAULT_OPTION,      // option type 
				JOptionPane.INFORMATION_MESSAGE, // message type 
				null,                            // optional icon, use null to use the default icon 
				options,                         // options string array, will be made into buttons 
				options[1]                      // option that should be made into a default button 
			); 

			switch (result) { 

				//* ڑ 
				case 0:
					DatabaseConnectPanel panel = (DatabaseConnectPanel)message[0];
					DatabaseConnectionInfo info = panel.getSelectedInfo();

					String driver = null;
					String type = info.getType();
					if (type.equals("Oracle")) {
						driver = "oracle.jdbc.driver.OracleDriver";
					} else if (type.equals("MySQL")) {
						driver = "org.gjt.mm.mysql.Driver";
					}
					String url = info.getUrl();
					String user = info.getUser();
					String password = info.getPassword();
					connection = connect(driver,url,user,password);
					if (connection != null) {
						getAction(ACTION_CONNECT).setEnabled(false);
						getAction(ACTION_DISCONNECT).setEnabled(true);

						//* SẴW[ɐڑƂʒm
						for (Iterator i = modules.iterator(); i.hasNext();) {

							JawprofGuiModule each = (JawprofGuiModule)i.next();
							each.notifyAction(ACTION_CONNECT);

						}

					}
					break; 

				//* LZ
				case 1:
					break; 
				default: 
					break; 

			}

		} 

	}

	/**
	 * ؒf. j[c[o[Ă΂܂.
	 */
	private class DisconnectAction extends AbstractAction {

		public DisconnectAction(String name,Icon icon) {

			super(name,icon);
			setEnabled(false);

		}

		/**
		 * f[^x[X̐ؒfs܂. , ڑANVLɂ, ؒfANV
		 * ɂ܂.
		 *
		 * @param event Cxg
		 */
		public void actionPerformed(ActionEvent event) {

			disconnect();
			getAction(ACTION_CONNECT).setEnabled(true);
			getAction(ACTION_DISCONNECT).setEnabled(false);

			//* SẴW[ɐڑƂʒm
			for (Iterator i = modules.iterator(); i.hasNext();) {

				JawprofGuiModule each = (JawprofGuiModule)i.next();
				each.notifyAction(ACTION_DISCONNECT);

			}

		}

	}

	/**
	 * ŐV̏ԂɍXV鏈.
	 */
	private class RefreshAction extends AbstractAction {

		public RefreshAction(String name,Icon icon) {

			super(name,icon);

		}

		/**
		 * ܂.
		 *
		 * @param event Cxg
		 */
		public void actionPerformed(ActionEvent event) {

			//* SẴW[ɐڑƂʒm
			for (Iterator i = modules.iterator(); i.hasNext();) {

				JawprofGuiModule each = (JawprofGuiModule)i.next();
				each.notifyAction(ACTION_REFRESH);

			}

		}

	}

	/**
	 * Look and Feels ̕ύXANV.
	 */
	private class ChangeLookAndFeelsAction extends AbstractAction {

		/**
		 * w肳ꂽ Look and Feel ɕύXANV쐬܂.
		 */
		public ChangeLookAndFeelsAction(String name) {

			super(name);

			//* L Look and Feel ǂ, c[`bvp̃eLXgȂǂZbg
			//*  Look and Feel ̏ꍇ̓ANV𖳌ɂ
			try {

				LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(name).newInstance();
				putValue(NAME,lookAndFeel.getName());
				putValue(ACTION_COMMAND_KEY,name);
				putValue(SHORT_DESCRIPTION,lookAndFeel.getDescription());
				if (!lookAndFeel.isSupportedLookAndFeel()) this.setEnabled(false);

			} catch (Exception e) {

				this.setEnabled(false);

			}

		}

		/**
		 * Look and Feels ύX܂.
		 *
		 * @param event Cxg
		 */
		public void actionPerformed(ActionEvent event) {

			try {

				UIManager.setLookAndFeel(event.getActionCommand());
				SwingUtilities.updateComponentTreeUI(JawprofGui.this);

			} catch (Exception e) {

				System.out.println(e);

			}

			//* SẴW[ɐڑƂʒm
			for (Iterator i = modules.iterator(); i.hasNext();) {

				JawprofGuiModule each = (JawprofGuiModule)i.next();
				each.notifyAction(ACTION_CHANGE_LOOK_AND_FEEL);

			}

		}

	}

	/**
	 * GNX|[g
	 */
	private class ExportAction extends AbstractAction {

		/**
		 *
		 */
		public ExportAction(String name,Icon icon) {

			super(name,icon);

		}

		/**
		 *
		 * @param event Cxg
		 */
		public void actionPerformed(ActionEvent event) {

			//* SẴW[ɐڑƂʒm
			for (Iterator i = modules.iterator(); i.hasNext();) {

				JawprofGuiModule each = (JawprofGuiModule)i.next();
				each.notifyAction(ACTION_EXPORT);

			}

		}

	}

	/**
	 * ftHg JawprofGui N܂.
	 * <p>
	 *  <code>center</code>, <code>left</code>, <code>right</code>, <code>top</code>,
	 * <code>bottom</code>w肳ꂽꍇ̓t[̈ʒu𒲐܂.
	 * </p>
	 */
	public static void main(String[] args) {

		//* JawprofGui 쐬
		JFrame f = new JawprofGui("Jawprof GUI");
		f.pack();

		int xoffs = 0;
		int yoffs = 0;

		//* fBXvC擾
		if (args.length != 0) {

			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			GraphicsDevice[] gs = ge.getScreenDevices();
			//GraphicsDevice gd = gs[0];
			GraphicsConfiguration[] gc = gs[0].getConfigurations();
			Rectangle gcBounds = gc[0].getBounds();

			//* \ʒǔ
			for (int i = 0; i < args.length; i++) {

				//* fBXvC̒ɔzu
				if (args[i].equals("center") || args[i].equals("c")) {
					xoffs = (gcBounds.width - f.getWidth()) / 2 + gcBounds.x;
					yoffs = (gcBounds.height - f.getHeight()) / 2 + gcBounds.y;
				}

				//* fBXvC̐zu
				if (args[i].equals("left") || args[i].equals("l")) xoffs = 0;
				if (args[i].equals("right") || args[i].equals("r")) xoffs = gcBounds.width;

				//* fBXvC̐zu
				if (args[i].equals("top") || args[i].equals("t")) yoffs = 0;
				if (args[i].equals("bottom") || args[i].equals("b")) yoffs = gcBounds.height;

			}

		}

		//* JawprofGui \
		f.setLocation(xoffs,yoffs);
		f.show();

	}

}

