/*
 * $Id: JawprofGuiModule.java,v 1.10 2004/07/04 17:33:32 etoh Exp $
 */
package jawprof.gui;

import java.sql.*;
import java.text.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * JawprofGui  JTabbedPanel ɒǉ郂W[ł.
 *
 * @version 1.0
 */
public abstract class JawprofGuiModule {

	/** gUNṼbv^C̕\悤Ɏgp. */
	protected static final DateFormat
			TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");

	/** Ԃ̓͗ptH[}bgƂėp. */
	protected static final Format DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");

	/** e[u̓tJp̃_. */
	protected static final TableCellRenderer
			dateRenderer = new DateTableCellRenderer(TIMESTAMP_FORMAT);

	/** e[u̐Jp̃_. */
	protected static final TableCellRenderer
			intRenderer = new NumberTableCellRenderer("############");

	/** e[u̎Jp̃_. */
	protected static final TableCellRenderer
			realRenderer = new NumberTableCellRenderer("###########0.000");

	private JawprofGui gui;

	/**
	 * JawprofGui ɒǉ郂W[쐬܂.
	 *
	 * @param gui JawprofGui
	 */
	public JawprofGuiModule(JawprofGui gui) {

		this.gui = gui;

	}

	/**
	 * ̃W[̃^CgԂ܂. ftHg̎ JawprofGui ̃^upl̃^Cg
	 * gp܂.
	 *
	 * @return ̃W[̃^Cg.
	 */
	public abstract String getTitle();

	/**
	 * ǉR|[lgԂ܂. Ǝ̃W[ǉꍇ͂̃\bh܂.
	 */
	public abstract JComponent getComponent();

	/**
	 * JawprofGui Ă΂܂. Ŏw肳ꂽf[^x[XڑȂǂ̃ANV
	 * ʒm܂. ̃ANV̎ނ, jawprof.gui.JawprofGui Œ`Ă܂.
	 * <p>
	 * ftHg̎͋̎ł. KvΌp̃NXŃI[o[Ch܂.
	 * </p>
	 *
	 * @param actionType ANV^Cv ID
	 * @see jawprof.gui.JawprofGui
	 */
	protected void notifyAction(String actionType) {}

	/**
	 * ̃W[\Ă邩ǂԂ܂.
	 */
	protected boolean isActive() {

		try {

			JTabbedPane p = (JTabbedPane)getComponent().getParent();
			return (p.getSelectedComponent() == getComponent());

		} catch (Exception e) {

			return false;

		}

	}

	/**
	 * ڑĂf[^x[Xւ̐ڑԂ܂.
	 *
	 * @see JawprofGui#getConnection()
	 */
	protected Connection getConnection() {

		return gui.getConnection();

	}

	/**
	 * R|[lgp̃C[WACR쐬܂.
	 *
	 * @param name \[X
	 */
	protected Icon createIcon(String name) {

		java.net.URL url = ClassLoader.getSystemClassLoader().getResource(name);
		return new ImageIcon(url);

	}

	/**
	 * w肳ꂽL[̃ANVԂ܂.
	 * <p>
	 * ΉANVȂꍇ͉ȂANVԂ܂. ̃ANV͂ǂ̃j
	 * [ɂ֌WĂ܂.
	 * </p>
	 *
	 * @param key ANṼL[
	 * @see JawprofGui#getAction()
	 */
	public Action getAction(String key) {

		return gui.getAction(key);

	}

}

