/*
 * $Id: NumberTableCellRenderer.java,v 1.2 2004/07/01 08:10:23 etoh Exp $
 */
package jawprof.gui;

import java.text.*;
import javax.swing.table.*;

/**
 * l\ TableCellRenderer. java.text.NumberFormat ɂătH[}bg܂.
 * <p>
 *  TableCellRenderer , l java.lang.Number ̃CX^X̂Ƃw肳ꂽtH[}bg
 * _O܂. SĂ̒lE߂ŕ\܂.
 * </p>
 *
 * @see java.text.NumberFormat
 */
public class NumberTableCellRenderer extends DefaultTableCellRenderer {

	private NumberFormat format;

	/**
	 * ^ꂽp^[ŕ\ TableCellRenderer 쐬܂.
	 * 
	 * @param pattern tH[}bg̃p^[
	 * @see java.text.DecimalFormat
	 */
	public NumberTableCellRenderer(String pattern) {

		this(new DecimalFormat(pattern));

	}

	/**
	 * ^ꂽtH[}bgŕ\ TableCellRenderer 쐬܂.
	 * 
	 * @param pattern tH[}bg̃p^[
	 */
	public NumberTableCellRenderer(NumberFormat format) {

		this.format = format;
		setHorizontalAlignment(RIGHT);

	}

	public void setValue(Object value) {

		if (value instanceof Number) {

			super.setValue(format.format((Number)value));

		} else {

			super.setValue(value);

		}

	}

}

