/*
 * $Id: PreferencesDatabaseConnectionInfoFactory.java,v 1.3 2004/07/01 08:10:23 etoh Exp $
 */
package jawprof.gui;

import java.util.*;
import java.util.prefs.*;

/**
 * f[^x[Xڑ_CAOppl񋟂܂.  JDBC f[^x[Xڑ̂߂, JDBC hCo
 * NX, JDBC f[^x[Xւ URL, [U, pX[hl邽߂̎i񋟂܂.
 * <p>
 * ̃NX̎, ڑݒ Preferences API p, ̃[Uݒc[֋L^܂.
 * Preferences API ɂĂ̓pbP[W java.util.prefs  API hLgQƂĂ.
 * </p>
 */
public class PreferencesDatabaseConnectionInfoFactory implements DatabaseConnectionInfoFactory {

	private Preferences baseNode;
	private Set infos = new HashSet();

	/**
	 * ݒ[h܂.
	 */
	public PreferencesDatabaseConnectionInfoFactory(Object parent) {

		Preferences packageNode = Preferences.userNodeForPackage(parent.getClass());
		baseNode = packageNode.node("DatabaseConnectPanel/Databases");

	}

	private void load() {

		try {

			//* ݒi[
			String[] names = baseNode.childrenNames();
			for (int i = 0; i < names.length; i++) {

				Preferences p = baseNode.node(names[i]);
				DatabaseConnectionInfo
						info = new DatabaseConnectionInfo(
							names[i],
							p.get("type",""),
							p.get("url",""),
							p.get("user",""),
							p.get("pass",""));
				infos.add(info);

			}

		} catch (BackingStoreException e) {

			e.printStackTrace();

		}

		/*
		DatabaseConnectionInfo info;
		info = new DatabaseConnectionInfo(
				"orcl",
				"Oracle",
				"jdbc:oracle:thin:@192.168.37.135:1521:orcl",
				"etoh",
				"byr12772");
		infos.add(info);
		info = new DatabaseConnectionInfo(
				"mysql",
				"MySQL",
				"jdbc:mysql:///jawprof?useUnicode=true&characterEncoding=SJIS",
				"etoh",
				"byr12772");
		infos.add(info);
		*/

	}

	/**
	 * [hꂽSĂ̐ڑԂ܂.
	 *
	 * @return SĂ̐ڑ
	 */
	public Set getAllInfos() {

		load();
		return infos;

	}

	public void store(DatabaseConnectionInfo info) {

		Preferences node = baseNode.node(info.getName());
		node.put("type",info.getType());
		node.put("url",info.getUrl());
		node.put("user",info.getUser());
		node.put("pass",info.getPassword());

	}

}

