/*
 * $Id: SQLGenerator.java,v 1.6 2004/07/05 09:39:09 etoh Exp $
 */
package jawprof.gui;

import java.sql.*;

/**
 *
 * @version 1.0
 */
class SQLGenerator {

	private String productName;

	/**
	 * ڑ̃f[^x[Xʂݒ肵܂.
	 *
	 * @param c f[^x[Xڑ
	 */
	SQLGenerator(Connection c) throws SQLException {

		productName = c.getMetaData().getDatabaseProductName();

	}

	/**
	 * ŗ^ꂽڑ̃f[^x[XɑΉt𕶎ɕϊ֐Ԃ܂.
	 * <p>
	 *    <dl>
	 *       <dt>Oracle</dt><dd>TO_CHAR()</dd>
	 *       <dt>MySQL</dt><dd>DATE_FORMAT()</dd>
	 *    </dl>
	 * </p>
	 *
	 * @param arg1 Ԃ̊JñtB[h
	 * @param arg2 Ԃ̏ĨtB[h
	 */
	public String getToChar(String arg1,String arg2) throws SQLException {

		if (productName.equals("Oracle")) {

			return "TO_CHAR(" + arg1 + ",'" + arg2 + "')";

		} else if (productName.equals("MySQL")) {

			if (arg2.equals("D")) {

				return "DAYOFWEEK(" + arg1 + ")";

			}
			String pattern = arg2.replaceAll("YYYY","\\%Y")
								.replaceAll("MM","\\%m")
								.replaceAll("DD","\\%d")
								.replaceAll("HH24","\\%H")
								.replaceAll("MI","\\%i")
								.replaceAll("D","\\%w")
								.replaceAll("W","\\%u");
			return "DATE_FORMAT(" + arg1 + ",'" + pattern + "')";

		}
		return "";

	}

	/**
	 * 2 ̓tڂ̍Zo SQL ̈ꕔ𐶐܂.
	 *
	 * @param c f[^x[Xڑ
	 * @param arg1 Ԃ̊JñtB[h
	 * @param arg2 Ԃ̏ĨtB[h
	 */
	public String getDateDiff(String arg1,String arg2) throws SQLException {

		String quotient = arg2  + " - " + arg1;
		if (productName.equals("Oracle")) {

			return "EXTRACT(DAY FROM " + quotient + ") * 24 * 60 * 60 * 1000 +" +
				"	EXTRACT(HOUR FROM " + quotient + ") * 60 * 60 * 1000 +" +
				"	EXTRACT(MINUTE FROM " + quotient + ") * 60 * 1000 +" +
				"	TRUNC(ABS(EXTRACT(SECOND FROM " + quotient + "))) * 1000";

		} else if (productName.equals("MySQL")) {

			return "(" + quotient + ") * 1000";

		}
		return "";

	}

	/**
	 * he[u SQL ̐߂Ԃ܂.
	 *
	 * @param c f[^x[Xڑ
	 * @param name e[u
	 */
	public String getTableNamingPhrase(String name) throws SQLException {

		if (productName.equals("Oracle")) {

			return name;

		} else if (productName.equals("MySQL")) {

			return "AS " + name;

		}
		return name;

	}

}

