/*
 * $Id: SimpleFileFilter.java,v 1.1 2004/07/06 02:04:13 etoh Exp $
 */
package jawprof.gui;

import java.io.*;
import java.util.*;
import javax.swing.filechooser.*;

/**
 * javax.swing.filechooser.FileFilter ̃VvȎł.
 *
 * @version 1.0
 */
public class SimpleFileFilter extends javax.swing.filechooser.FileFilter {

	/** TtBbNXi[܂. */
    private HashSet suffixes = new HashSet();

	/** ̃tB^t@C̐ł. */
    private String description;

	public SimpleFileFilter(String suffix) {

		this(suffix,null);

	}

	public SimpleFileFilter(String suffix,String description) {

		suffixes.add(suffix);
		this.description = description;

    }

    public SimpleFileFilter(String[] suffixes) {

		this(suffixes,null);

	}

	public SimpleFileFilter(String[] suffixes,String description) {

		this.suffixes.addAll(Arrays.asList(suffixes));
		this.description = description;

	}

	public boolean accept(File f) {

		if (f == null) return false;
		if (suffixes.contains(f)) return true;
		if (f.isDirectory()) return true;
		return false;

	}

	public String getDescription() {

		return description;

	}

}

