/*
 * $Id: StatisticsInfoModule.java,v 1.28 2004/07/05 09:39:09 etoh Exp $
 */
package jawprof.gui;

import java.awt.*;
import java.awt.event.*;
import java.sql.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * v\郂W[.
 *
 * @version 1.0
 */
public class StatisticsInfoModule extends JawprofGuiModule {

	public static final int STATISTICS_UNIT_HOUR = 0;
	public static final int STATISTICS_UNIT_DAY = 1;
	public static final int STATISTICS_UNIT_DATE = 2;
	public static final int STATISTICS_UNIT_WEEK = 3;
	public static final int STATISTICS_UNIT_MONTH = 4;
	public static final int STATISTICS_UNIT_TYPE = 5;

	/** GUI R|[lg.  */
	private JSplitPane pane;
	private JTable statisticsTable;
	private JScrollPane scrollPane;
	private JButton btSearch;

	public StatisticsInfoModule(JawprofGui gui) {

		super(gui);
		pane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
				new ControlPartPanel(),new StatisticsInfoPartPanel());

	}

	public String getTitle() {

		return "v";

	}

	public JComponent getComponent() {

		return pane;

	}

	/**
	 * f[^x[Xڑ, {^ANeBuɂ, f[^x[Xؒf͌{^AN
	 * eBuɕύX.
	 *
	 * @param actionType ANV̎
	 */
	protected void notifyAction(String actionType) {

		if (actionType.equals(JawprofGui.ACTION_CONNECT)) {

			if (btSearch != null) btSearch.getAction().setEnabled(true);

		} else if (actionType.equals(JawprofGui.ACTION_DISCONNECT)) {

			if (btSearch != null) {
				
				btSearch.getAction().setEnabled(false);
				statisticsTable.setModel(
						new StatisticsInfoTableModel(STATISTICS_UNIT_HOUR,new ArrayList()));

			}

		}

	}

	/**
	 * s.
	 *
	 * @param unit WvPʂl
	 * @param t0 Ԃ̎n
	 * @param t1 Ԃ̏I
	 */
	private TableModel refresh(int unit,java.sql.Timestamp t0,java.sql.Timestamp t1) {

		Connection connection = null;
		PreparedStatement query = null;
		java.util.List list = new ArrayList();
		try {

			//* ڑ
			connection = getConnection();
			if (connection == null)
					return new StatisticsInfoTableModel(unit,list);

			//* ҂Ԃ̃J[\\
			pane.getParent().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

			connection.setAutoCommit(true);
			connection.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);

			String unitString;
			String termString;
			SQLGenerator sqlGenerator = new SQLGenerator(connection);
			switch (unit) {
				case STATISTICS_UNIT_HOUR:
					unitString = sqlGenerator.getToChar("START_TIME","YYYYMMDD HH24");
					termString = "24";
					break;
				case STATISTICS_UNIT_DAY:
					unitString = sqlGenerator.getToChar("START_TIME","D");
					termString = "24";
					break;
				case STATISTICS_UNIT_DATE:
					unitString = sqlGenerator.getToChar("START_TIME","YYYYMMDD");
					termString = "24";
					break;
				case STATISTICS_UNIT_WEEK:
					unitString = sqlGenerator.getToChar("START_TIME","YYYYMM W");
					termString = "24";
					break;
				case STATISTICS_UNIT_MONTH:
					unitString = sqlGenerator.getToChar("START_TIME","YYYYMM");
					termString = "24";
					break;
				case STATISTICS_UNIT_TYPE:
					unitString = "TYPE";
					termString = "24";
					break;
				default:
					unitString = "TYPE";
					termString = "24";
					break;
			}

			//* gUNVe[u֒ǉ
			if (t0 == null && t1 == null) {

				query = connection.prepareStatement(
						"SELECT " +
						"		UNIT," +
						"		AVG(PROCESSING_TIME) AS AVG," +
						"		MIN(PROCESSING_TIME) AS MIN," +
						"		MAX(PROCESSING_TIME) AS MAX," +
						"		STDDEV(PROCESSING_TIME) AS STDDEV," +
						"		COUNT(*) AS COUNT " +
						"FROM (" +
						"	SELECT " + unitString + " AS UNIT," +
								sqlGenerator.getDateDiff("START_TIME","STOP_TIME") +
						"			+" +
						"			STOP_TIME_MILLIS - START_TIME_MILLIS " +
						"				AS PROCESSING_TIME " +
						"		FROM TX" +
						") " + sqlGenerator.getTableNamingPhrase("T") + " " +
						"GROUP BY UNIT " +
						"ORDER BY UNIT"
					);

			} else {

				query = connection.prepareStatement(
						"SELECT " +
						"		UNIT," +
						"		AVG(PROCESSING_TIME) AS AVG," +
						"		MIN(PROCESSING_TIME) AS MIN," +
						"		MAX(PROCESSING_TIME) AS MAX," +
						"		STDDEV(PROCESSING_TIME) AS STDDEV," +
						"		COUNT(*) AS COUNT " +
						"FROM (" +
						"	SELECT " + unitString + " AS UNIT," +
								sqlGenerator.getDateDiff("START_TIME","STOP_TIME") +
						"			+" +
						"			STOP_TIME_MILLIS - START_TIME_MILLIS " +
						"				AS PROCESSING_TIME " +
						"		FROM TX" +
						"		WHERE " +
									sqlGenerator.getToChar("START_TIME","YYYYMMDD") +
						"				BETWEEN " +
											sqlGenerator.getToChar("?","YYYYMMDD") +
						"				AND " +
											sqlGenerator.getToChar("?","YYYYMMDD") +
						") " + sqlGenerator.getTableNamingPhrase("T") + " " +
						"GROUP BY UNIT " +
						"ORDER BY UNIT"
					);
				query.setTimestamp(1,t0);
				query.setTimestamp(2,t1);

			}

			ResultSet result = query.executeQuery();
			int i = 0;
			while (result.next()) {

				Object[] rec = new Object[6];
				//Object[] rec = new Object[7];

				rec[0] = result.getString("UNIT");
				rec[1] = new Long(result.getLong("AVG"));
				rec[2] = new Long(result.getLong("MIN"));
				rec[3] = new Long(result.getLong("MAX"));
				rec[4] = new Double(result.getDouble("STDDEV"));
				rec[5] = new Long(result.getLong("COUNT"));
				//rec[6] = new Double(result.getDouble("RATE"));

				list.add(rec);

			}

		} catch (SQLException e) {

			System.err.println(e.getMessage());

		} finally {

			try {

				if (query != null) query.close();

			} catch (SQLException e) {

				System.err.println(e.getMessage());

			}

		}

		//* ҂Ԃ̃J[\\
		pane.getParent().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

		return new StatisticsInfoTableModel(unit,list);

	}

	/**
	 * Rg[p[g.
	 */
	private class ControlPartPanel extends JPanel implements ItemListener {

		private JCheckBox ckTerm;
		private JFormattedTextField tfDate0,tfDate1;
		private JRadioButton rbHour,rbDay,rbDate,rbWeek,rbMonth,rbType;

		public ControlPartPanel() {

			JPanel p;
			setLayout(new GridLayout(2,1));

			//* Wv(x)
			p = new JPanel(new FlowLayout(FlowLayout.LEADING));
			ckTerm = new JCheckBox("Wv",true);
			ckTerm.addItemListener(this);
			p.add(ckTerm);

			//* Wv(n)
			tfDate0 = new JFormattedTextField(DATE_FORMAT);
			tfDate0.setValue(new java.util.Date());
			p.add(tfDate0);

			//* Wv(I)
			tfDate1 = new JFormattedTextField(DATE_FORMAT);
			tfDate1.setValue(new java.util.Date());
			p.add(tfDate1);
			add(p);

			//* WvP
			ButtonGroup group = new ButtonGroup();

			p = new JPanel(new FlowLayout(FlowLayout.LEADING));
			p.add(new JLabel("WvP"));

			rbHour = new JRadioButton("",true);
			group.add(rbHour);
			//radio.setForeground(Color.RED);
			p.add(rbHour );

			rbDay = new JRadioButton("j");
			group.add(rbDay );
			//radio.setForeground(Color.RED);
			p.add(rbDay );

			rbDate = new JRadioButton("t");
			group.add(rbDate );
			//radio.setForeground(Color.RED);
			p.add(rbDate );

			rbWeek = new JRadioButton("T");
			group.add(rbWeek );
			//radio.setForeground(Color.RED);
			p.add(rbWeek );

			rbMonth = new JRadioButton("");
			group.add(rbMonth );
			//radio.setForeground(Color.RED);
			p.add(rbMonth );

			rbType = new JRadioButton("^Cv");
			group.add(rbType );
			//radio.setForeground(Color.RED);
			p.add(rbType );

			//* {^
			btSearch = new JButton(new SearchAction(
						"",createIcon("toolbarButtonGraphics/general/Refresh16.gif")));
			btSearch.getAction().setEnabled(false);
			p.add(btSearch);
			//btSearch.addActionListener(this);

			add(p);

		}

		public void itemStateChanged(ItemEvent event) {

			if (event.getStateChange() == ItemEvent.SELECTED) {

				tfDate0.setEditable(true);
				tfDate1.setEditable(true);
				tfDate0.setEnabled(true);
				tfDate1.setEnabled(true);

			} else if (event.getStateChange() == ItemEvent.DESELECTED) {


				tfDate0.setEditable(false);
				tfDate1.setEditable(false);
				tfDate0.setEnabled(false);
				tfDate1.setEnabled(false);

			}

		}

		/**
		 * v̌sANVł.
		 */
		private class SearchAction extends AbstractAction {

			public SearchAction(String name,Icon icon) {

				super(name,icon);
				setEnabled(true);

			}

			/**
			 * s܂.
			 */
			public void actionPerformed(ActionEvent event) {

				TableModel model;

				//* ܂
				if (ckTerm.isSelected()) {

					java.util.Date d0 = (java.util.Date)tfDate0.getValue();
					java.util.Date d1 = (java.util.Date)tfDate1.getValue();
					model = refresh(getSelectedUnit(),
							new Timestamp(d0.getTime()),new Timestamp(d1.getTime()));

				} else {

					model = refresh(getSelectedUnit(),null,null);

				}

				statisticsTable.setModel(model);

				//* ̕\ύX
				TableColumn column;
				switch (getSelectedUnit()) {
					case STATISTICS_UNIT_HOUR:
						column = statisticsTable.getColumn("");
						if (column != null)
							column.setCellRenderer(new DateTableCellRenderer("yyyy/MMdd HH:mm"));
						break;
					case STATISTICS_UNIT_DAY :
						column = statisticsTable.getColumn("j");
						if (column != null)
							column.setCellRenderer(new DateTableCellRenderer(" E "));
						break;
					case STATISTICS_UNIT_DATE :
						column = statisticsTable.getColumn("t");
						if (column != null)
							column.setCellRenderer(new DateTableCellRenderer("yyyy/MMdd"));
						break;
					case STATISTICS_UNIT_WEEK :
						column = statisticsTable.getColumn("T");
						if (column != null)
							column.setCellRenderer(new DateTableCellRenderer("yyyy/MM  W T"));
						break;
					case STATISTICS_UNIT_MONTH :
						column = statisticsTable.getColumn("");
						if (column != null)
							column.setCellRenderer(new DateTableCellRenderer("yyyy/MM"));
						break;
					default:
						break;
				}
				column = statisticsTable.getColumn("Ϗ");
				if (column != null) column.setCellRenderer(intRenderer);
				column = statisticsTable.getColumn("ŏ");
				if (column != null) column.setCellRenderer(intRenderer);
				column = statisticsTable.getColumn("ő又");
				if (column != null) column.setCellRenderer(intRenderer);
				column = statisticsTable.getColumn("ԕ΍");
				if (column != null) column.setCellRenderer(realRenderer);
				column = statisticsTable.getColumn("");
				if (column != null) column.setCellRenderer(intRenderer);
				//column = statisticsTable.getColumn("");
				//if (column != null) column.setCellRenderer(realRenderer);

				//* 擪sI
				if (statisticsTable.getRowCount() > 0) statisticsTable.setRowSelectionInterval(0,0);

			}

		}

		/**
		 * ݏWvPʂƂĎw肳Ă鍀ڂlԂ܂.
		 */
		private int getSelectedUnit() {

			if (rbHour.isSelected()) {

				return STATISTICS_UNIT_HOUR;

			} else if (rbDay.isSelected()) {

				return STATISTICS_UNIT_DAY;

			} else if (rbDate.isSelected()) {

				return STATISTICS_UNIT_DATE;

			} else if (rbWeek.isSelected()) {

				return STATISTICS_UNIT_WEEK;

			} else if (rbMonth.isSelected()) {

				return STATISTICS_UNIT_MONTH;

			} else if (rbType.isSelected()) {

				return STATISTICS_UNIT_TYPE;

			} else {

				return -1;

			}

		}

	}

	/**
	 * vl\.
	 */
	private class StatisticsInfoPartPanel extends JPanel {

		public StatisticsInfoPartPanel()  {

			setLayout(new BorderLayout());

			//* e[u쐬ăplɒǉ
			statisticsTable = new JTable(
					new StatisticsInfoTableModel(STATISTICS_UNIT_HOUR,new ArrayList()));
			add(new JScrollPane(statisticsTable),BorderLayout.CENTER);

		}

	}

	/**
	 * vp̃e[ufł.
	 */
	private static class StatisticsInfoTableModel extends AbstractTableModel {

		private int unit;
		private java.util.List info;
		private DateFormat format;

		private StatisticsInfoTableModel(int unit,java.util.List info) {

			this.unit = unit;
			this.info = info;

			switch (unit) {
				case STATISTICS_UNIT_HOUR:
					format = new SimpleDateFormat("yyyyMMdd HH");
					break;
				case STATISTICS_UNIT_DAY :
					format = new SimpleDateFormat("F");
					break;
				case STATISTICS_UNIT_DATE :
					format = new SimpleDateFormat("yyyyMMdd");
					break;
				case STATISTICS_UNIT_WEEK :
					format = new SimpleDateFormat("yyyyMM W");
					break;
				case STATISTICS_UNIT_MONTH :
					format = new SimpleDateFormat("yyyyMM");
					break;
				case STATISTICS_UNIT_TYPE :
					format = null;
					break;
				default:
					format = null;
					break;
			}

		}

		public int getColumnCount() {

			return 6;
			//return 7;

		}

		public int getRowCount() {

			return info.size();

		}

		public Object getValueAt(int row,int col) {

			Object[] rec = (Object[])info.get(row);
			switch (col) {
				case 0:
					switch (unit) {
						case STATISTICS_UNIT_HOUR:
						case STATISTICS_UNIT_DATE :
						case STATISTICS_UNIT_WEEK :
						case STATISTICS_UNIT_MONTH :
							try {
								return format.parse((String)rec[0]);
							} catch (ParseException e) {
								e.printStackTrace();
								return rec[0];
							}
						case STATISTICS_UNIT_DAY :
							Calendar c = Calendar.getInstance();
							if (rec[0].equals("1")) {
								c.set(Calendar.DAY_OF_WEEK,Calendar.SUNDAY);
							} else if (rec[0].equals("2")) {
								c.set(Calendar.DAY_OF_WEEK,Calendar.MONDAY);
							} else if (rec[0].equals("3")) {
								c.set(Calendar.DAY_OF_WEEK,Calendar.TUESDAY);
							} else if (rec[0].equals("4")) {
								c.set(Calendar.DAY_OF_WEEK,Calendar.WEDNESDAY);
							} else if (rec[0].equals("5")) {
								c.set(Calendar.DAY_OF_WEEK,Calendar.THURSDAY);
							} else if (rec[0].equals("6")) {
								c.set(Calendar.DAY_OF_WEEK,Calendar.FRIDAY);
							} else if (rec[0].equals("7")) {
								c.set(Calendar.DAY_OF_WEEK,Calendar.SATURDAY);
							} else {
								return rec[0];
							}
							return c.getTime();
						case STATISTICS_UNIT_TYPE :
						default:
							return rec[0];
					}
				case 1:
					return rec[1];
				case 2:
					return rec[2];
				case 3:
					return rec[3];
				case 4:
					return rec[4];
				case 5:
					return rec[5];
				//case 6:
				//	return rec[6];
				default:
					return "";
			}

		}

		public String getColumnName(int col) {

			if (col == 0) {
				switch (unit) {
					case STATISTICS_UNIT_HOUR:
						return "";
					case STATISTICS_UNIT_DAY :
						return "j";
					case STATISTICS_UNIT_DATE :
						return "t";
					case STATISTICS_UNIT_WEEK :
						return "T";
					case STATISTICS_UNIT_MONTH :
						return "";
					case STATISTICS_UNIT_TYPE :
						return "^Cv";
					default:
						return "WvP";
				}
			}
			if (col == 1) return "Ϗ";
			if (col == 2) return "ŏ";
			if (col == 3) return "ő又";
			if (col == 4) return "ԕ΍";
			if (col == 5) return "";
			//if (col == 6) return "";
			return super.getColumnName(col);

		}

	}

}

