/*
 * $Id: TransactionRecord.java,v 1.5 2004/06/30 01:49:21 etoh Exp $
 */
package jawprof.gui;

import java.util.*;

/**
 *
 * @see MonitorFactory
 * @version 1.0
 */
public class TransactionRecord {

	/** gUNV ID */
	private String id;

	/** gUNV */
	private String type;

	/** gUNVJn */
	private Date start;

	/** gUNVI */
	private Date stop;

	/** gUNVbv */
	private List laps;

	protected TransactionRecord(String id,Date start,Date stop,String type) {

		this.id = id;
		this.start = start;
		this.stop = stop;
		this.type = type;
		this.laps = new ArrayList();

	}

	public void addLap(Lap lap) {

		laps.add(lap);

	}

	/**
	 * gUNV ID Ԃ܂.
	 *
	 * @return gUNV ID
	 */
	public String getId() {

		return id;

	}

	/**
	 * gUNVʂԂ܂.
	 *
	 * @return gUNV
	 */
	public String getType() {

		return type;

	}

	/**
	 * JnԂ܂.
	 *
	 * @return Jn
	 */
	public Date getStart() {

		return start;

	}

	/**
	 * IԂ܂.
	 *
	 * @return I
	 */
	public Date getStop() {

		return stop;

	}

	/**
	 * ԂԂ܂. ԂƂ, IƊJn̍~bPʂŕԂ܂.
	 *
	 * @return ̃gUNV̏
	 */
	public long getProcessingTime() {

		return stop.getTime() - start.getTime();

	}

	/**
	 * bvԂ܂.
	 *
	 * @return bv񂪊i[ꂽ Map
	 */
	public List getAllLaps() {

		return laps;

	}

	/**
	 * bv^C̋L^ł. bv^C̋L^, L[ƎԂȂ܂.
	 */
	public static class Lap {

		private String key;
		private Date time;

		/**
		 * L[ƑΉ鎞Zbg܂.
		 */
		public Lap(String key,Date time) {

			this.key = key;
			this.time = time;

		}

		/**
		 * ̃bṽL[Ԃ܂.
		 */
		public String getKey() {

			return key;

		}

		/**
		 * ̃bv̎Ԃ܂. ԂꂽIuWFNgύXẴbvɂ͉e܂
		 * .
		 */
		public Date getTime() {

			return (Date)time.clone();

		}

	}

}

