/*
 * $Id: TransactionTableModule.java,v 1.42 2004/07/18 15:36:42 etoh Exp $
 */
package jawprof.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.sql.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

/**
 * gUNV̈ꗗ\\plł.
 *
 * @version 1.0
 */
public class TransactionTableModule extends JawprofGuiModule {

	/** GUI R|[lg. */
	private JPanel panel;
	private TransactionTablePartPanel transactionTablePart;
	private TransactionDetailPartPanel transactionDetailPart;

	private java.util.List transactions;

	//* plɈړ\
	private JTable transactionTable;
	private JTable lapTable;

	/** {^. */
	private JButton btSearch;

	/**
	 * ReLXg񂩂f[^x[Xڑl, ڑ܂.
	 * <p>f[^x[XR[_Ƃ̓RlNVL܂.</p>
	 *
	 * @param context ݒ
	 */
	public TransactionTableModule(JawprofGui gui) {

		super(gui);

		//* GUI \z
		panel = new JPanel(new BorderLayout());

	 	//* w蕔.
		JPanel controlPart = new ControlPartPanel();
		panel.add(controlPart,BorderLayout.NORTH);

		//* gUNV\. ꗗƏڍוȂ.
		transactionTablePart = new TransactionTablePartPanel();
		transactionDetailPart = new TransactionDetailPartPanel();

		//* JSplitPane ɃgUNVꗗ\Əڍו\ǉ
		JSplitPane transactionPart = new JSplitPane(
				JSplitPane.VERTICAL_SPLIT,transactionTablePart,transactionDetailPart);
		//transactionPart.setDividerLocation(0.5);
		panel.add(transactionPart,BorderLayout.CENTER);

		//* irQ[V
		JPanel naviPanel = new JPanel(new FlowLayout(FlowLayout.TRAILING));

		//* obN{^
		JButton back = new JActionButton(new
			AbstractAction("back",createIcon("toolbarButtonGraphics/navigation/Back24.gif")) {

				/**
				 * ꌏÕgUNVֈړ. ꗗe[uł͑ÕR[hIR[h
				 * Ƃ, ÕR[hɕ\ĂgUNV̏ڍׂ\.
				 */
				public void actionPerformed(ActionEvent event) {

					int ix = transactionTable.getSelectedRow() - 1;
					if (ix >= 0) transactionTable.setRowSelectionInterval(ix,ix);

				}

			},true);
		naviPanel.add(back);

		//* tH[h{^
		JButton forward = new JActionButton(new
			AbstractAction("forward",createIcon("toolbarButtonGraphics/navigation/Forward24.gif")) {

				/**
				 * ꌏ̃gUNVֈړ. ꗗe[uł͎̃R[hIR[h
				 * Ƃ, ̃R[hɕ\ĂgUNV̏ڍׂ\.
				 */
				public void actionPerformed(ActionEvent event) {

					int ix = transactionTable.getSelectedRow() + 1;
					if (ix < transactionTable.getRowCount())
							transactionTable.setRowSelectionInterval(ix,ix);

				}
			},true);
		naviPanel.add(forward);
		panel.add(naviPanel,BorderLayout.SOUTH);

	}

	public String getTitle() {

		return "gUNVꗗ";

	}

	public JComponent getComponent() {

		return panel;

	}

	/**
	 * ̃\bh͒ʒmANVɏ]Ĉȉ̂悤ȏs܂.
	 * <dl>
	 *    <dt>ڑ</dt>
	 *    <dd>f[^x[Xڑ, {^ANeBuɂ܂.</dd>
	 *    <dt>ؒf</dt>
	 *    <dd>f[^x[Xؒf͌{^ANeBuɕύX܂.</dd>
	 *    <dt>ŐV̏</dt>
	 *    <dd>f[^x[XɐڑĂ, Čs܂.</dd>
	 *    <dt>GNX|[g</dt>
	 *    <dd>ꗗɕ\ĂgUNV̏GNX|[g܂.</dd>
	 * </dl>
	 *
	 * @param actionType ANV̎
	 */
	protected void notifyAction(String actionType) {

		//* ڑ̏
		if (actionType.equals(JawprofGui.ACTION_CONNECT)) {

			if (btSearch != null) btSearch.getAction().setEnabled(true);

		//* ؒf̏
		} else if (actionType.equals(JawprofGui.ACTION_DISCONNECT)) {

			if (btSearch != null) {
				
				btSearch.getAction().setEnabled(false);
				transactionTablePart.init();
				transactionDetailPart.init();

			}

		//* XV̏
		} else if (actionType.equals(JawprofGui.ACTION_REFRESH)) {

			btSearch.doClick();
			if (getConnection() == null)
					if (btSearch != null) btSearch.getAction().setEnabled(false);

		//* GNX|[g
		} else if (actionType.equals(JawprofGui.ACTION_EXPORT)) {

			if (isActive()) {

				export();

			}

		}

	}

	/**
	 * s.
	 *
	 * @param t0
	 * @param t1
	 */
	private TableModel refresh(java.sql.Timestamp t0,java.sql.Timestamp t1) {

		Connection connection = null;
		PreparedStatement query = null;
		transactions = new ArrayList();
		try {

			//* ڑ
			connection = getConnection();
			if (connection == null)
					return new TransactionTableModel(transactions);

			//* ҂Ԃ̃J[\\
			panel.getParent().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

			connection.setAutoCommit(true);
			connection.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);

			//* gUNVe[u֒ǉ
			SQLGenerator sqlGenerator = new SQLGenerator(connection);
			if (t0 == null && t1 == null) {

				query = connection.prepareStatement(
						"SELECT " +
						"	ID," +
						"	START_TIME," +
						"	START_TIME_MILLIS," +
						"	STOP_TIME," +
						"	STOP_TIME_MILLIS," +
						"	TYPE " +
						"FROM TX " +
						"ORDER BY START_TIME,START_TIME_MILLIS");

			} else {

				query = connection.prepareStatement(
						"SELECT " +
						"	ID," +
						"	START_TIME," +
						"	START_TIME_MILLIS," +
						"	STOP_TIME," +
						"	STOP_TIME_MILLIS," +
						"	TYPE " +
						"FROM TX " +
						"WHERE " +
							sqlGenerator.getToChar("START_TIME","YYYYMMDD") +
						"		BETWEEN " +
									sqlGenerator.getToChar("?","YYYYMMDD") +
						"			AND " +
									sqlGenerator.getToChar("?","YYYYMMDD") +
						" ORDER BY START_TIME,START_TIME_MILLIS");
				query.setTimestamp(1,t0);
				query.setTimestamp(2,t1);

			}

			ResultSet result = query.executeQuery();	
			while (result.next()) {

				TransactionRecord tx;

				String id = result.getString("ID");
				Timestamp startTime = new Timestamp(result.getTimestamp("START_TIME").getTime() +
						result.getLong("START_TIME_MILLIS"));
				Timestamp stopTime = new Timestamp(result.getTimestamp("STOP_TIME").getTime() +
						result.getLong("STOP_TIME_MILLIS"));
				String type = result.getString("TYPE");

				tx = new TransactionRecord(id,startTime,stopTime,type);
				transactions.add(tx);

			}

		} catch (SQLException e) {

			System.err.println(e.getMessage());

		} finally {

			try {

				if (query != null) query.close();

			} catch (SQLException e) {

				System.err.println(e.getMessage());

			}

		}

		//* ҂Ԃ̃J[\\
		panel.getParent().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

		return new TransactionTableModel(transactions);

	}

	/**
	 * gUNVL^̃bv^C̏ڍ׏ݒ肷.
	 */
	private void searchTransactionDetail(TransactionRecord tx) {

		//* łɎ擾Ă珈Ȃ
		if (tx.getAllLaps() != null && tx.getAllLaps().size() > 0) return;

		Connection connection = null;
		Statement query = null;
		try {

			//* ڑ
			connection = getConnection();
			if (connection == null) return;

			//* ҂Ԃ̃J[\\
			panel.getParent().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

			connection.setAutoCommit(true);
			connection.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);

			//* 
			query = connection.createStatement();	
			ResultSet result = query.executeQuery(
					"SELECT ID,TIME,TIME_MILLIS " +
					"FROM LAP " +
					"WHERE TX_ID = '" + tx.getId() + "' " +
					"ORDER BY TIME,TIME_MILLIS,ID");
			while (result.next()) {

				String id = result.getString("ID");
				Timestamp time = new Timestamp(result.getTimestamp("TIME").getTime() +
						result.getLong("TIME_MILLIS"));

				tx.addLap(new TransactionRecord.Lap(id,time));

			}

		} catch (SQLException e) {

			System.err.println(e.getMessage());

		} finally {

			try {

				if (query != null) query.close();

			} catch (SQLException e) {

				System.err.println(e.getMessage());

			}

		}

		//* ҂Ԃ̃J[\\
		panel.getParent().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

	}

	/**
	 * GNX|[g@\̎.
	 */
	private void export() {

		ExportPanel panel = new ExportPanel();
		Object[] message = { panel };

		//* _CAO\(OK  CANCEL Ił܂.)
		//* CANCEL ̎ JOptionPane.CANCEL_OPTION Ԃ. ̂Ƃ܂߂ OK ȊO̎͏
		//* sȂ.
		int result = JOptionPane.showConfirmDialog(getComponent(),message,"GNX|[g",
						JOptionPane.OK_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);
		switch (result) {

			//* 
			case JOptionPane.OK_OPTION:
				break; 

			default: 
				return;

		}

		//* GNX|[gs
		System.out.println("OK");

		//* t@C쐬
		File file = null;
		String name = panel.getExportFilePath();
		if (name != null) file = new File(name);
		if (file == null) return;

		PrintWriter out = null;
		try {

			out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));

			//* `ɏ]ďo
			switch (panel.getExportType()) {

				case ExportPanel.TYPE_CSV:
					for (Iterator i = transactions.iterator(); i.hasNext();) {

						TransactionRecord each = (TransactionRecord)i.next();
						out.print(each.getId() + ",");
						out.print(TIMESTAMP_FORMAT.format(each.getStart()) + ",");
						out.print(TIMESTAMP_FORMAT.format(each.getStop()) + ",");
						out.print(each.getType() + ",");
						out.println(each.getProcessingTime());

					}
					break;

				case ExportPanel.TYPE_JMX:
					for (Iterator i = transactions.iterator(); i.hasNext();) {
					}
					break;

				default:
					break;

			}
			out.flush();

		} catch (FileNotFoundException e) {
		} catch (IOException e) {
		} finally {

			if (out != null) out.close();

		}

	}

	/**
	 * w蕔.
	 */
	private class ControlPartPanel extends JPanel implements ItemListener {


		private JCheckBox ckTerm;
		private JFormattedTextField tfDate0;
		private JFormattedTextField tfDate1;

		/**
		 *
		 */
		private ControlPartPanel() {

			setLayout(new FlowLayout(FlowLayout.LEADING));
			ckTerm = new JCheckBox("",true);
			ckTerm.addItemListener(this);
			add(ckTerm);

			//* n
			tfDate0 = new JFormattedTextField(DATE_FORMAT);
			tfDate0.setValue(new java.util.Date());
			add(tfDate0);

			//* I
			tfDate1 = new JFormattedTextField(DATE_FORMAT);
			tfDate1.setValue(new java.util.Date());
			add(tfDate1);

			//* {^
			btSearch = new JButton(new SearchAction(
						"",createIcon("toolbarButtonGraphics/general/Refresh16.gif")));
			btSearch.getAction().setEnabled(false);
			add(btSearch);

		}

		/**
		 * gUNV̌sANVł.
		 */
		private class SearchAction extends AbstractAction {

			public SearchAction(String name,Icon icon) {

				super(name,icon);
				setEnabled(true);

			}

			/**
			 * s܂.
			 */
			public void actionPerformed(ActionEvent event) {

				TableModel model;

				//* ܂
				if (ckTerm.isSelected()) {

					java.util.Date d0 = (java.util.Date)tfDate0.getValue();
					java.util.Date d1 = (java.util.Date)tfDate1.getValue();
					model = refresh(new Timestamp(d0.getTime()),new Timestamp(d1.getTime()));

				} else {

					model = refresh(null,null);

				}

				transactionTable.setModel(model);

				//* ̕\ύX
				TableColumn column;
				column = transactionTable.getColumn("Jn");
				if (column != null) column.setCellRenderer(dateRenderer);
				column = transactionTable.getColumn("I");
				if (column != null) column.setCellRenderer(dateRenderer);
				column = transactionTable.getColumn("[msec]");
				if (column != null) column.setCellRenderer(intRenderer);

				//* 擪sI
				if (transactionTable.getRowCount() > 0)
						transactionTable.setRowSelectionInterval(0,0);

			}

		}

		public void itemStateChanged(ItemEvent event) {

			if (event.getStateChange() == ItemEvent.SELECTED) {

				tfDate0.setEnabled(true);
				tfDate0.setEditable(true);
				tfDate1.setEnabled(true);
				tfDate1.setEditable(true);

			} else if (event.getStateChange() == ItemEvent.DESELECTED) {

				tfDate0.setEnabled(false);
				tfDate0.setEditable(false);
				tfDate1.setEnabled(false);
				tfDate1.setEditable(false);

			}

		}

	}

	/**
	 * gUNVꗗ\.
	 */
	private class TransactionTablePartPanel extends JPanel {

		/**
		 *
		 */
		private TransactionTablePartPanel() {

			setLayout(new BorderLayout());

			//* JTable 쐬
			transactionTable = new JTable() {
				public void valueChanged(ListSelectionEvent event) {

					super.valueChanged(event);
					if (transactionTable != null) {

						int ix = transactionTable.getSelectedRow();
						if (ix == -1) {
							transactionDetailPart.show(null);
							return;
						}

						TransactionRecord tx = (TransactionRecord)transactions.get(ix);

						//* bv^C擾
						searchTransactionDetail(tx);

						//* JnƏI\
						transactionDetailPart.show(tx);

						//* bv^C\
						//lapTable.setModel(new LapTableModel(tx.getAllLaps()));

					}

				}
			};
			transactionTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

			//* Pane ɒǉ
			add(new JScrollPane(transactionTable),BorderLayout.CENTER);
			init();

		}

		private void init() {

			transactionTable.setModel(new TransactionTableModel(new ArrayList(0)));

		}

	}

	/**
	 * gUNVڍ׏\.
	 */
	private class TransactionDetailPartPanel extends JPanel {

		private JFormattedTextField tfStart;
		private JFormattedTextField tfEnd;

		private TransactionDetailPartPanel() {

			setLayout(new BorderLayout());

			//* JnƏI
			JPanel startEndPanel = new JPanel(new FlowLayout(FlowLayout.LEADING));
			startEndPanel.add(new JLabel("X^[g"));
			tfStart = new JFormattedTextField(TIMESTAMP_FORMAT);
			tfStart.setEditable(false);
			tfStart.setColumns(16);
			startEndPanel.add(tfStart);
			startEndPanel.add(new JLabel("I"));
			tfEnd = new JFormattedTextField(TIMESTAMP_FORMAT);
			tfEnd.setEditable(false);
			tfEnd.setColumns(16);
			startEndPanel.add(tfEnd);

			//* bv^C
			JPanel lapPanel = new JPanel(new BorderLayout());
			JLabel lbLap = new JLabel("bv");
			lbLap.setVerticalAlignment(JLabel.TOP);
			lapPanel.add(lbLap,BorderLayout.WEST);

			//* JTable 쐬(IsƂ)
			lapTable = new JTable();
			lapTable.setRowSelectionAllowed(false);
			lapTable.setPreferredScrollableViewportSize(new Dimension(3,10));
			//lapTable.setModel(new LapTableModel(new ArrayList()));
			lapPanel.add(new JScrollPane(lapTable),BorderLayout.CENTER);

			//* ڍו\
			JPanel detailPanel = new JPanel(new BorderLayout());
			detailPanel.add(startEndPanel,BorderLayout.NORTH);
			detailPanel.add(lapPanel,BorderLayout.CENTER);
			add(detailPanel,BorderLayout.CENTER);

			init();

		}

		private void init() {

			lapTable.setModel(new LapTableModel(new ArrayList()));

		}

		/**
		 * ŗ^ꂽgUNV̏ڍ׏\܂.
		 *
		 * @param tx \gUNV
		 */
		private void show(TransactionRecord tx) {

			if (tx == null) {

				tfStart.setValue(null);
				tfEnd.setValue(null);
				lapTable.setModel(new LapTableModel(new ArrayList()));

			} else {

				tfStart.setValue(tx.getStart());
				tfEnd.setValue(tx.getStop());
				lapTable.setModel(new LapTableModel(tx.getAllLaps()));

			}

			//* ̕\ύX
			TableColumn column;
			column = lapTable.getColumn("");
			column.setCellRenderer(dateRenderer);
			column = lapTable.getColumn("Ԋu");
			column.setCellRenderer(intRenderer);

		}

	}

	/**
	 * gUNVꗗ\pe[uf.
	 */
	private static class TransactionTableModel extends AbstractTableModel {

		private java.util.List list;

		private TransactionTableModel(java.util.List list) {

			this.list = list;

		}

		public int getColumnCount() {

			return 5;

		}

		public int getRowCount() {

			return list.size();

		}

		public Object getValueAt(int row,int col) {

			TransactionRecord tx = (TransactionRecord)list.get(row);
			switch (col) {
				case 0:
					return tx.getId();
				case 1:
					return tx.getStart();
				case 2:
					return tx.getStop();
				case 3:
					return tx.getType();
				case 4:
					return new Long(tx.getProcessingTime());
				default:
					return "";
			}

		}

		public String getColumnName(int col) {

			if (col == 0) return "ID";
			if (col == 1) return "Jn";
			if (col == 2) return "I";
			if (col == 3) return "TX ^Cv";
			if (col == 4) return "[msec]";
			return super.getColumnName(col);

		}

	}

	/**
	 * bv^C\pe[uf.
	 */
	private static class LapTableModel extends AbstractTableModel {

		private java.util.List laps;

		private LapTableModel(java.util.List laps) {

			this.laps = laps;

		}

		public int getColumnCount() {

			return 3;

		}

		public int getRowCount() {

			if (laps == null) return 0;
			return laps.size();

		}

		public Object getValueAt(int row,int col) {

			TransactionRecord.Lap lap = (TransactionRecord.Lap)laps.get(row);
			switch (col) {
				case 0:
					return lap.getKey();
				case 1:
					return lap.getTime();
				case 2:
					if (row == 0) return null;
					TransactionRecord.Lap previous = (TransactionRecord.Lap)laps.get(row - 1);
					return new Long(lap.getTime().getTime() - previous.getTime().getTime());
				default:
					return null;
			}

		}

		public String getColumnName(int col) {

			if (col == 0) return "bv";
			if (col == 1) return "";
			if (col == 2) return "Ԋu";
			return super.getColumnName(col);

		}

	}

}

