/*
 * $Id: DatabaseRecorder.java,v 1.13 2004/07/04 03:26:41 etoh Exp $
 */
package jawprof.recorder;

import java.sql.*;
import java.util.*;
import org.apache.commons.dbcp.*;
import org.apache.commons.pool.impl.*;
import org.apache.commons.logging.*;
import jawprof.*;

/**
 * f[^x[XɍXV܂.
 *
 * @version 1.0
 * @see Recorder
 */
public class DatabaseRecorder extends PersistentRecorder {

	private static final String RESOURCE_NAME = "jawprof";
	private final Log log = LogFactory.getLog(DatabaseRecorder.class);

	/** gUNVe[uւ̒ǉp SQL. */
	public static final String SQL_INSERT_TX =
			"INSERT INTO TX (" +
			"    ID,START_TIME,START_TIME_MILLIS,STOP_TIME,STOP_TIME_MILLIS,TYPE" +
			") VALUES (" +
			"	?,?,?,?,?,?" +
			")";

	/** bve[uւ̒ǉp SQL. */
	public static final String SQL_INSERT_TX_LAP =
			"INSERT INTO LAP (" +
			"	TX_ID,ID,TIME,TIME_MILLIS" +
			") VALUES (" +
			"	?,?,?,?" +
			")";

	/** gUNVO[ve[uւ̒ǉp SQL. */
	public static final String SQL_INSERT_TX_GROUP =
			"INSERT INTO TX_GROUP (ID) VALUES (?)";

	/** gUNVO[v}bve[uւ̒ǉp SQL. */
	public static final String SQL_INSERT_TX_GROUP_MAP =
			"INSERT INTO TX_GROUP_MAP (GROUP_ID,TX_TYPE) VALUES (?,?)";

	/** f[^\[Xv[ */
	private PoolingDataSource dataSource;

	/**
	 * ^ꂽݒɊÂ DatabaseRecorder IuWFNg쐬܂.
	 *
	 * @param context ݒ
	 */
	public DatabaseRecorder(JawprofContext context) throws ClassNotFoundException {

		//* f[^x[X̐ڑ擾
		String driver = context.getString("jawprof.recorder.databaserecorder.driver");
		String url = context.getString("jawprof.recorder.databaserecorder.url");
		String user = context.getString("jawprof.recorder.databaserecorder.user");
		String password = context.getString("jawprof.recorder.databaserecorder.password");

		//* DBCP v[O
		Class.forName(driver);
		StackObjectPool pool = new StackObjectPool();
		DriverManagerConnectionFactory
				cf = new DriverManagerConnectionFactory(url,user,password);
		PoolableConnectionFactory
				pcf = new PoolableConnectionFactory(cf,pool,null,null,false,true);
		dataSource = new PoolingDataSource(pool);

	}

	/**
	 * f[^x[Xփvt@COʂۑ܂.
	 *
	 * @param m Monitor IuWFNg
	 */
	public void persist(Monitor m) {

		Connection connection = null;
		try {

			//* ڑ
			connection = dataSource.getConnection();
			connection.setAutoCommit(false);

			//* gUNVe[u֒ǉ
			PreparedStatement insertTx = connection.prepareStatement(SQL_INSERT_TX);	
			insertTx.setString(1,m.getTransactionId());
			insertTx.setTimestamp(2,new Timestamp(m.getStartTime() / 1000 * 1000));
			insertTx.setLong(3,m.getStartTime() % 1000);
			insertTx.setTimestamp(4,new Timestamp(m.getStopTime() / 1000 * 1000));
			insertTx.setLong(5,m.getStopTime() % 1000);
			if (m.getType() == null) {
				insertTx.setNull(6,Types.VARCHAR);
			} else {
				insertTx.setString(6,m.getType().toString());
			}
			insertTx.addBatch();

			//* Lap times
			PreparedStatement insertLap = connection.prepareStatement(SQL_INSERT_TX_LAP);	
			Map lapTimes = m.getLapTimes();
			for (Iterator i = lapTimes.keySet().iterator(); i.hasNext();) {

				String lapId = (String)i.next();
				long lapTime = ((Long)lapTimes.get(lapId)).longValue();
				insertLap.setString(1,m.getTransactionId());
				insertLap.setString(2,lapId);
				insertLap.setTimestamp(3,new Timestamp(lapTime / 1000 * 1000));
				insertLap.setLong(4,lapTime % 1000);
				insertLap.addBatch();

			}

			//* XV
			insertTx.executeBatch();
			insertLap.executeBatch();
			connection.commit();

		} catch (SQLException e) {

			log.error(e.getMessage());
			try {

				connection.rollback();

			} catch (SQLException ee) {

				log.error(ee.getMessage());

			}

		} finally {

			try {

				if (connection != null) connection.close();

			} catch (SQLException e) {

				log.error(e.getMessage());

			}

		}

	}

	/**
	 * ŗ^ꂽgUNVO[vɏgUNVʂ̏ۑ
	 * ܂.
	 *
	 * @param group gUNVO[v
	 * @param types gUNVʂ̃RNV
	 */
	public void saveGroupMap(String group,Collection types) {

		Connection connection = null;
		try {

			//* ڑ
			connection = dataSource.getConnection();
			connection.setAutoCommit(false);

			//* gUNVO[ve[u֒ǉ
			PreparedStatement insertGroup = connection.prepareStatement(SQL_INSERT_TX_GROUP);	
			insertGroup.setString(1,group);
			insertGroup.addBatch();

			//* gUNVO[v}bve[u֒ǉ
			PreparedStatement
					insertGroupMap = connection.prepareStatement(SQL_INSERT_TX_GROUP_MAP);	
			for (Iterator i = types.iterator(); i.hasNext();) {

				String type = (String)i.next();
				insertGroupMap.setString(1,group);
				insertGroupMap.setString(2,type);
				insertGroupMap.addBatch();

			}

			//* XV
			insertGroup.executeBatch();
			insertGroupMap.executeBatch();
			connection.commit();

		} catch (SQLException e) {

			log.error(e.getMessage());
			try {

				if (connection != null) connection.rollback();

			} catch (SQLException ee) {

				log.error(ee.getMessage());

			}

		} finally {

			try {

				if (connection != null) connection.close();

			} catch (SQLException e) {

				log.error(e.getMessage());

			}

		}

	}

}

