/*
 * $Id: FileRecorder.java,v 1.1 2004/03/22 06:01:06 etoh Exp $
 */
package jawprof.recorder;

import java.io.*;
import java.text.*;
import java.util.*;
import jawprof.*;

/**
 * vt@CǑʂ CSV t@C֏o͂܂.
 *
 * @version 1.0
 * @see Recorder
 */
public class FileRecorder extends FormatRecorder {

	private PrintWriter outStart,outStop,outLap;
	private final DateFormat format = new SimpleDateFormat("yyyy/MM/dd:HH:mm:ss:SSS");

	/**
	 *
	 * @param path t@C
	 */
	public FileRecorder(JawprofContext context) throws IOException {

		super(context);

		String pathStart = context.getString("jawprof.recorder.filerecorder.file.start");
		String pathStop = context.getString("jawprof.recorder.filerecorder.file.stop");
		String pathLap = context.getString("jawprof.recorder.filerecorder.file.lap");

		outStart = new PrintWriter(new BufferedWriter(new FileWriter(pathStart,true)),true);
		outStop = new PrintWriter(new BufferedWriter(new FileWriter(pathStop,true)),true);
		outLap = new PrintWriter(new BufferedWriter(new FileWriter(pathLap,true)),true);

	}

	/**
	 * ŗ^ꂽgUNVO[vɏgUNVʂ̏ۑ
	 * ܂. ݂͎܂.
	 *
	 * @param group gUNVO[v
	 * @param types gUNVʂ̃RNV
	 */
	public void saveGroupMap(String group,Collection types) {

		//for (Iterator i = types.iterator(); i.hasNext();) out.println(group + ":" + i.next());

	}

	/**
	 * tH[}bgꂽbZ[Wo͂܂.
	 *
	 * @param message tH[}bgꂽ
	 */
	protected void printStartRecord(String message) {

		outStart.println(message);

	}

	/**
	 * tH[}bgꂽbZ[Wo͂܂.
	 *
	 * @param message tH[}bgꂽ
	 */
	protected void printStopRecord(String message) {

		outStop.println(message);

	}

	/**
	 * tH[}bgꂽbZ[Wo͂܂.
	 *
	 * @param message tH[}bgꂽ
	 */
	protected void printLapRecord(String message) {

		outLap.println(message);

	}

}

