/*
 * $Id: FormatRecorder.java,v 1.1 2004/03/22 06:01:06 etoh Exp $
 */
package jawprof.recorder;

//import java.io.*;
import java.text.*;
import java.util.*;
import jawprof.*;

/**
 * vt@CǑʂtH[}bgďo͂܂.
 *
 * @version 1.0
 * @see Recorder
 * @see java.text.MessageFormat
 */
public abstract class FormatRecorder extends PersistentRecorder {

	/** tH[}b^ */
	private MessageFormat startFormat;
	private MessageFormat stopFormat;
	private MessageFormat lapFormat;

	private Object[] startMessageArgs;
	private Object[] stopMessageArgs;
	private Object[] lapMessageArgs;

	/**
	 *
	 * @param startPattern bZ[WtH[}bĝ߂̃p^[
	 * @param stopPattern bZ[WtH[}bĝ߂̃p^[
	 * @param lapPattern bZ[WtH[}bĝ߂̃p^[
	 */
	public FormatRecorder(JawprofContext context) {

		startFormat = new MessageFormat(
				context.getString("jawprof.recorder.formatrecorder.format.start"));
		stopFormat = new MessageFormat(
				context.getString("jawprof.recorder.formatrecorder.format.stop"));
		lapFormat = new MessageFormat(
				context.getString("jawprof.recorder.formatrecorder.format.lap"));

		startMessageArgs = new Object[4];
		stopMessageArgs = new Object[4];
		lapMessageArgs = new Object[5];

	}

	/**
	 *
	 */
	public final void persist(Monitor m) {

		//* gUNV ID
		startMessageArgs[0] = m.getTransactionId();
		stopMessageArgs[0] = m.getTransactionId();
		lapMessageArgs[0] = m.getTransactionId();

		//* Monitor ID
		startMessageArgs[1] = m.getId();
		stopMessageArgs[1] = m.getId();
		lapMessageArgs[1] = m.getId();

		//* gUNV
		startMessageArgs[2] = m.getType();
		stopMessageArgs[2] = m.getType();
		lapMessageArgs[2] = m.getType();

		//* Jn/I
		startMessageArgs[3] = new Date(m.getStartTime());
		stopMessageArgs[3] = new Date(m.getStopTime());	

		//* Jn/IL^o
		printStartRecord(startFormat.format(startMessageArgs));
		printStopRecord(stopFormat.format(stopMessageArgs));

		//* bv^CL^o
		Map lapTimes = m.getLapTimes();
		for (Iterator i = lapTimes.keySet().iterator(); i.hasNext();) {

			Object lapId = i.next();
			Object lapTime = lapTimes.get(lapId);
			lapMessageArgs[4] = lapId;
			lapMessageArgs[3] = new Date(((Long)lapTimes.get(lapId)).longValue());

			printLapRecord(lapFormat.format(lapMessageArgs));

		}

	}

	/**
	 * ŗ^ꂽgUNVO[vɏgUNVʂ̏ۑ
	 * ܂. ݂͎܂.
	 *
	 * @param group gUNVO[v
	 * @param types gUNVʂ̃RNV
	 */
	public void saveGroupMap(String group,Collection types) {}

	/**
	 * tH[}bgꂽbZ[Wo͂܂.
	 *
	 * @param message tH[}bgꂽ
	 */
	protected abstract void printStartRecord(String message);

	/**
	 * tH[}bgꂽbZ[Wo͂܂.
	 *
	 * @param message tH[}bgꂽ
	 */
	protected abstract void printStopRecord(String message);

	/**
	 * tH[}bgꂽbZ[Wo͂܂.
	 *
	 * @param message tH[}bgꂽ
	 */
	protected abstract void printLapRecord(String message);

}

