/*
 * $Id: PersistentRecorder.java,v 1.4 2004/07/04 03:26:41 etoh Exp $
 */
package jawprof.recorder;

import java.util.*;
import jawprof.*;

/**
 * isR[_[̌pNXł.
 * <p>
 * gƂɂ, persist() \bh saveGroupMap() ̃NXpN
 * X܂. ̎, ΂ MonitorFactory#poolMonitor(Monitor) Ăł͂܂.
 * v[Ɋւ鏈͏ʂ̃IuWFNg̐ӔCł.
 * </p>
 *
 * @version 1.0
 * @see Recorder
 * @see MultiRecorder
 * @see MonitorFactory
 */
public abstract class PersistentRecorder extends AbstractRecorder {

	/**
	 * i\bh persist(Monitor) s, MonitorFactory Ɏgpς Monitor IuW
	 * FNgv[邱Ƃv܂.</br>
	 * ̃\bh, MultiRecorder gpĂꍇɂ͌Ă΂邱Ƃ͂܂.
	 * MonitorFactory Ɏgpς Monitor IuWFNgv[邱Ƃv̂ MultiRecorder
	 * ̐ӔCƂȂ܂.
	 *
	 * @param m i Monitor IuWFNg
	 *
	 *  @see jawprof.Recorder#save(jawprof.Monitor)
	 */
	public final void save(Monitor m) {

		persist(m);
		release(m);

	}

	/**
	 * ŗ^ꂽgUNVO[vɏgUNVʂ̏ۑ
	 * ܂. ݂͎܂.
	 *
	 * @param group gUNVO[v
	 * @param types gUNVʂ̃RNV
	 */
	public abstract void saveGroupMap(String group,Collection types);

	/**
	 * vt@CǑʂi܂.
	 *
	 * @param m j^[
	 */
	public abstract void persist(Monitor m);

}

