/*
 * $Id: TimerTaskRecorder.java,v 1.8 2004/07/04 11:52:06 etoh Exp $
 */
package jawprof.recorder;

import java.util.*;
import jawprof.*;

/**
 * ^C}[ŋN郌R[_[ł.  Recorder ͑ Recorder ̃bp[Ƃē삵܂.
 * IɃbvĂ郌R[_[̃\bhĂяo܂.
 *
 * @version 1.0
 */
public class TimerTaskRecorder extends AbstractRecorder {

	private PersistentRecorder recorder;
	private Collection buffer,savings;

	/**
	 * ۂɎgp Recorder Zbg܂.
	 *
	 * @param r ۂɎgp郌R[_[
	 */
	public TimerTaskRecorder(PersistentRecorder r,long interval) {

		recorder = r;
		buffer = new LinkedList();
		savings = new LinkedList();

		//* ^C}[쐬܂
		//Timer timer = new Timer();
		Timer timer = new Timer(true);
		TimerTask task = new TimerTask() {
			/**
			 * obt@, SẴgUNVL^ۑ܂.
			 */
			public final void run() {

				synchronized (TimerTaskRecorder.this) {

					swap();
					for (Iterator i = savings.iterator(); i.hasNext();) {

						Monitor m = (Monitor)i.next();
						recorder.save(m);
						release(m);
						//MonitorFactory.poolMonitor(m);

					}
					savings.clear();

				}

			}
		};
		timer.schedule(task,interval,interval);

		//* Vbg_EtbNɓo^(o^o^ĂI)
		Runtime.getRuntime().addShutdownHook(new Thread(task));

	}

	/**
	 *
	 *  @see jawprof.Recorder#save(jawprof.Monitor)
	 */
	public synchronized void save(Monitor m) {

		hold(m);
		buffer.add(m);

	}

	/**
	 * ŗ^ꂽgUNVO[vɏgUNVʂ̏ۑ
	 * ܂.
	 *
	 * @param group gUNVO[v
	 * @param types gUNVʂ̃RNV
	 */
	public void saveGroupMap(String group,Collection types) {

		recorder.saveGroupMap(group,types);

	}

	/**
	 * obt@ƕۑp̃RNVւ.
	 */
	private void swap() {

		Collection tmp;

		tmp = buffer;
		buffer = savings;
		savings = tmp;

	}

}

