/*
 * Decompiled with CFR 0.152.
 */
package org.hanei.jaxcel.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFChartSheet;
import org.apache.poi.xssf.usermodel.XSSFDialogsheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hanei.jaxcel.exception.JaxcelInputException;
import org.hanei.jaxcel.exception.JaxcelOutputException;
import org.hanei.jaxcel.report.ELManager;
import org.hanei.jaxcel.report.JaxcelContext;
import org.hanei.jaxcel.report.TLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportMaker {
    private static final Logger log = LoggerFactory.getLogger(ReportMaker.class);
    private NPOIFSFileSystem npoifs = null;
    private OPCPackage pkg = null;
    private ELManager elMgr = null;
    private JaxcelContext context = null;

    public Workbook makeReport(InputStream template, Map<String, Object> parameter) {
        log.trace("makeReport start");
        if (template == null) {
            log.error("template is null");
            throw new JaxcelInputException("template is null");
        }
        if (parameter == null) {
            log.debug("parameter is null");
        }
        Workbook book = this.openWorkbook(template);
        this.makeReport(book, parameter);
        log.trace("makeReport end");
        return book;
    }

    public void makeReport(InputStream template, Map<String, Object> parameter, OutputStream output) {
        log.trace("makeReport start");
        Workbook book = this.makeReport(template, parameter);
        this.outputReport(book, output);
        this.close();
        log.trace("makeReport end");
    }

    public void makeReport(InputStream template, Map<String, Object> parameter, File output) {
        FileOutputStream _output;
        log.trace("makeReport start");
        Workbook book = this.makeReport(template, parameter);
        try {
            _output = new FileOutputStream(output);
        }
        catch (Exception e) {
            log.error("output file open error: {}", (Object)e.getMessage(), (Object)e);
            throw new JaxcelOutputException("output file open error");
        }
        this.outputReport(book, _output);
        try {
            _output.close();
        }
        catch (IOException e) {
            log.error("output file close error: {}", (Object)e.getMessage(), (Object)e);
            throw new JaxcelOutputException("output file close error");
        }
        this.close();
        log.trace("makeReport end");
    }

    public Workbook makeReport(File template, Map<String, Object> parameter) {
        log.trace("makeReport start");
        if (template == null) {
            log.error("template file is null");
            throw new JaxcelInputException("template file is null");
        }
        if (!template.exists()) {
            log.error("template file does not exist: {}", (Object)template.getAbsolutePath());
            throw new JaxcelInputException("template file does not exist");
        }
        if (!template.canRead()) {
            log.error("template file can not read: {}", (Object)template.getAbsolutePath());
            throw new JaxcelInputException("template file can not read");
        }
        if (parameter == null) {
            log.debug("parameter is null");
        }
        Workbook book = this.openWorkbook(template);
        this.makeReport(book, parameter);
        log.trace("makeReport end");
        return book;
    }

    public void makeReport(File template, Map<String, Object> parameter, OutputStream output) {
        log.trace("makeReport start");
        Workbook book = this.makeReport(template, parameter);
        this.outputReport(book, output);
        this.close();
        log.trace("makeReport end");
    }

    public void makeReport(File template, Map<String, Object> parameter, File output) {
        FileOutputStream _output;
        log.trace("makeReport start");
        Workbook book = this.makeReport(template, parameter);
        try {
            _output = new FileOutputStream(output);
        }
        catch (Exception e) {
            log.error("output file open error: {}", (Object)e.getMessage(), (Object)e);
            throw new JaxcelOutputException("output file open error");
        }
        this.outputReport(book, _output);
        try {
            _output.close();
        }
        catch (IOException e) {
            log.error("output file close error: {}", (Object)e.getMessage(), (Object)e);
            throw new JaxcelOutputException("output file close error");
        }
        this.close();
        log.trace("makeReport end");
    }

    public void makeReport(Workbook book, Map<String, Object> parameter) {
        log.trace("makeReport start");
        if (book == null) {
            log.error("workbook is null");
            throw new JaxcelInputException("Workbook is null");
        }
        if (!(book instanceof HSSFWorkbook) && !(book instanceof XSSFWorkbook)) {
            log.error("Workbook is unsupport type: {}", (Object)book.getClass().getName());
            throw new JaxcelInputException("Workbook is unsupported type");
        }
        if (parameter == null) {
            log.debug("parameter is null");
        }
        this.context = new JaxcelContext();
        this.elMgr = new ELManager();
        this.elMgr.setParameter(parameter);
        this.context.setElManager(this.elMgr);
        this.makeBook(book);
        log.trace("makeReport end");
    }

    private Workbook openWorkbook(Object template) {
        log.trace("openWorkbook start");
        Workbook book = null;
        try {
            this.npoifs = template instanceof File ? new NPOIFSFileSystem((File)template) : new NPOIFSFileSystem((InputStream)template);
            book = WorkbookFactory.create((NPOIFSFileSystem)this.npoifs);
        }
        catch (IOException | OfficeXmlFileException e1) {
            try {
                this.pkg = template instanceof File ? OPCPackage.open((File)((File)template)) : OPCPackage.open((InputStream)((InputStream)template));
                book = WorkbookFactory.create((OPCPackage)this.pkg);
            }
            catch (IOException | InvalidFormatException e2) {
                log.error("template file open error: {}. {}", (Object)e1.getMessage(), (Object)e2.getMessage());
            }
        }
        if (book == null) {
            throw new JaxcelInputException("template file open error");
        }
        log.trace("openWorkbook end");
        return book;
    }

    private void outputReport(Workbook book, OutputStream output) {
        log.trace("outputReport start");
        try {
            book.write(output);
        }
        catch (IOException e) {
            log.error("workbook output error: {}", (Object)e.getMessage(), (Object)e);
            throw new JaxcelOutputException("workbook output error");
        }
        log.trace("outputReport end");
    }

    public void close() {
        log.trace("close start");
        try {
            if (this.npoifs != null) {
                this.npoifs.close();
                log.debug("template file close.");
                this.npoifs = null;
            }
            if (this.pkg != null) {
                this.pkg.revert();
                log.debug("template file close.");
                this.pkg = null;
            }
        }
        catch (IOException e) {
            log.error("template file close error: {}", (Object)e.getMessage(), (Object)e);
            throw new JaxcelOutputException("template file close error");
        }
        log.trace("close end");
    }

    private void makeBook(Workbook book) {
        log.trace("makeBook start");
        log.debug("sheet count: {}", (Object)book.getNumberOfSheets());
        for (int i = 0; i < book.getNumberOfSheets(); ++i) {
            Sheet sheet = book.getSheetAt(i);
            if (sheet == null) {
                log.warn("sheet[{}] is null. skip", (Object)i);
                continue;
            }
            if (sheet instanceof HSSFSheet && ((HSSFSheet)sheet).getDialog() || sheet instanceof XSSFDialogsheet) {
                log.debug("sheet[{}] is dialog sheet. skip", (Object)i);
                continue;
            }
            if (sheet instanceof XSSFChartSheet) {
                log.debug("sheet[{}] is chart sheet. skip", (Object)i);
                continue;
            }
            log.debug("sheet[{}] name: {}", (Object)i, (Object)sheet.getSheetName());
            this.makeSheet(sheet);
        }
        book.setForceFormulaRecalculation(true);
        log.trace("makeBook end");
    }

    private void makeSheet(Sheet sheet) {
        log.trace("makeSheet start");
        this.context.setCurrentSheet(sheet);
        TLParser tlParser = new TLParser(this.context);
        int lastRowNum = sheet.getLastRowNum();
        log.debug("lastRowNum: {}", (Object)lastRowNum);
        int maxColNum = 0;
        for (int rowIdx = 0; rowIdx <= lastRowNum; ++rowIdx) {
            Row row = sheet.getRow(rowIdx);
            if (row == null) {
                log.debug("row[{}] is null", (Object)(rowIdx + 1));
                continue;
            }
            if (row.getLastCellNum() > maxColNum) {
                maxColNum = row.getLastCellNum();
                log.debug("maxColNum: {}", (Object)maxColNum);
            }
            block4: for (int cellIdx = 0; cellIdx <= maxColNum; ++cellIdx) {
                Cell cell = row.getCell(cellIdx);
                if (cell == null) {
                    log.debug("cell[{}] is null", (Object)new CellReference(rowIdx, cellIdx).formatAsString());
                    continue;
                }
                switch (cell.getCellType()) {
                    case 1: 
                    case 2: {
                        tlParser.parse(cell);
                        if (!tlParser.isReParseCell()) break;
                        --cellIdx;
                        break;
                    }
                    default: {
                        log.debug("cell type is not string or formula");
                        continue block4;
                    }
                }
                if (row.getLastCellNum() <= maxColNum) continue;
                maxColNum = row.getLastCellNum();
                log.debug("maxColNum update: {}", (Object)maxColNum);
            }
            if (lastRowNum >= sheet.getLastRowNum()) continue;
            lastRowNum = sheet.getLastRowNum();
            log.debug("lastRowNum update: {}", (Object)lastRowNum);
        }
        log.trace("transformSheet end");
    }
}

