/**
 * Copyright 2014 Hanei Management Co.,Ltd. 
 * 
 * This file is part of Jaxcel
 * 
 *  Jaxcel is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Jaxcel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.hanei.jaxcel.example;


import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.hanei.jaxcel.report.ReportMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * JavaオブジェクトからのExcel帳票出力サンプルクラス
 * 
 * @version 1.00.00
 * @author Noboru Saito
 */
public class MakeReportWithObject {

	private static final Logger log = LoggerFactory.getLogger(MakeReportWithObject.class);

	/**
	 * ExcelテンプレートファイルにJavaObjectサンプルデータを挿入することでExcel帳票を生成、Excel帳票ファイルを出力する。
	 * 
	 * @param args arg1: Excelテンプレートファイルパス<br>
	 * arg2: パラメータJSONファイルパス<br>
	 * arg3: Excel帳票出力ファイルパス
	 * 
	 * @throws Exception 
	 */
	public static void main(String[] args) throws Exception {
		
		if(args.length != 2) {
			System.out.println("illegal arguments.");
			System.out.println("arg1: template excel file path");
			System.out.println("arg2: output excel file path");
			System.out.println("...relative path from the build root. or absolute path");
			System.exit(0);
		}

		// parameter
		LinkedHashMap<String, Object> parameter = new LinkedHashMap<>();
		
		// object data
		SampleObject objData = new SampleObject();
		objData.setDataA("Hello");
		objData.setDataB(123);
		objData.setDataC(1.23);
		objData.setDataD(true);
		objData.dataApub = "Jaxcel!!";
		objData.dataBpub = 456;
		objData.dataCpub = 4.56;
		objData.dataDpub = false;
		parameter.put("objData", objData);
		
		// object array data
		ArrayList<SampleObject> aryData = new ArrayList<>();
		for(int i = 0; i < 10; i++) {
			SampleObject aryObjData = new SampleObject();
			
			aryObjData.setDataA(RandomStringUtils.randomAlphabetic(RandomUtils.nextInt(5, 10)));
			aryObjData.setDataB(RandomUtils.nextInt(0, 1000));
			aryObjData.setDataC(RandomUtils.nextDouble(0, 1000));
			aryObjData.setDataD(BooleanUtils.toBoolean(RandomUtils.nextInt(0, 2)));
			aryObjData.dataApub = (RandomStringUtils.randomAlphabetic(RandomUtils.nextInt(5, 10)));
			aryObjData.dataBpub = RandomUtils.nextInt(0, 1000);
			aryObjData.dataCpub = RandomUtils.nextDouble(0, 1000);
			aryObjData.dataDpub = BooleanUtils.toBoolean(RandomUtils.nextInt(0, 2));

			aryData.add(aryObjData);
		}
		parameter.put("arrayData", aryData);
		
		ReportMaker maker = new ReportMaker();
		log.info("====== makeReport Start ======");
		maker.makeReport(new File(args[0]), parameter, new File(args[1]));
		System.out.println("output complate " + args[1]);
		System.out.println("see debug log ../log/jaxcel.log");
		log.info("====== makeReport End ======");
	}

}
