/*
 * Decompiled with CFR 0.152.
 */
package org.hanei.jaxcel.report;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.hssf.record.cf.CellRangeUtil;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.hanei.jaxcel.exception.JaxcelInputException;
import org.hanei.jaxcel.report.ELManager;
import org.hanei.jaxcel.report.JaxcelContext;
import org.hanei.jaxcel.util.ExcelUtil;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTDrawing;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTTwoCellAnchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLParser {
    private static final Logger log = LoggerFactory.getLogger(TLParser.class);
    private static final String EL = "el";
    private static final String TL_IF = "if";
    private static final String TL_FOREACH = "foreach";
    private static final String TLP_EXPR = "${";
    private static final String TLP_DELETE = "delete";
    private static final String TLP_DIRECTION = "direction";
    private static final String TLP_SHIFT = "shift";
    private static final String TLP_BLOCK = "block";
    private static final String TLP_STYLE = "style";
    private static final String TLP_START = "start";
    private static final String TLP_END = "end";
    private static final String TLP_ROWS = "rows";
    private static final String TLP_COLS = "cols";
    private static final String LEFT = "left";
    private static final String UP = "up";
    private static final String CLEAR = "clear";
    private static final String ROW = "row";
    private static final String COL = "col";
    private static final String COPY = "copy";
    private static final int SPAN_DEF = 1;
    private static final int IDX_BASE = 1;
    private static final int PARSE_MAX = 10;
    private static final short FORMAT_GENERAL = 0;
    private static final short FORMAT_TEXT = 49;
    private Sheet sheet = null;
    private JaxcelContext context = null;
    private ELManager elMgr = null;
    private Cell cell = null;
    private int startRowIdx;
    private int startColIdx;
    private String type;
    private String expression;
    private String delete;
    private int rowSpan;
    private int colSpan;
    private String direction;
    private boolean shift;
    private boolean block;
    private String style;
    private String start;
    private String end;
    private String list;
    private String object;
    private String matchString;
    private boolean reParseFlg;
    private int parseCount;
    private final String rgEl = "\\$\\{([^\\{\\}]+)\\}";
    private final Pattern ptEl = Pattern.compile("\\$\\{([^\\{\\}]+)\\}");
    private Matcher mtEl;
    private final String rgIf = "#if\\(\\s*(\\$\\{[^\\{\\}]+\\})(?:\\s+(?:(delete\\s*:\\s*\"[^\"]*\")|(block\\s*:\\s*\"[^\"]*\")|(rows\\s*:\\s*\"\\d+\")|(cols\\s*:\\s*\"\\d+\"))){0,4}\\s*\\)";
    private final Pattern ptIf = Pattern.compile("#if\\(\\s*(\\$\\{[^\\{\\}]+\\})(?:\\s+(?:(delete\\s*:\\s*\"[^\"]*\")|(block\\s*:\\s*\"[^\"]*\")|(rows\\s*:\\s*\"\\d+\")|(cols\\s*:\\s*\"\\d+\"))){0,4}\\s*\\)");
    private Matcher mtIf;
    private final String rgForeach = "#foreach\\(\\s*(\\$\\{\\s*\\S+\\s+in\\s+\\S+\\s*\\})(?:\\s+(?:(direction\\s*:\\s*\"[^\"]*\")|(style\\s*:\\s*\"[^\"]*\")|(shift\\s*:\\s*\"[^\"]*\")|(block\\s*:\\s*\"[^\"]*\")|(start\\s*:\\s*\"[^\"]*\")|(end\\s*:\\s*\"[^\"]*\")|(rows\\s*:\\s*\"\\d+\")|(cols\\s*:\\s*\"\\d+\"))){0,8}\\s*\\)";
    private final Pattern ptForeach = Pattern.compile("#foreach\\(\\s*(\\$\\{\\s*\\S+\\s+in\\s+\\S+\\s*\\})(?:\\s+(?:(direction\\s*:\\s*\"[^\"]*\")|(style\\s*:\\s*\"[^\"]*\")|(shift\\s*:\\s*\"[^\"]*\")|(block\\s*:\\s*\"[^\"]*\")|(start\\s*:\\s*\"[^\"]*\")|(end\\s*:\\s*\"[^\"]*\")|(rows\\s*:\\s*\"\\d+\")|(cols\\s*:\\s*\"\\d+\"))){0,8}\\s*\\)");
    private Matcher mtForeach;
    private final String rgAttrEL = "\\$\\{([^\\{\\}]*)\\}";
    private final String rgAttr = "\\s*:\\s*\"([^\"]*)\"";
    private final String $1 = "$1";
    private final Pattern ptAll = Pattern.compile("#if\\(\\s*(\\$\\{[^\\{\\}]+\\})(?:\\s+(?:(delete\\s*:\\s*\"[^\"]*\")|(block\\s*:\\s*\"[^\"]*\")|(rows\\s*:\\s*\"\\d+\")|(cols\\s*:\\s*\"\\d+\"))){0,4}\\s*\\)|#foreach\\(\\s*(\\$\\{\\s*\\S+\\s+in\\s+\\S+\\s*\\})(?:\\s+(?:(direction\\s*:\\s*\"[^\"]*\")|(style\\s*:\\s*\"[^\"]*\")|(shift\\s*:\\s*\"[^\"]*\")|(block\\s*:\\s*\"[^\"]*\")|(start\\s*:\\s*\"[^\"]*\")|(end\\s*:\\s*\"[^\"]*\")|(rows\\s*:\\s*\"\\d+\")|(cols\\s*:\\s*\"\\d+\"))){0,8}\\s*\\)|\\$\\{([^\\{\\}]+)\\}");
    private Matcher mtAll = null;
    private final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ss.SSXXX", "yyyy-MM-dd'T'HH:mm:ss.SXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSXX", "yyyy-MM-dd'T'HH:mm:ss.SSXX", "yyyy-MM-dd'T'HH:mm:ss.SXX", "yyyy-MM-dd'T'HH:mm:ss.SXXX", "yyyy-MM-dd'T'HH:mm:ss.SXX", "yyyy-MM-dd'T'HH:mm:ss.SX", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ssXX", "yyyy-MM-dd'T'HH:mm:ssX", "yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "yyyy/MM/dd HH:mm:ss.S", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd"};
    private final String[] TIME_FORMATS = new String[]{"HH:mm:ss.S", "HH:mm:ss", "HH:mm"};

    public TLParser(JaxcelContext context) {
        this.context = context;
        if (this.context != null) {
            this.sheet = this.context.getCurrentSheet();
            this.elMgr = this.context.getElManager();
        }
    }

    public void parse(Cell cell) {
        log.trace("parse start");
        if (this.elMgr == null) {
            log.error("ELManager is null");
            log.trace("parse end");
            throw new JaxcelInputException("ELManager is null");
        }
        if (cell == null) {
            this.cell = null;
            this.reParseFlg = false;
            this.parseCount = 0;
            log.debug("cell is null");
            log.trace("parse end");
            return;
        }
        if (this.cell == null) {
            log.debug("start new cell parse");
            this.cell = cell;
            this.reParseFlg = false;
            this.parseCount = 0;
        } else if (!this.cell.equals(cell)) {
            log.debug("start new cell parse");
            this.cell = cell;
            this.reParseFlg = false;
            this.parseCount = 0;
        } else {
            log.debug("start repeat cell parse");
            ++this.parseCount;
        }
        if (this.parseCount >= 10) {
            log.warn("parse repeat count over");
            this.reParseFlg = false;
            log.trace("parse end");
            return;
        }
        if (this.find()) {
            if (this.isEL()) {
                this.evaluate();
            } else {
                switch (cell.getCellType()) {
                    case 1: {
                        cell.setCellValue(this.replaceFirst(""));
                        break;
                    }
                    case 2: {
                        try {
                            cell.setCellFormula(this.replaceFirst(""));
                            break;
                        }
                        catch (FormulaParseException e) {
                            log.debug("formula set error: {}", (Object)e.getMessage(), (Object)e);
                            cell.setCellType(3);
                            cell.setCellType(1);
                            cell.setCellValue(this.replaceFirst(""));
                            log.debug("set value type: String");
                        }
                    }
                }
                if (this.isIf()) {
                    this.parseIf();
                } else if (this.isForeach()) {
                    this.parseForeach();
                }
                this.reParseFlg = true;
            }
        } else {
            log.debug("not found TL");
            this.reParseFlg = false;
        }
        log.trace("parse end: reParseFlg: {} parseCount: {}", (Object)this.reParseFlg, (Object)this.parseCount);
    }

    private boolean find() {
        log.trace("matchTL start");
        boolean findFlg = false;
        this.type = null;
        this.expression = null;
        this.rowSpan = 1;
        this.colSpan = 1;
        this.delete = LEFT;
        this.list = null;
        this.object = null;
        this.direction = ROW;
        this.shift = true;
        this.block = true;
        this.style = COPY;
        this.start = null;
        this.end = null;
        this.matchString = null;
        String cellVal = null;
        this.startRowIdx = this.cell.getRowIndex();
        this.startColIdx = this.cell.getColumnIndex();
        switch (this.cell.getCellType()) {
            case 1: {
                cellVal = this.cell.getStringCellValue();
                log.debug("cell[{}] cellType: string  value: {}", (Object)new CellReference(this.cell).formatAsString(), (Object)cellVal);
                break;
            }
            case 2: {
                cellVal = this.cell.getCellFormula();
                log.debug("cell[{}] cellType: formula  value: {}", (Object)new CellReference(this.cell).formatAsString(), (Object)cellVal);
                break;
            }
            default: {
                log.debug("cell type is not string or formula");
                log.trace("matchTL end");
                return findFlg;
            }
        }
        this.mtAll = this.ptAll.matcher(cellVal);
        if (this.mtAll.find()) {
            this.matchString = this.mtAll.group();
            log.debug("match: {}", (Object)this.matchString);
            this.mtIf = this.ptIf.matcher(this.matchString);
            if (this.mtIf.find()) {
                log.debug("type: {}", (Object)TL_IF);
                this.type = TL_IF;
                findFlg = true;
                for (int i = 1; i <= this.mtIf.groupCount(); ++i) {
                    if (this.mtIf.group(i) == null) continue;
                    if (this.mtIf.group(i).startsWith(TLP_EXPR)) {
                        this.expression = this.mtIf.group(i).replaceAll("\\$\\{([^\\{\\}]*)\\}", "$1").trim();
                        log.debug("expression: {}", (Object)this.expression);
                        continue;
                    }
                    if (this.mtIf.group(i).startsWith(TLP_DELETE)) {
                        this.delete = this.mtIf.group(i).replaceAll("delete\\s*:\\s*\"([^\"]*)\"", "$1").trim();
                        log.debug("{}: {}", (Object)TLP_DELETE, (Object)this.delete);
                        if (UP.equalsIgnoreCase(this.delete) || LEFT.equalsIgnoreCase(this.delete) || CLEAR.equalsIgnoreCase(this.delete)) continue;
                        log.debug("{} is illegal argument. set default: {}", (Object)TLP_DELETE, (Object)LEFT);
                        this.delete = LEFT;
                        continue;
                    }
                    if (this.mtIf.group(i).startsWith(TLP_BLOCK)) {
                        this.block = BooleanUtils.toBoolean((String)this.mtIf.group(i).replaceAll("block\\s*:\\s*\"([^\"]*)\"", "$1").trim());
                        log.debug("{}: {}", (Object)TLP_BLOCK, (Object)this.block);
                        continue;
                    }
                    if (this.mtIf.group(i).startsWith(TLP_ROWS)) {
                        this.rowSpan = NumberUtils.toInt((String)this.mtIf.group(i).replaceAll("rows\\s*:\\s*\"([^\"]*)\"", "$1").trim());
                        log.debug("{}: {}", (Object)TLP_ROWS, (Object)this.rowSpan);
                        if (this.rowSpan > 0) continue;
                        log.warn("{} is illegal argument. set default: {}", (Object)TLP_ROWS, (Object)1);
                        this.rowSpan = 1;
                        continue;
                    }
                    if (!this.mtIf.group(i).startsWith(TLP_COLS)) continue;
                    this.colSpan = NumberUtils.toInt((String)this.mtIf.group(i).replaceAll("cols\\s*:\\s*\"([^\"]*)\"", "$1").trim());
                    log.debug("{}: {}", (Object)TLP_COLS, (Object)this.colSpan);
                    if (this.colSpan > 0) continue;
                    log.warn("{} is illegal argument. set default: {}", (Object)TLP_COLS, (Object)1);
                    this.colSpan = 1;
                }
            } else {
                this.mtForeach = this.ptForeach.matcher(this.matchString);
                if (this.mtForeach.find()) {
                    log.debug("type: {}", (Object)TL_FOREACH);
                    this.type = TL_FOREACH;
                    findFlg = true;
                    for (int i = 1; i <= this.mtForeach.groupCount(); ++i) {
                        if (this.mtForeach.group(i) == null) continue;
                        if (this.mtForeach.group(i).startsWith(TLP_EXPR)) {
                            this.expression = this.mtForeach.group(i).replaceAll("\\$\\{([^\\{\\}]*)\\}", "$1").trim();
                            log.debug("expression: {}", (Object)this.expression);
                            String[] tmp = this.expression.split("\\s+");
                            if (tmp != null && tmp.length == 3) {
                                this.object = tmp[0];
                                this.list = tmp[2];
                                if (!log.isDebugEnabled()) continue;
                                log.debug("object: {}", (Object)this.object);
                                log.debug("list: {}", (Object)this.list);
                                continue;
                            }
                            log.warn("format error: ex) object in list");
                            continue;
                        }
                        if (this.mtForeach.group(i).startsWith(TLP_DIRECTION)) {
                            this.direction = this.mtForeach.group(i).replaceAll("direction\\s*:\\s*\"([^\"]*)\"", "$1");
                            log.debug("{}: {}", (Object)TLP_DIRECTION, (Object)this.direction);
                            if (ROW.equalsIgnoreCase(this.direction) || COL.equalsIgnoreCase(this.direction)) continue;
                            log.warn("{} is illegal argument. set default: {}", (Object)TLP_DIRECTION, (Object)ROW);
                            this.direction = ROW;
                            continue;
                        }
                        if (this.mtForeach.group(i).startsWith(TLP_SHIFT)) {
                            this.shift = BooleanUtils.toBoolean((String)this.mtForeach.group(i).replaceAll("shift\\s*:\\s*\"([^\"]*)\"", "$1").trim());
                            log.debug("{}: {}", (Object)TLP_SHIFT, (Object)this.shift);
                            continue;
                        }
                        if (this.mtForeach.group(i).startsWith(TLP_BLOCK)) {
                            this.block = BooleanUtils.toBoolean((String)this.mtForeach.group(i).replaceAll("block\\s*:\\s*\"([^\"]*)\"", "$1").trim());
                            log.debug("{}: {}", (Object)TLP_BLOCK, (Object)this.block);
                            continue;
                        }
                        if (this.mtForeach.group(i).startsWith(TLP_STYLE)) {
                            this.style = this.mtForeach.group(i).replaceAll("style\\s*:\\s*\"([^\"]*)\"", "$1").trim();
                            log.debug("{}: {}", (Object)TLP_STYLE, (Object)this.style);
                            continue;
                        }
                        if (this.mtForeach.group(i).startsWith(TLP_START)) {
                            this.start = this.mtForeach.group(i).replaceAll("start\\s*:\\s*\"([^\"]*)\"", "$1");
                            log.debug("{}: {}", (Object)TLP_START, (Object)this.start);
                            continue;
                        }
                        if (this.mtForeach.group(i).startsWith(TLP_END)) {
                            this.end = this.mtForeach.group(i).replaceAll("end\\s*:\\s*\"([^\"]*)\"", "$1");
                            log.debug("{}: {}", (Object)TLP_END, (Object)this.end);
                            continue;
                        }
                        if (this.mtForeach.group(i).startsWith(TLP_ROWS)) {
                            this.rowSpan = NumberUtils.toInt((String)this.mtForeach.group(i).replaceAll("rows\\s*:\\s*\"([^\"]*)\"", "$1").trim());
                            log.debug("{}: {}", (Object)TLP_ROWS, (Object)this.rowSpan);
                            if (this.rowSpan > 0) continue;
                            log.warn("{} is illegal argument. set default: {}", (Object)TLP_ROWS, (Object)1);
                            this.rowSpan = 1;
                            continue;
                        }
                        if (!this.mtForeach.group(i).startsWith(TLP_COLS)) continue;
                        this.colSpan = NumberUtils.toInt((String)this.mtForeach.group(i).replaceAll("cols\\s*:\\s*\"([^\"]*)\"", "$1").trim());
                        log.debug("{}: {}", (Object)TLP_COLS, (Object)this.colSpan);
                        if (this.colSpan > 0) continue;
                        log.warn("{} is illegal argument. set default: {}", (Object)TLP_COLS, (Object)1);
                        this.colSpan = 1;
                    }
                } else {
                    this.mtEl = this.ptEl.matcher(this.matchString);
                    if (this.mtEl.find()) {
                        log.debug("type: {}", (Object)EL);
                        this.type = EL;
                        findFlg = true;
                        this.expression = this.mtEl.group(1).trim();
                        log.debug("expression: {}", (Object)this.expression);
                    } else {
                        log.warn("TL type: ???");
                        this.reParseFlg = false;
                    }
                }
            }
        } else {
            log.debug("unmatch");
        }
        log.trace("matchTL end: {}", (Object)findFlg);
        return findFlg;
    }

    private void evaluate() {
        log.trace("evaluate start");
        Object elResult = this.elMgr.evaluate(this.expression);
        if (elResult == null) {
            log.debug("evaluate result is null");
        } else {
            log.debug("evaluate result: {}", (Object)elResult.toString());
        }
        String newCellVal = this.replaceFirst(elResult == null ? "" : elResult.toString());
        log.debug("replace value: {}", (Object)newCellVal);
        if (!"".equals(newCellVal.trim())) {
            if (NumberUtils.isNumber((String)newCellVal)) {
                if (this.cell.getCellType() == 1) {
                    this.cell.setCellType(3);
                    this.cell.setCellType(0);
                    try {
                        this.cell.setCellValue((double)Integer.parseInt(newCellVal));
                        log.debug("set value type: Integer");
                    }
                    catch (NumberFormatException e) {
                        this.cell.setCellValue(NumberUtils.toDouble((String)newCellVal));
                        log.debug("set value type: Double");
                    }
                } else {
                    try {
                        this.cell.setCellFormula(newCellVal);
                        log.debug("set value type: Formula");
                    }
                    catch (FormulaParseException e) {
                        log.warn("formula set error: {}", (Object)e.getMessage(), (Object)e);
                        this.cell.setCellType(3);
                        this.cell.setCellType(0);
                        try {
                            this.cell.setCellValue((double)Integer.parseInt(newCellVal));
                            log.debug("set value type: Integer");
                        }
                        catch (NumberFormatException e2) {
                            this.cell.setCellValue(NumberUtils.toDouble((String)newCellVal));
                            log.debug("set value type: Double");
                        }
                    }
                }
                this.reParseFlg = false;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)newCellVal, (CharSequence)"true") || StringUtils.equalsIgnoreCase((CharSequence)newCellVal, (CharSequence)"false")) {
                if (this.cell.getCellType() == 1) {
                    this.cell.setCellType(3);
                    this.cell.setCellType(4);
                    this.cell.setCellValue(BooleanUtils.toBoolean((String)newCellVal));
                    log.debug("set value type: Boolean");
                } else {
                    try {
                        this.cell.setCellFormula(newCellVal);
                        log.debug("set value type: Formula");
                    }
                    catch (FormulaParseException e) {
                        log.warn("formula set error: {}", (Object)e.getMessage(), (Object)e);
                        this.cell.setCellType(3);
                        this.cell.setCellType(4);
                        this.cell.setCellValue(BooleanUtils.toBoolean((String)newCellVal));
                        log.debug("set value type: Boolean");
                    }
                }
                this.reParseFlg = false;
            } else {
                Date tmpDate = null;
                int valType = -1;
                for (int i = 0; i < 3; ++i) {
                    switch (i) {
                        case 0: {
                            try {
                                tmpDate = DateUtils.parseDateStrictly((String)newCellVal, (Locale)Locale.getDefault(), (String[])this.DATE_FORMATS);
                                valType = i;
                            }
                            catch (ParseException e1) {}
                            break;
                        }
                        case 1: {
                            try {
                                tmpDate = DateUtils.parseDateStrictly((String)newCellVal, (String[])this.TIME_FORMATS);
                                valType = i;
                            }
                            catch (ParseException e1) {}
                            break;
                        }
                        default: {
                            valType = i;
                        }
                    }
                    if (valType >= 0) break;
                }
                switch (valType) {
                    case 0: 
                    case 1: {
                        if (this.cell.getCellType() == 1) {
                            this.cell.setCellType(3);
                            this.cell.setCellType(0);
                            if (0 == this.cell.getCellStyle().getDataFormat() || 49 == this.cell.getCellStyle().getDataFormat()) {
                                this.cell.setCellValue(newCellVal);
                                log.debug("set value type: String");
                            } else {
                                switch (valType) {
                                    case 0: {
                                        this.cell.setCellValue(tmpDate);
                                        log.debug("set value type: Date");
                                        break;
                                    }
                                    case 1: {
                                        this.cell.setCellValue((double)(tmpDate.getTime() + (long)TimeZone.getDefault().getRawOffset()) / 8.64E7);
                                        log.debug("set value type: double");
                                    }
                                }
                            }
                        } else {
                            try {
                                this.cell.setCellFormula(newCellVal);
                                log.debug("set value type: Formula");
                            }
                            catch (FormulaParseException e) {
                                log.warn("formula set error: {}", (Object)e.getMessage(), (Object)e);
                                this.cell.setCellType(3);
                                this.cell.setCellType(0);
                                this.cell.setCellValue(tmpDate);
                                log.debug("set value type: Date");
                            }
                        }
                        this.reParseFlg = false;
                        break;
                    }
                    default: {
                        if (this.cell.getCellType() == 1) {
                            this.cell.setCellValue(newCellVal);
                            log.debug("set value type: String");
                        } else {
                            try {
                                this.cell.setCellFormula(newCellVal);
                                log.debug("set value type: Formula");
                            }
                            catch (FormulaParseException e2) {
                                log.warn("formula set error: {}", (Object)e2.getMessage(), (Object)e2);
                                this.cell.setCellType(3);
                                this.cell.setCellType(1);
                                this.cell.setCellValue(newCellVal);
                                log.debug("set value type: String");
                            }
                        }
                        this.reParseFlg = true;
                        break;
                    }
                }
            }
        } else {
            this.cell.setCellType(3);
            this.reParseFlg = false;
        }
        log.trace("evaluate end");
    }

    private void parseForeach() {
        int endIdx;
        int startIdx;
        Object evalObject;
        log.trace("parseForeach start");
        Object[] mapKeys = null;
        ArrayList<CellRangeAddress> rangeList = new ArrayList<CellRangeAddress>();
        Object listObject = this.elMgr.evaluate(this.list);
        if (listObject == null) {
            log.debug("list is null eval response.");
            log.trace("parseForeach end");
            return;
        }
        log.debug("list class: {}", (Object)listObject.getClass().getName());
        if (listObject instanceof Map) {
            mapKeys = ((Map)listObject).keySet().toArray();
        }
        if ((evalObject = this.elMgr.evaluate("size(" + this.list + ")")) == null) {
            log.error("list size unknown");
            log.trace("parseForeach end");
            return;
        }
        if (!(evalObject instanceof Integer)) {
            log.error("list size is not Integer instance");
            log.trace("parseForeach end");
            return;
        }
        int listSize = (Integer)evalObject;
        log.debug("list size: {}", (Object)listSize);
        if (this.start != null) {
            log.debug("start: {}", (Object)this.start);
            evalObject = this.elMgr.evaluate(this.start);
            if (evalObject != null) {
                if (!(evalObject instanceof Integer)) {
                    log.warn("start is not Integer instance. start set default: {}", (Object)1);
                    startIdx = 1;
                } else {
                    startIdx = (Integer)evalObject;
                    if (startIdx == 0) {
                        startIdx = 1;
                    } else if (startIdx < 0) {
                        startIdx = listSize + startIdx + 1;
                    } else if (startIdx > listSize) {
                        startIdx = listSize;
                    }
                }
            } else {
                log.debug("start is null eval response. start set default: {}", (Object)1);
                startIdx = 1;
            }
        } else {
            log.debug("start is null. start set default: {}", (Object)1);
            startIdx = 1;
        }
        log.debug("startIdx: {}", (Object)startIdx);
        if (this.end != null) {
            log.debug("end: {}", (Object)this.end);
            evalObject = this.elMgr.evaluate(this.end);
            if (evalObject != null) {
                if (!(evalObject instanceof Integer)) {
                    log.warn("end is not Integer instance. end set list size: {}", (Object)listSize);
                    endIdx = listSize;
                } else {
                    endIdx = (Integer)evalObject;
                    if (endIdx == 0) {
                        endIdx = listSize;
                    } else if (endIdx < 0) {
                        endIdx = listSize + endIdx + 1;
                    } else if (endIdx > listSize) {
                        endIdx = listSize;
                    }
                }
            } else {
                log.debug("end is null eval response. end set list size: {}", (Object)listSize);
                endIdx = listSize;
            }
        } else {
            log.debug("end is null. end set list size: {}", (Object)listSize);
            endIdx = listSize;
        }
        if (log.isDebugEnabled()) {
            log.debug("endIdx: {}", (Object)endIdx);
            log.debug("direction: {}", (Object)this.direction);
            log.debug("shift: {}", (Object)this.shift);
            log.debug("block: {}", (Object)this.block);
            log.debug("style: {}", (Object)this.style);
        }
        CellRangeAddress fromRange = !this.block ? (COL.equalsIgnoreCase(this.direction) ? new CellRangeAddress(this.sheet.getFirstRowNum(), this.sheet.getLastRowNum(), this.startColIdx, this.startColIdx + this.colSpan - 1) : new CellRangeAddress(this.startRowIdx, this.startRowIdx + this.rowSpan - 1, 0, ExcelUtil.getLastColNum(this.sheet))) : new CellRangeAddress(this.startRowIdx, this.startRowIdx + this.rowSpan - 1, this.startColIdx, this.startColIdx + this.colSpan - 1);
        fromRange = ExcelUtil.getIntersectRange(this.sheet, fromRange);
        if (startIdx != endIdx) {
            int copyCount = startIdx < endIdx ? endIdx - startIdx : startIdx - endIdx;
            CellRangeAddress toRange = COL.equalsIgnoreCase(this.direction) ? new CellRangeAddress(fromRange.getFirstRow(), fromRange.getLastRow(), fromRange.getLastColumn() + 1, fromRange.getLastColumn() + (fromRange.getLastColumn() - fromRange.getFirstColumn() + 1) * copyCount) : new CellRangeAddress(fromRange.getLastRow() + 1, fromRange.getLastRow() + (fromRange.getLastRow() - fromRange.getFirstRow() + 1) * copyCount, fromRange.getFirstColumn(), fromRange.getLastColumn());
            if (this.shift) {
                int distance;
                int n = distance = startIdx > endIdx ? startIdx - endIdx : endIdx - startIdx;
                if (COL.equalsIgnoreCase(this.direction)) {
                    ExcelUtil.shift(this.sheet, new CellRangeAddress(fromRange.getFirstRow(), fromRange.getLastRow(), fromRange.getLastColumn() + 1, fromRange.getLastColumn() + 1), COL, distance *= this.colSpan, this.block);
                } else {
                    ExcelUtil.shift(this.sheet, new CellRangeAddress(fromRange.getLastRow() + 1, fromRange.getLastRow() + 1, fromRange.getFirstColumn(), fromRange.getLastColumn()), ROW, distance *= this.rowSpan, this.block);
                }
            } else {
                ExcelUtil.clearRange(this.sheet, toRange, COPY.equalsIgnoreCase(this.style), COPY.equalsIgnoreCase(this.style));
            }
            if (COPY.equalsIgnoreCase(this.style)) {
                block18: for (int i = 0; i < this.sheet.getNumMergedRegions(); ++i) {
                    CellRangeAddress tmpRange = this.sheet.getMergedRegion(i);
                    switch (CellRangeUtil.intersect((CellRangeAddress)fromRange, (CellRangeAddress)tmpRange)) {
                        case 3: {
                            rangeList.add(tmpRange);
                            log.debug("from range inside mergedRegion. save: {}", (Object)tmpRange.formatAsString());
                            continue block18;
                        }
                        case 4: {
                            log.warn("from range encloses mergedRegion. remove: {}", (Object)tmpRange.formatAsString());
                            this.sheet.removeMergedRegion(i);
                            continue block18;
                        }
                        case 2: {
                            log.warn("from range overlap mergedRegion. remove: {}", (Object)tmpRange.formatAsString());
                            this.sheet.removeMergedRegion(i);
                        }
                    }
                }
            }
        }
        boolean copyFlg = true;
        int i = startIdx;
        int cpCount = 0;
        while (startIdx <= endIdx && i <= endIdx || startIdx > endIdx && i >= endIdx) {
            block20: for (int r = fromRange.getFirstRow(); r <= fromRange.getLastRow(); ++r) {
                Row toRow;
                if (ROW.equalsIgnoreCase(this.direction) && (r + this.rowSpan * cpCount < 0 || r + this.rowSpan * cpCount > ExcelUtil.getMaxRowIndex(this.sheet))) {
                    log.warn("to row outside sheet");
                    copyFlg = false;
                    break;
                }
                Row fromRow = this.sheet.getRow(r);
                Row row = toRow = ROW.equalsIgnoreCase(this.direction) ? this.sheet.getRow(r + this.rowSpan * cpCount) : fromRow;
                if (fromRow == null) {
                    if (toRow != null) {
                        log.debug("continue. from row [{}] is null. to row [{}] remove", (Object)(r + 1), (Object)(toRow.getRowNum() + 1));
                        this.sheet.removeRow(toRow);
                        continue;
                    }
                    log.debug("continue. from row [{}] and to row [{}] is null", (Object)(r + 1), (Object)((ROW.equalsIgnoreCase(this.direction) ? r + this.rowSpan * cpCount : r) + 1));
                    continue;
                }
                if (toRow == null) {
                    toRow = this.sheet.createRow(r + this.rowSpan * cpCount);
                }
                if (fromRow.getRowNum() != toRow.getRowNum() && !this.block) {
                    toRow.setHeight(fromRow.getHeight());
                }
                block21: for (int c = fromRange.getFirstColumn(); c <= fromRange.getLastColumn(); ++c) {
                    if (COL.equalsIgnoreCase(this.direction) && (c + this.colSpan * cpCount < 0 || c + this.colSpan * cpCount > ExcelUtil.getMaxColumnIndex(this.sheet))) {
                        log.warn("to cell outside sheet");
                        continue block20;
                    }
                    Cell fromCell = fromRow.getCell(c);
                    Cell toCell = toRow.getCell(COL.equalsIgnoreCase(this.direction) ? c + this.colSpan * cpCount : c);
                    if (fromCell == null) {
                        if (toCell != null) {
                            log.debug("continue. from cell [{}] is null. to cell [{}] remove", (Object)new CellReference(fromRow.getRowNum(), c).formatAsString(), (Object)new CellReference(toCell.getRowIndex(), toCell.getColumnIndex()).formatAsString());
                            toRow.removeCell(toCell);
                            continue;
                        }
                        log.debug("continue. from cell [{}] and to cell [{}] is null", (Object)new CellReference(fromRow.getRowNum(), c).formatAsString(), (Object)new CellReference(toRow.getRowNum(), COL.equalsIgnoreCase(this.direction) ? c + this.colSpan * cpCount : c).formatAsString());
                        continue;
                    }
                    if (toCell == null) {
                        toCell = toRow.createCell(COL.equalsIgnoreCase(this.direction) ? c + this.colSpan * cpCount : c);
                    }
                    if (cpCount == 0 && fromCell.getColumnIndex() != toCell.getColumnIndex() && !this.block) {
                        this.sheet.setColumnWidth(toCell.getColumnIndex(), this.sheet.getColumnWidth(fromCell.getColumnIndex()));
                    }
                    if (cpCount > 0 && COPY.equalsIgnoreCase(this.style)) {
                        toCell.setCellStyle(fromCell.getCellStyle());
                    }
                    switch (fromCell.getCellType()) {
                        case 3: {
                            toCell.setCellType(3);
                            continue block21;
                        }
                        case 4: {
                            toCell.setCellType(4);
                            toCell.setCellValue(fromCell.getBooleanCellValue());
                            continue block21;
                        }
                        case 5: {
                            toCell.setCellType(5);
                            toCell.setCellErrorValue(fromCell.getErrorCellValue());
                            continue block21;
                        }
                        case 2: {
                            toCell.setCellType(2);
                            toCell.setCellFormula(ExcelUtil.getMoveFormula(this.sheet, fromCell.getCellFormula().replace(cpCount == 0 ? this.object : this.list + "[" + (mapKeys == null ? Integer.valueOf(startIdx - 1) : "'" + mapKeys[startIdx - 1] + "'") + "]", this.list + "[" + (mapKeys == null ? Integer.valueOf(i - 1) : "'" + mapKeys[i - 1] + "'") + "]"), toCell.getRowIndex() - fromCell.getRowIndex(), toCell.getColumnIndex() - fromCell.getColumnIndex()));
                            log.debug("to cell Formula: {}", (Object)toCell.getCellFormula());
                            continue block21;
                        }
                        case 0: {
                            toCell.setCellType(0);
                            toCell.setCellValue(fromCell.getNumericCellValue());
                            continue block21;
                        }
                        case 1: {
                            toCell.setCellType(1);
                            toCell.setCellValue(fromCell.getStringCellValue().replace(cpCount == 0 ? this.object : this.list + "[" + (mapKeys == null ? Integer.valueOf(startIdx - 1) : "'" + mapKeys[startIdx - 1] + "'") + "]", this.list + "[" + (mapKeys == null ? Integer.valueOf(i - 1) : "'" + mapKeys[i - 1] + "'") + "]"));
                            log.debug("to cell string: {}", (Object)toCell.getStringCellValue());
                        }
                    }
                }
            }
            if (!copyFlg) break;
            i = startIdx <= endIdx ? i + 1 : i - 1;
            ++cpCount;
        }
        if (COPY.equalsIgnoreCase(this.style)) {
            CellRangeAddress tmpAfRange;
            CellRangeAddress tmpBfRange;
            int addRow = 0;
            int addCol = 0;
            if (COL.equalsIgnoreCase(this.direction)) {
                addCol = this.colSpan;
            } else {
                addRow = this.rowSpan;
            }
            if (!rangeList.isEmpty()) {
                for (int c = 0; c < rangeList.size(); ++c) {
                    tmpBfRange = (CellRangeAddress)rangeList.get(c);
                    int i2 = startIdx;
                    int cpCount2 = 0;
                    while (startIdx <= endIdx && i2 <= endIdx || startIdx > endIdx && i2 >= endIdx) {
                        if (i2 != startIdx && ExcelUtil.validateRange(this.sheet, tmpAfRange = new CellRangeAddress(tmpBfRange.getFirstRow() + addRow * cpCount2, tmpBfRange.getLastRow() + addRow * cpCount2, tmpBfRange.getFirstColumn() + addCol * cpCount2, tmpBfRange.getLastColumn() + addCol * cpCount2))) {
                            this.sheet.addMergedRegion(tmpAfRange);
                            log.debug("mergedRegion copy. from: [{}] to: [{}]", (Object)tmpBfRange.formatAsString(), (Object)tmpAfRange.formatAsString());
                        }
                        i2 = startIdx <= endIdx ? i2 + 1 : i2 - 1;
                        ++cpCount2;
                    }
                }
            }
            if (this.sheet instanceof XSSFSheet) {
                try {
                    for (POIXMLDocumentPart part : ((XSSFSheet)this.sheet).getRelations()) {
                        CTDrawing ctDrawing;
                        if (part == null) continue;
                        log.debug("DocumentPart class: {}", (Object)part.getClass().getName());
                        if (!(part instanceof XSSFDrawing) || (ctDrawing = ((XSSFDrawing)part).getCTDrawing()) == null) continue;
                        int alSize = ctDrawing.getTwoCellAnchorList().size();
                        block25: for (int i3 = 0; i3 < alSize; ++i3) {
                            CTTwoCellAnchor fAnchor = (CTTwoCellAnchor)ctDrawing.getTwoCellAnchorList().get(i3);
                            if (fAnchor.isSetGraphicFrame()) continue;
                            CTMarker from = fAnchor.getFrom();
                            int r1 = from.getRow();
                            int c1 = from.getCol();
                            CTMarker to = fAnchor.getTo();
                            int r2 = to.getRow();
                            int c2 = to.getCol();
                            tmpBfRange = new CellRangeAddress(r1, r2, c1, c2);
                            switch (CellRangeUtil.intersect((CellRangeAddress)fromRange, (CellRangeAddress)tmpBfRange)) {
                                case 2: 
                                case 3: {
                                    int j = startIdx;
                                    int cpCount3 = 0;
                                    while (startIdx <= endIdx && j <= endIdx || startIdx > endIdx && j >= endIdx) {
                                        if (j != startIdx) {
                                            CTTwoCellAnchor cpAnchor = ctDrawing.addNewTwoCellAnchor();
                                            cpAnchor.set(fAnchor.copy());
                                            from = cpAnchor.getFrom();
                                            from.setRow(from.getRow() + addRow * cpCount3);
                                            from.setCol(from.getCol() + addCol * cpCount3);
                                            to = cpAnchor.getTo();
                                            to.setRow(to.getRow() + addRow * cpCount3);
                                            to.setCol(to.getCol() + addCol * cpCount3);
                                            if (log.isDebugEnabled()) {
                                                tmpAfRange = new CellRangeAddress(from.getRow(), to.getRow(), from.getCol(), to.getCol());
                                                log.debug("object copy from: [{}] to: [{}]", (Object)tmpBfRange.formatAsString(), (Object)tmpAfRange.formatAsString());
                                            }
                                        }
                                        j = startIdx <= endIdx ? j + 1 : j - 1;
                                        ++cpCount3;
                                    }
                                    continue block25;
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error("object copy error: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        log.trace("parseForeach end");
    }

    private void parseIf() {
        boolean result;
        log.trace("parseIf start");
        Object elResult = this.elMgr.evaluate(this.expression);
        if (elResult == null) {
            log.debug("evaluate result is null");
            result = false;
        } else {
            result = elResult instanceof Boolean ? (Boolean)elResult : true;
        }
        log.debug("evaluate result: {}", (Object)result);
        if (!result) {
            if (this.delete == null) {
                log.debug("{} is null set default: {}", (Object)TLP_DELETE, (Object)LEFT);
                this.delete = LEFT;
            } else if (!(LEFT.equalsIgnoreCase(this.delete) || UP.equalsIgnoreCase(this.delete) || CLEAR.equalsIgnoreCase(this.delete))) {
                log.warn("{} is illegal argument. set default: {}", (Object)TLP_DELETE, (Object)LEFT);
                this.delete = LEFT;
            } else {
                log.debug("delete: {}", (Object)this.delete);
                this.delete = this.delete.toLowerCase().trim();
            }
            switch (this.delete) {
                case "clear": {
                    ExcelUtil.clearRange(this.sheet, new CellRangeAddress(this.startRowIdx, this.startRowIdx + this.rowSpan - 1, this.startColIdx, this.startColIdx + this.colSpan - 1), false, false);
                    break;
                }
                case "left": {
                    ExcelUtil.shift(this.sheet, new CellRangeAddress(this.startRowIdx, this.startRowIdx + this.rowSpan - 1, this.startColIdx + this.colSpan, this.startColIdx + this.colSpan), COL, -this.colSpan, this.block);
                    break;
                }
                case "up": {
                    ExcelUtil.shift(this.sheet, new CellRangeAddress(this.startRowIdx + this.rowSpan, this.startRowIdx + this.rowSpan, this.startColIdx, this.startColIdx + this.colSpan - 1), ROW, -this.rowSpan, this.block);
                }
            }
        }
        log.trace("parseIf end");
    }

    private boolean isEL() {
        return EL.equalsIgnoreCase(this.type);
    }

    private boolean isIf() {
        return TL_IF.equalsIgnoreCase(this.type);
    }

    private boolean isForeach() {
        return TL_FOREACH.equalsIgnoreCase(this.type);
    }

    private String replaceFirst(String replacement) {
        return this.mtAll.replaceFirst(replacement == null ? "" : replacement);
    }

    public boolean isReParseCell() {
        return this.reParseFlg;
    }
}

