/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.PlainConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LongConverter
implements Converter {
    public static final LongConverter INSTANCE = new LongConverter();

    LongConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Long.TYPE == cls || Long.class == cls;
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        NumberFormat f;
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value instanceof String && (f = context.getNumberFormat()) != null) {
            value = f.parse((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).longValueExact();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = value.toString().trim();
            if (str.length() > 0) {
                int start = 0;
                if (str.charAt(0) == '+') {
                    ++start;
                }
                if (str.startsWith("0x", start)) {
                    return Long.parseLong(str.substring(start + 2), 16);
                }
                return Long.parseLong(str.substring(start));
            }
            return PlainConverter.getDefaultValue(c);
        }
        if (value != null) {
            throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
        }
        return PlainConverter.getDefaultValue(c);
    }
}

