/**
 * Copyright 2014 Hanei Management Co.,Ltd. 
 * 
 * This file is part of Jaxcel
 * 
 *  Jaxcel is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Jaxcel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.hanei.jaxcel.exception;

/**
 * Jaxcelインプット例外クラス<br>
 * 引数チェックエラー、ファイルオープンエラー等発生時の例外
 * 
 * @version 1.00.00
 * @author Noboru Saito
 */
public class JaxcelInputException extends JaxcelRuntimeException {

	private static final long serialVersionUID = 3566178395737747203L;

	public JaxcelInputException(String message) {
		super(message);
	}

	public JaxcelInputException(String message, Throwable cause) {
		super(message, cause);
	}

}
