/**
 * Copyright 2014 Hanei Management Co.,Ltd. 
 * 
 * This file is part of Jaxcel
 * 
 *  Jaxcel is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Jaxcel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.hanei.jaxcel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import net.arnx.jsonic.JSON;
import org.hanei.jaxcel.report.ReportMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Excel帳票出力コマンドラインツールクラス
 * 
 * @version 1.00.00
 * @author Noboru Saito
 */
public class MakeReportTool {

	private static final Logger log = LoggerFactory.getLogger(MakeReportTool.class);

	/**
	 * ExcelテンプレートファイルにJSONファイルのデータを挿入することでExcel帳票を生成、Excel帳票ファイルを出力する。<br>
	 * 
	 * @param args arg1: Excelテンプレートファイルパス<br>
	 *       arg2: パラメータJSONファイルパス<br>
	 *       arg3: Excel帳票出力ファイルパス
	 * 
	 * @throws Exception 
	 */
	public static void main(String[] args) throws Exception {
		
		if(args.length != 3) {
			System.out.println("illegal arguments.");
			System.out.println("arg1: template excel file path");
			System.out.println("arg2: parameters json file path");
			System.out.println("arg3: output excel file path");
			System.out.println("...relative path from the build root. or absolute path");
			System.exit(0);
		}
		// data load
		HashMap<String, Object> parameter = JSON.decode(new InputStreamReader(new FileInputStream(new File(args[1])),"UTF-8"));
		
		ReportMaker maker = new ReportMaker();
		log.info("====== makeReport Start ======");
		maker.makeReport(new File(args[0]), parameter, new File(args[2]));
		System.out.println("output complate: " + args[2]);
		log.info("====== makeReport End ======");
		System.exit(0);
	}

}
