/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.jdbcdebug.util;

import ams.com.ams.jdbcdebug.util.ConnectionDtl;
import ams.com.ams.jdbcdebug.util.Survey;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.log4j.Category;

public class Log {
    private static final String prefix;
    private static final int OUTTYPE_STDOUT = 1;
    private static final int OUTTYPE_FILE = 2;
    private static final int OUTTYPE_LOG4J = 3;
    private static final int outType;
    private static SimpleDateFormat df;
    private static final String LOG_FILE = "jdbcdebug.log";
    private static Category cat;
    private static String sql_regexp;
    private static Pattern ptn;
    private static String CRLF;

    static {
        df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        cat = Category.getInstance((String)"jdbcdebug");
        CRLF = "\r\n";
        ResourceBundle bundle = ResourceBundle.getBundle("jdbcdebug");
        int otype = 1;
        try {
            otype = Integer.parseInt(bundle.getString("OutputType"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        outType = otype;
        if (outType == 3) {
            CRLF = "";
            df = new SimpleDateFormat("");
        }
        String l_prefix = null;
        try {
            l_prefix = bundle.getString("OutputPrefix");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        prefix = l_prefix;
        String l_sql_regexp = null;
        try {
            l_sql_regexp = bundle.getString("SQL.check.regexp");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        sql_regexp = l_sql_regexp;
        if (sql_regexp != null && sql_regexp.length() > 0) {
            ptn = Pattern.compile(sql_regexp, 2);
        }
        Log.println("start");
    }

    private Log() {
    }

    public static void println(String string) {
        String outtext = String.valueOf(prefix) + " " + df.format(Calendar.getInstance().getTime()) + " " + string + CRLF;
        Log.output(outtext);
    }

    private static void output(String outtext) {
        switch (outType) {
            case 2: {
                Log.outputFile(outtext);
                break;
            }
            case 3: {
                Log.outputLog4j(outtext);
                break;
            }
            default: {
                Log.outputStdout(outtext);
            }
        }
    }

    private static void outputLog4j(String outtext) {
        cat.debug((Object)outtext);
    }

    private static void outputStdout(String outtext) {
        System.out.print(outtext);
    }

    private static void outputFile(String outtext) {
        FileWriter fr = null;
        try {
            fr = new FileWriter(new File(LOG_FILE), true);
            fr.write(outtext);
            fr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void printlnSqlLog(String sql, Survey survey) {
        String outtext = String.valueOf(prefix) + " " + df.format(Calendar.getInstance().getTime()) + " " + (survey.getEndMs() - survey.getStartMs()) + "ms " + sql + CRLF;
        Log.output(outtext);
        if (sql_regexp != null && sql_regexp.length() > 0 && sql != null && sql.length() > 0) {
            Log.sqlRegexpMatch(sql);
        }
    }

    private static void sqlRegexpMatch(String sql) {
        if (ptn != null && ptn.matcher(sql).matches()) {
            StackTraceElement[] el = new Exception().getStackTrace();
            String trace = String.valueOf(prefix) + "[SQL Regexp match] " + ConnectionDtl.formatStackTrace(el);
            Log.output(trace);
        }
    }

    public static void printlnSqlExceptionLog(String string, SQLException e) {
        String outtext = String.valueOf(prefix) + " " + df.format(Calendar.getInstance().getTime()) + " " + string + " [SQLException] " + e.getMessage() + "(" + e.getErrorCode() + ")" + CRLF;
        Log.output(outtext);
    }

    public static void printlnSqlLog(String string, Survey survey, HashMap paramMap) {
        String wstr = string;
        int q = 0;
        int paramIndex = 1;
        while ((q = wstr.indexOf(63, q)) != -1) {
            String paramIndexS = Integer.toString(paramIndex);
            if (paramMap.containsKey(paramIndexS)) {
                wstr = String.valueOf(wstr.substring(0, q)) + Log.encodeSqlField(paramMap.get(paramIndexS)) + wstr.substring(q + 1);
            }
            ++paramIndex;
        }
        Log.printlnSqlLog(wstr, survey);
    }

    private static String encodeSqlField(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return "'" + object + "'";
        }
        return object.toString();
    }
}

