/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.jdbcdebug.util;

import ams.com.ams.jdbcdebug.sql.Driver;
import ams.com.ams.jdbcdebug.util.ConCheckMgr;
import ams.com.ams.jdbcdebug.util.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimerTask;

public class ValueCheckTask
extends TimerTask {
    private final String name;
    private final String sql;
    private final long interval;
    private final int type;
    private final String val;
    private final int intVal;
    private Connection con;
    private PreparedStatement st;

    public ValueCheckTask(String name, String sql, long interval, int type, String val) {
        this.name = name;
        this.sql = sql;
        this.interval = interval;
        this.type = type;
        this.val = val;
        int int_val = 0;
        try {
            int_val = Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.intVal = int_val;
    }

    public void run() {
        long now = System.currentTimeMillis();
        Log.println("[ValueCheck] start " + this.name);
        try {
            if (this.con == null) {
                Log.println("getting connection of " + this.name);
                this.con = Driver.getDriverInstance().connectByConfirm();
                if (this.con == null) {
                    Log.println("connection is null. please wait.. " + this.name);
                    return;
                }
                this.st = this.con.prepareStatement(this.sql);
                ConCheckMgr.removeChecker(this.con);
            }
            ResultSet rs = this.st.executeQuery();
            boolean match = false;
            int recnum = 0;
            ArrayList rlist = new ArrayList();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int cols = rs.getMetaData().getColumnCount();
                int i = 1;
                while (i <= cols) {
                    map.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                    ++i;
                }
                rlist.add(map);
                ++recnum;
            }
            switch (this.type) {
                case 1: {
                    match = (long)recnum < this.interval;
                    break;
                }
                case 2: {
                    match = (long)recnum <= this.interval;
                    break;
                }
                case 3: {
                    match = (long)recnum == this.interval;
                    break;
                }
                case 4: {
                    match = (long)recnum >= this.interval;
                    break;
                }
                case 5: {
                    match = recnum > this.intVal;
                    break;
                }
                case 10: {
                    match = rlist.size() > 0 && rlist.get(0) != null && rlist.get(0) instanceof String && ((String)rlist.get(0)).equals(this.val);
                    break;
                }
                case 12: {
                    boolean bl = match = rlist.size() > 0 && rlist.get(0) != null && rlist.get(0) instanceof String && !((String)rlist.get(0)).equals(this.val);
                }
            }
            if (match) {
                Log.println("[ValueCheck] match condition ########\uff08\u30fb\u2200\u30fb\uff09###### check db:" + this.sql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public String getName() {
        return this.name;
    }

    public String getSql() {
        return this.sql;
    }

    public int getType() {
        return this.type;
    }

    public String getVal() {
        return this.val;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.con != null && !this.con.isClosed()) {
            this.con.close();
        }
    }
}

