/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.jdbcdebug.notify;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import jp.co.powerbeans.jdbcdebug.notify.JDBCEventNotifyBase;
import jp.co.powerbeans.jdbcdebug.sql.Driver;

public class FileOutputNotify
extends JDBCEventNotifyBase {
    private static SimpleDateFormat df_file;
    private static final String path;

    static {
        String path_tmp;
        df_file = new SimpleDateFormat("yyyyMMdd_HHmmss");
        path = path_tmp = "/sqlplofile.";
    }

    public void onLoadDriver(Driver driver) {
        FileWriter fr = null;
        try {
            fr = new FileWriter(new File(String.valueOf(path) + driver.toString() + "." + df_file.format(Calendar.getInstance().getTime()) + ".log"), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JDBCEventNotifyBase.driver_hash.put(driver.toString(), fr);
        super.onLoadDriver(driver);
    }

    public void onUnloadDriver(Driver driver) {
        if (JDBCEventNotifyBase.driver_hash.containsKey(driver.toString())) {
            FileWriter fr = (FileWriter)JDBCEventNotifyBase.driver_hash.get(driver.toString());
            try {
                super.onUnloadDriver(driver);
                fr.flush();
                fr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JDBCEventNotifyBase.driver_hash.remove(driver.toString());
        }
    }

    public void out(Driver driver, String log) {
        FileWriter fr = (FileWriter)JDBCEventNotifyBase.driver_hash.get(driver.toString());
        if (fr == null) {
            return;
        }
        this.writeFile(fr, log);
    }

    private void writeFile(FileWriter fr, String log) {
        try {
            fr.write(String.valueOf(log) + "\r\n");
            fr.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void out(Driver driver, String[] logs) {
        FileWriter fr = (FileWriter)JDBCEventNotifyBase.driver_hash.get(driver.toString());
        if (fr == null) {
            return;
        }
        FileWriter fileWriter = fr;
        synchronized (fileWriter) {
            int s = logs.length;
            int i = 0;
            while (i < s) {
                this.writeFile(fr, logs[i]);
                ++i;
            }
        }
    }
}

