/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.jdbcdebug.sql;

import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import jp.co.powerbeans.jdbcdebug.notify.NotifyUtil;
import jp.co.powerbeans.jdbcdebug.sql.Connection;
import jp.co.powerbeans.jdbcdebug.util.ConCheckMgr;
import jp.co.powerbeans.jdbcdebug.util.ConCheckTask;
import jp.co.powerbeans.jdbcdebug.util.Log;
import jp.co.powerbeans.jdbcdebug.util.ValueCheckMgr;

public class Driver
implements java.sql.Driver {
    private java.sql.Driver rdb_driver;
    static final String KEY_DRIVER = "jdDriver";
    public static final String KEY_OUTPUT_TYPE = "jdOutType";
    public static final String KEY_OUTPUT_PREFIX = "jdPrefix";
    public static final String KEY_SQL_CHECK_REGEXP = "SQL.check.regexp";
    public static final String KEY_VALUE_CHECK = "Value.check";
    public static final String KEY_OUTPUT_OVER_TIME = "jdConOverTime";
    public static final String KEY_INTERVAL_TIME = "jdConIntervalTime";
    private String confirm_url = "";
    private Properties confirm_props;
    private static Driver driverInstance;
    private static ValueCheckMgr vm;
    private static final String VALUE_CHECK_SYNC = "";
    private Properties url_prop;

    static {
        Log.println("jdbcdebug driver loaded");
        try {
            DriverManager.registerDriver(new Driver());
            Log.println("jdbcdebug driver registered");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Driver() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        NotifyUtil.onLoadDriver(this);
    }

    public java.sql.Connection connect(String url, Properties info) throws SQLException {
        this.url_prop = this.parseUrl(url);
        this.confirm_props = info;
        this.createDriver();
        return new Connection(this.rdb_driver.connect(this.url_prop.getProperty("url"), info));
    }

    public boolean acceptsURL(String url) throws SQLException {
        this.url_prop = this.parseUrl(url);
        this.createDriver();
        return this.rdb_driver.acceptsURL(this.url_prop.getProperty("url"));
    }

    private void createDriver() throws SQLException {
        if (this.rdb_driver != null) {
            return;
        }
        String driver_name = this.url_prop.getProperty(KEY_DRIVER);
        if (driver_name == null || driver_name.length() == 0) {
            System.err.println("can't get driver_name in url (ex) jdbc:postgresql://localhost/TEST?driver=org.postgresql.Driver&Type=3&Prefix=#SQL#");
        }
        try {
            this.rdb_driver = (java.sql.Driver)Class.forName(driver_name).newInstance();
            driverInstance = this;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
    }

    private Properties parseUrl(String url) {
        Properties prop = new Properties();
        if (url == null || url.length() == 0) {
            return prop;
        }
        String[] keyvals = url.split("\\?");
        if (keyvals == null) {
            return prop;
        }
        if (keyvals.length > 0) {
            prop.setProperty("url", keyvals[0]);
        }
        if (keyvals.length > 1) {
            keyvals = keyvals[1].split("&");
        }
        int i = 0;
        while (i < keyvals.length) {
            String[] keyval = keyvals[i].split("=");
            if (keyval != null && keyval.length >= 2) {
                prop.setProperty(keyval[0], keyval[1]);
            }
            ++i;
        }
        StringBuffer buf = new StringBuffer(prop.getProperty("url"));
        int c = 0;
        int i2 = 0;
        while (i2 < keyvals.length) {
            if (!keyvals[i2].startsWith("jd")) {
                if (c++ == 0) {
                    buf.append("?");
                } else {
                    buf.append("&");
                }
                buf.append(keyvals[i2]);
            }
            ++i2;
        }
        prop.setProperty("url", buf.toString());
        this.confirm_url = prop.getProperty("url");
        Log.applyProperties(prop);
        ConCheckTask.applyProperties(prop);
        ConCheckMgr.initTimer();
        return prop;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.rdb_driver.getPropertyInfo(url, info);
    }

    public int getMajorVersion() {
        return this.rdb_driver.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.rdb_driver.getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return this.rdb_driver.jdbcCompliant();
    }

    public java.sql.Connection connectByConfirm() throws SQLException {
        if (this.confirm_url != null && this.confirm_props != null) {
            return new Connection(this.rdb_driver.connect(this.confirm_url, this.confirm_props));
        }
        return null;
    }

    public static Driver getDriverInstance() {
        return driverInstance;
    }

    protected void finalize() throws Throwable {
        NotifyUtil.onUnloadDriver(this);
        super.finalize();
    }

    public Properties getUrl_prop() {
        return this.url_prop;
    }
}

