/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.jdbcdebug.notify;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import jp.co.powerbeans.jdbcdebug.notify.JDBCEventNotify;
import jp.co.powerbeans.jdbcdebug.sql.Connection;
import jp.co.powerbeans.jdbcdebug.sql.Driver;
import jp.co.powerbeans.jdbcdebug.util.Survey;

public abstract class JDBCEventNotifyBase
implements JDBCEventNotify {
    protected static SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    protected static HashMap driver_hash = new HashMap();
    public static final String CRLF = "\r\n";

    public void onConnection(Driver driver, Connection con) {
        this.out(driver, String.valueOf(this.getDateF()) + " " + "04" + " " + con.toString());
    }

    private String getDateF() {
        return df.format(Calendar.getInstance().getTime());
    }

    public void onConnectionClose(Driver driver, Connection con) {
        this.out(driver, String.valueOf(this.getDateF()) + " " + "03" + " " + con.toString());
    }

    public void onExecuteSql(Driver driver, String sql, Survey survey) {
        this.out(driver, String.valueOf(this.getDateF()) + " " + "10" + " " + (survey.getEndMs() - survey.getStartMs()) + " " + sql);
    }

    public void onExecuteSqlException(Driver driver, String sql, SQLException e) {
        StringBuffer buf = new StringBuffer(String.valueOf(this.getDateF()) + " " + "20" + " " + e.getErrorCode() + " " + e.getMessage() + "\b" + sql + "\b");
        int s = e.getStackTrace().length;
        int i = 0;
        while (i < s) {
            StackTraceElement stack = e.getStackTrace()[i];
            buf.append(String.valueOf(stack.getClassName()) + "." + stack.getMethodName() + "(" + stack.getClass().getName() + ":" + stack.getLineNumber() + ")\b");
            ++i;
        }
        this.out(driver, buf.toString());
    }

    public void onLoadDriver(Driver driver) {
        this.out(driver, String.valueOf(this.getDateF()) + " " + "01" + " " + driver.toString());
    }

    public void onUnloadDriver(Driver driver) {
        this.out(driver, String.valueOf(this.getDateF()) + " " + "02" + " " + driver.toString());
    }
}

