package jp.co.powerbeans.jdbcdebug.notify;

import java.sql.SQLException;

import jp.co.powerbeans.jdbcdebug.sql.Connection;
import jp.co.powerbeans.jdbcdebug.sql.Driver;
import jp.co.powerbeans.jdbcdebug.util.Survey;


/**
 * タイトル: JDBCDebug<BR>
 * 説明:     <BR>
 * 著作権:   Copyright (c) 2004 amonden<BR>
 * 会社名:   <BR>
 * @author   amonden<BR>
 * @version $Revision: 1.1 $
 * 修正履歴
 *   $Log: JDBCEventNotify.java,v $
 *   Revision 1.1  2005/08/24 13:45:44  amsoft
 *   submit for JNDI
 * 
 */

public interface JDBCEventNotify {

    /**
     * @param driver
     * @author  amonden
     */
    public void onLoadDriver(Driver driver);
    
    /**
     * @param driver
     * @author  amonden
     */
    public void onUnloadDriver(Driver driver);

    /**
     * @param driver
     * @param con
     * @author  amonden
     */
    public void onConnection(Driver driver, jp.co.powerbeans.jdbcdebug.sql.Connection con);

    /**
     * @param driver
     * @param con
     * @author  amonden
     */
    public void onConnectionClose(Driver driver, Connection con);

    /**
     * @param driver
     * @param sql
     * @param survey
     * @author  amonden
     */
    public void onExecuteSql(Driver driver, String sql, Survey survey);

    /**
     * @param driver
     * @param sql
     * @param e
     * @author  amonden
     */
    public void onExecuteSqlException(Driver driver, String sql, SQLException e); 

    /**
     * 何かしらにログ出力
     * @param log
     * @author  amonden
     */
    public void out(Driver driver, String log);
    
    /**
     * 何かしらにログ出力(複数ログ)
     * @param driver
     * @param cmds
     * @param logs
     */
    public void out(Driver driver, String[] logs);


}