package jp.co.powerbeans.jdbcdebug.notify;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;

import jp.co.powerbeans.jdbcdebug.sql.Connection;
import jp.co.powerbeans.jdbcdebug.sql.Driver;
import jp.co.powerbeans.jdbcdebug.util.Survey;


/**
 * イベント通知処理共通クラス
 * @author A.Monden
 */
public abstract class JDBCEventNotifyBase implements JDBCEventNotify {

    /** ログ日付フォーマット */
    protected static SimpleDateFormat df = new SimpleDateFormat(
            "yyyy/MM/dd HH:mm:ss");

    /** DriverInstance 毎のFileWriterHash */
    protected static HashMap driver_hash = new HashMap();

    public static final String CRLF = "\r\n";

    /* (Javadoc なし)
     * @see ams.com.ams.jdbcdebug.notify.JDBCEventNotify#onConnection(ams.com.ams.jdbcdebug.sql.Driver, ams.com.ams.jdbcdebug.sql.Connection)
     */
    public void onConnection(Driver driver, Connection con) {

        out(driver, getDateF() + " " + NotifyEventID.CLOSE + " " + con.toString());

    }
    
    /**
     * @return ログ出力用時間を返す
     */
    private String getDateF() {
        return df.format(Calendar.getInstance().getTime());
    }
    
    /* (Javadoc なし)
     * @see ams.com.ams.jdbcdebug.notify.JDBCEventNotify#onConnectionClose(ams.com.ams.jdbcdebug.sql.Driver, ams.com.ams.jdbcdebug.sql.Connection)
     */
    public void onConnectionClose(Driver driver, Connection con) {

        out(driver, getDateF() + " " + NotifyEventID.CONNECT + " " + con.toString());

    }
    /* (Javadoc なし)
     * @see ams.com.ams.jdbcdebug.notify.JDBCEventNotify#onExecuteSql(ams.com.ams.jdbcdebug.sql.Driver, java.lang.String, ams.com.ams.jdbcdebug.util.Survey)
     */
    public void onExecuteSql(Driver driver, String sql, Survey survey) {
        
        out(driver,
                getDateF() + " " + NotifyEventID.SQL + " " +
                (survey.getEndMs() - survey.getStartMs()) + " "
                + sql);
    }
    /* (Javadoc なし)
     * @see ams.com.ams.jdbcdebug.notify.JDBCEventNotify#onExecuteSqlException(ams.com.ams.jdbcdebug.sql.Driver, java.lang.String, java.sql.SQLException)
     */
    public void onExecuteSqlException(Driver driver, String sql, SQLException e) {

//        String[] cmds = {NotifyEventID.SQL_EXCEPTION_MSG,
//                NotifyEventID.SQL_EXCEPTION,
//                NotifyEventID.SQL_EXCEPTION_STACKTRACE
//        };
//        String[] logs = new String[3];
//        
//        // output error code, message, sql
//        logs[0] =  getDateF() + " " + e.getErrorCode() + " " + e.getMessage();
//        
//        // output sql
//        logs[1] = sql;
//        
//        // output stack trace
//        StringBuffer trace = new StringBuffer();
//        int s = e.getStackTrace().length;
//        for(int i = 0; i < s; i++) {
//            StackTraceElement stack = e.getStackTrace()[i];
//            if (i > 0) {
//                trace.append(";");
//            }
//            trace.append(stack.getClassName() + "." + 
//                    stack.getMethodName() + "(" + stack.getClass().getName() + ":" +
//                    stack.getLineNumber() + ")");
//        }
//        logs[2] = trace.toString();
//        out(driver, logs);
        
	      // output error code, message, sql
	      StringBuffer buf = new StringBuffer(
	              getDateF() + " " + NotifyEventID.SQL_EXCEPTION_MSG + " " + 
	              e.getErrorCode() + " " + e.getMessage() +
	              "\b" + sql + "\b");
        int s = e.getStackTrace().length;
        for(int i = 0; i < s; i++) {
            StackTraceElement stack = e.getStackTrace()[i];
            buf.append(stack.getClassName() + "." + 
                    stack.getMethodName() + "(" + stack.getClass().getName() + ":" +
                    stack.getLineNumber() + ")\b");
        }

        out(driver, buf.toString());
    }

    /* (Javadoc なし)
     * @see ams.com.ams.jdbcdebug.notify.JDBCEventNotify#onLoadDriver(ams.com.ams.jdbcdebug.sql.Driver)
     */
    public void onLoadDriver(Driver driver) {
		out(driver, getDateF() + " " + NotifyEventID.LOAD + " " + driver.toString());
    }
    
    /* (Javadoc なし)
     * @see ams.com.ams.jdbcdebug.notify.JDBCEventNotify#onUnloadDriver(ams.com.ams.jdbcdebug.sql.Driver)
     */
    public void onUnloadDriver(Driver driver) {
        out(driver, getDateF() + " " + NotifyEventID.UNLOAD + " " + driver.toString());
    }
}