package jp.co.powerbeans.jdbcdebug.notify;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;

import jp.co.powerbeans.jdbcdebug.sql.Driver;


/**
 * JDBCｲﾍﾞﾝﾄをUDP通信で送信するクラス(テスト中)
 * 
 * @author A.Monden
 */
public class UDPSocketNotify extends JDBCEventNotifyBase {

    private InetSocketAddress remoteAddress;

    /**
     *  
     */
    public UDPSocketNotify() {
        super();
        remoteAddress = new InetSocketAddress("localhost", 28945);
    }

    /*
     * (Javadoc なし)
     * 
     * @see ams.com.ams.jdbcdebug.notify.JDBCEventNotify#out(ams.com.ams.jdbcdebug.sql.Driver,
     *      java.lang.String, java.lang.String)
     */
    public void out(Driver driver, String log) {
        if (remoteAddress == null) {
            return;
        }

        byte[] buf = log.getBytes();
        DatagramSocket socket = null;
        DatagramPacket packet = null;
        try {
            socket = new DatagramSocket();
            packet = new DatagramPacket(buf, buf.length,
                    remoteAddress);
            // 送信
            socket.send(packet);
        } catch (SocketException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    /*
     * (Javadoc なし)
     * 
     * @see ams.com.ams.jdbcdebug.notify.JDBCEventNotify#out(ams.com.ams.jdbcdebug.sql.Driver,
     *      java.lang.String[], java.lang.String[])
     */
    public void out(Driver driver, String[] logs) {
        if (remoteAddress == null) {
            return;
        }

        DatagramSocket socket = null;
        DatagramPacket packet = null;
        try {
            socket = new DatagramSocket();
            for(int i = 0; i < logs.length; i++) {
                byte[] buf = logs[i].getBytes();
	            packet = new DatagramPacket(buf, buf.length,
	                    remoteAddress);
	            // 送信
	            socket.send(packet);
	            // ここで改行ｺｰﾄﾞを送るか？
            }
        } catch (SocketException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

}